/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.busi.ActGiftNumUpdateBusiService;
import com.tydic.newretail.busi.bo.ActGiftNumUpdateBusiReqBO;
import com.tydic.newretail.busi.bo.ActGiftNumUpdateBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveGiftStockMapper;
import com.tydic.newretail.dao.po.ActiveGiftStockPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actGiftNumUpdateBusiService")
public class ActGiftNumUpdateBusiServiceImpl
implements ActGiftNumUpdateBusiService {
    private ActiveGiftStockMapper activeGiftStockMapper;

    @Autowired
    private ActGiftNumUpdateBusiServiceImpl(ActiveGiftStockMapper activeGiftStockMapper) {
        this.activeGiftStockMapper = activeGiftStockMapper;
    }

    public ActGiftNumUpdateBusiRspBO updateGiftNum(ActGiftNumUpdateBusiReqBO actGiftNumUpdateReqBO) {
        ActGiftNumUpdateBusiRspBO rspBO = new ActGiftNumUpdateBusiRspBO();
        if (actGiftNumUpdateReqBO.getOperNum() == null) {
            actGiftNumUpdateReqBO.setOperNum(Integer.valueOf(1));
        }
        ActiveGiftStockPO giftStockPO = new ActiveGiftStockPO();
        giftStockPO.setActiveId(actGiftNumUpdateReqBO.getActiveId());
        giftStockPO.setSkuId(actGiftNumUpdateReqBO.getSkuId());
        giftStockPO = this.activeGiftStockMapper.getModelBy(giftStockPO);
        if (giftStockPO == null) {
            rspBO.setRespCode("2003");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8d60\u54c1\u5e93\u5b58\u4fe1\u606f");
            return rspBO;
        }
        Integer giftCount = giftStockPO.getGiftCount();
        Integer sendCount = giftStockPO.getSendCount();
        if (giftCount == null) {
            rspBO.setRespCode("2003");
            rspBO.setRespDesc("\u6d3b\u52a8[" + actGiftNumUpdateReqBO.getActiveId() + "]\u7684\u8d60\u54c1[" + actGiftNumUpdateReqBO.getSkuId() + "]\u672a\u914d\u7f6e\u8d60\u9001\u6570\u91cf");
            return rspBO;
        }
        if (ActCommConstant.ACT_COUNT_DEFAULT_VALUE.equals(giftCount)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6d3b\u52a8[" + actGiftNumUpdateReqBO.getActiveId() + "]\u7684\u8d60\u54c1[" + actGiftNumUpdateReqBO.getSkuId() + "]\u6570\u91cf\u914d\u7f6e\u4e3a\u65e0\u9650\u5236\uff0c\u65e0\u9700\u66f4\u65b0");
            return rspBO;
        }
        Integer operNum = actGiftNumUpdateReqBO.getOperNum();
        if (ActCommConstant.ADD_OPER.equals(actGiftNumUpdateReqBO.getOperType())) {
            if (giftCount < sendCount + operNum) {
                rspBO.setRespCode("2003");
                rspBO.setRespDesc("\u6d3b\u52a8[" + actGiftNumUpdateReqBO.getActiveId() + "]\u5f53\u524d\u8d60\u9001\u8d60\u54c1[" + actGiftNumUpdateReqBO.getSkuId() + "]\u6570\u91cf\u5df2\u8d85\u8fc7\u8bbe\u7f6e\u7684\u53ef\u8d60\u9001\u6570\u91cf");
                return rspBO;
            }
        } else if (ActCommConstant.REDUCE_OPER.equals(actGiftNumUpdateReqBO.getOperType())) {
            if (sendCount - operNum < 0) {
                rspBO.setRespCode("2003");
                rspBO.setRespDesc("\u6d3b\u52a8[" + actGiftNumUpdateReqBO.getActiveId() + "]\u5f53\u524d\u8fd4\u8fd8\u8d60\u54c1[" + actGiftNumUpdateReqBO.getSkuId() + "]\u6570\u91cf\u5df2\u8d85\u8fc7\u5df2\u8d60\u9001\u51fa\u53bb\u7684\u6570\u91cf");
                return rspBO;
            }
            operNum = -operNum.intValue();
        }
        ActiveGiftStockPO updateCount = new ActiveGiftStockPO();
        updateCount.setActiveId(actGiftNumUpdateReqBO.getActiveId());
        updateCount.setSkuId(actGiftNumUpdateReqBO.getSkuId());
        updateCount.setSendCount(operNum);
        int updateResult = this.activeGiftStockMapper.updateStockCount(updateCount);
        if (updateResult < 1) {
            rspBO.setRespCode("2003");
            rspBO.setRespDesc("\u66f4\u65b0\u5df2\u8d60\u9001\u8d60\u54c1\u6570\u91cf\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u66f4\u65b0\u5df2\u8d60\u9001\u8d60\u54c1\u6570\u91cf\u6210\u529f");
        return rspBO;
    }
}

