/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.comb.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.busi.ActCycleCalculateBusiService;
import com.tydic.newretail.busi.ActReceiveCouponBusiService;
import com.tydic.newretail.busi.ActReceiveCouponRollBackBusiService;
import com.tydic.newretail.busi.ActUpdateCouponNumBusiService;
import com.tydic.newretail.busi.bo.ActCycleCalculateBusiReqBO;
import com.tydic.newretail.busi.bo.ActCycleCalculateBusiRspBO;
import com.tydic.newretail.busi.bo.ActReceiveCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActReceiveCouponBusiRspBO;
import com.tydic.newretail.busi.bo.ActReceiveCouponRollBackBusiReqBO;
import com.tydic.newretail.busi.bo.ActReceiveCouponRollBackBusiRspBO;
import com.tydic.newretail.busi.bo.ActUpdateCouponNumBusiReqBO;
import com.tydic.newretail.busi.bo.ActUpdateCouponNumBusiRspBO;
import com.tydic.newretail.comb.ActCouponSendCombService;
import com.tydic.newretail.comb.bo.ActCouponSendCombReqBO;
import com.tydic.newretail.comb.bo.ActCouponSendCombRspBO;
import com.tydic.newretail.dao.CouponAmountMapper;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.CouponSendRuleMapper;
import com.tydic.newretail.dao.po.CouponAmountPO;
import com.tydic.newretail.dao.po.CouponInstPO;
import com.tydic.newretail.dao.po.CouponSendRulePO;
import com.tydic.umc.ability.UmcQryCouponListAbilityService;
import com.tydic.umc.ability.bo.UmcQryCouponListAbilityReqBO;
import com.tydic.umc.ability.bo.UmcQryCouponListAbilityRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponSendCombService")
public class ActCouponSendCombServiceImpl
implements ActCouponSendCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCouponSendCombServiceImpl.class);
    private CouponSendRuleMapper couponSendRuleMapper;
    private CouponAmountMapper couponAmountMapper;
    private CouponInstMapper couponInstMapper;
    private ActCycleCalculateBusiService actCycleCalculateBusiService;
    private ActReceiveCouponBusiService actReceiveCouponBusiService;
    private ActUpdateCouponNumBusiService actUpdateCouponNumBusiService;
    private ActReceiveCouponRollBackBusiService actReceiveCouponRollBackBusiService;
    private UmcQryCouponListAbilityService umcQryCouponListAbilityService;

    @Autowired
    private ActCouponSendCombServiceImpl(CouponSendRuleMapper couponSendRuleMapper, CouponAmountMapper couponAmountMapper, CouponInstMapper couponInstMapper, ActCycleCalculateBusiService actCycleCalculateBusiService, ActReceiveCouponBusiService actReceiveCouponBusiService, ActUpdateCouponNumBusiService actUpdateCouponNumBusiService, ActReceiveCouponRollBackBusiService actReceiveCouponRollBackBusiService, UmcQryCouponListAbilityService umcQryCouponListAbilityService) {
        this.couponSendRuleMapper = couponSendRuleMapper;
        this.couponAmountMapper = couponAmountMapper;
        this.couponInstMapper = couponInstMapper;
        this.actCycleCalculateBusiService = actCycleCalculateBusiService;
        this.actReceiveCouponBusiService = actReceiveCouponBusiService;
        this.actUpdateCouponNumBusiService = actUpdateCouponNumBusiService;
        this.actReceiveCouponRollBackBusiService = actReceiveCouponRollBackBusiService;
        this.umcQryCouponListAbilityService = umcQryCouponListAbilityService;
    }

    public ActCouponSendCombRspBO sendCoupon(ActCouponSendCombReqBO reqBO) {
        CouponSendRulePO paramPO = new CouponSendRulePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)paramPO);
        List<CouponSendRulePO> ruleList = this.couponSendRuleMapper.getList(paramPO);
        if (CollectionUtils.isEmpty(ruleList)) {
            throw new BusinessException("6001", "\u672a\u67e5\u8be2\u5230\u4f18\u60e0\u5238\u8d60\u9001\u89c4\u5219");
        }
        ArrayList<String> couponList = new ArrayList<String>();
        for (CouponSendRulePO sendRulePO : ruleList) {
            if (sendRulePO.getMaxNum() != null) {
                this.checkCycleCouponNum(reqBO.getMemId(), sendRulePO);
            }
            CouponAmountPO couponAmountPO = new CouponAmountPO();
            BeanUtils.copyProperties((Object)sendRulePO, (Object)couponAmountPO);
            couponAmountPO = this.couponAmountMapper.getModelBy(couponAmountPO);
            if (couponAmountPO != null && couponAmountPO.getDistrCount() >= couponAmountPO.getTotalCount()) {
                throw new BusinessException("6001", "\u8be5\u89c4\u683c\u4f18\u60e0\u5238\u6d3e\u53d1\u6570\u91cf\u8d85\u8fc7\u603b\u91cf\uff0c\u4e0d\u80fd\u518d\u6b21\u9886\u53d6[fmId=" + sendRulePO.getFmId() + "]\uff01");
            }
            couponList.addAll(this.getRandomCoupon(reqBO.getMemId(), sendRulePO));
        }
        ActCouponSendCombRspBO rspBO = new ActCouponSendCombRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u8d60\u9001\u6210\u529f");
        rspBO.setCouponList(couponList);
        return rspBO;
    }

    private void checkCycleCouponNum(Long memId, CouponSendRulePO sendRulePO) {
        UmcQryCouponListAbilityReqBO qryCouponListReqBO = new UmcQryCouponListAbilityReqBO();
        if (sendRulePO.getCirId() != null) {
            ActCycleCalculateBusiReqBO cycleCalculateReqBO = new ActCycleCalculateBusiReqBO();
            cycleCalculateReqBO.setCircleId(sendRulePO.getCirId());
            ActCycleCalculateBusiRspBO cycleCalculateRspBO = this.actCycleCalculateBusiService.dealCycleCalculate(cycleCalculateReqBO);
            if ("0000".equals(cycleCalculateRspBO.getRespCode())) {
                qryCouponListReqBO.setStartGetTime(DateUtils.dateToStrLong((Date)cycleCalculateRspBO.getBeginTime()));
                qryCouponListReqBO.setEndGetTime(DateUtils.dateToStrLong((Date)cycleCalculateRspBO.getEndTime()));
            } else {
                throw new BusinessException("6001", "\u8be5\u89c4\u683c\u4f18\u60e0\u5238\u8d60\u9001\u5468\u671f\u914d\u7f6e\u9519\u8bef[fmId=" + sendRulePO.getFmId() + "]\uff01" + cycleCalculateRspBO.getRespDesc());
            }
        }
        qryCouponListReqBO.setMemId(memId);
        qryCouponListReqBO.setFmId(sendRulePO.getFmId());
        UmcQryCouponListAbilityRspBO qryCouponListRspBO = this.umcQryCouponListAbilityService.qryCouponList(qryCouponListReqBO);
        if ("0000".equals(qryCouponListRspBO.getRespCode()) && qryCouponListRspBO.getRecordsTotal() >= sendRulePO.getMaxNum()) {
            throw new BusinessException("6001", "\u4f1a\u5458\u9886\u53d6\u8be5\u89c4\u683c\u4f18\u60e0\u5238\u8d85\u8fc7\u6700\u5927\u9886\u53d6\u6570\u91cf\uff0c\u4e0d\u80fd\u518d\u6b21\u9886\u53d6[fmId=" + sendRulePO.getFmId() + "]\uff01");
        }
    }

    private List<String> getRandomCoupon(Long memId, CouponSendRulePO sendRulePO) {
        int sendNum;
        CouponInstPO paramPO = new CouponInstPO();
        BeanUtils.copyProperties((Object)sendRulePO, (Object)paramPO);
        List<CouponInstPO> couponInstList = this.couponInstMapper.getSendCouponNo(paramPO);
        if (CollectionUtils.isEmpty(couponInstList)) {
            throw new BusinessException("6001", "\u672a\u67e5\u8be2\u5230\u53ef\u9886\u53d6\u4f18\u60e0\u5238");
        }
        int allNum = couponInstList.size();
        int n = sendNum = sendRulePO.getDoneNum() != null ? sendRulePO.getDoneNum() : 1;
        if (allNum < sendNum) {
            throw new BusinessException("6001", "\u53ef\u9886\u53d6\u4f18\u60e0\u5238\u6570\u91cf[" + allNum + "]\u5c0f\u4e8e\u89c4\u5219\u914d\u7f6e\u6570\u91cf[" + sendNum + "]");
        }
        ArrayList<String> successList = new ArrayList<String>();
        List<String> couponNoList = couponInstList.stream().skip(allNum - sendNum).map(CouponInstPO::getCouponNo).collect(Collectors.toList());
        for (String coupon : couponNoList) {
            ActReceiveCouponBusiReqBO receiveCouponReqBO = new ActReceiveCouponBusiReqBO();
            receiveCouponReqBO.setCouponNo(coupon);
            receiveCouponReqBO.setCouponSystem("ACT");
            receiveCouponReqBO.setMemId(memId);
            ActReceiveCouponBusiRspBO receiveCouponRspBO = this.actReceiveCouponBusiService.receiveCoupon(receiveCouponReqBO);
            if (!"0000".equals(receiveCouponRspBO.getRespCode())) {
                this.rollBackCouponState(memId, successList, "\u4f18\u60e0\u5238\u9886\u53d6\u5931\u8d25[coupon=" + coupon + "]!" + receiveCouponRspBO.getRespDesc());
                continue;
            }
            successList.add(coupon);
        }
        ActUpdateCouponNumBusiReqBO updateCouponNumReqBO = new ActUpdateCouponNumBusiReqBO();
        BeanUtils.copyProperties((Object)sendRulePO, (Object)updateCouponNumReqBO);
        updateCouponNumReqBO.setDistrCount(Integer.valueOf(sendNum));
        ActUpdateCouponNumBusiRspBO updateCouponNumRspBO = this.actUpdateCouponNumBusiService.updateCouponNum(updateCouponNumReqBO);
        if (!"0000".equals(updateCouponNumRspBO.getRespCode())) {
            this.rollBackCouponState(memId, successList, updateCouponNumRspBO.getRespDesc() + "[fmId=" + updateCouponNumReqBO.getFmId() + "]");
        }
        return couponNoList;
    }

    private void rollBackCouponState(Long memId, List<String> couponList, String errorDesc) {
        LOGGER.error(errorDesc);
        for (String couponNo : couponList) {
            ActReceiveCouponRollBackBusiReqBO rollBackBusiReqBO = new ActReceiveCouponRollBackBusiReqBO();
            rollBackBusiReqBO.setCouponNo(couponNo);
            rollBackBusiReqBO.setMemId(memId);
            ActReceiveCouponRollBackBusiRspBO rollBackBusiRspBO = this.actReceiveCouponRollBackBusiService.receiveCouponRollBack(rollBackBusiReqBO);
            if ("0000".equals(rollBackBusiRspBO.getRespCode())) continue;
            LOGGER.error(rollBackBusiRspBO.getRespDesc() + "[couponNo=" + couponNo + "]");
        }
        throw new BusinessException("7001", errorDesc);
    }
}

