/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.comb.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.atom.ActQueryActiveInfoAtomService;
import com.tydic.newretail.atom.bo.ActQueryActiveInfoAtomReqBO;
import com.tydic.newretail.atom.bo.ActQueryActiveInfoAtomRspBO;
import com.tydic.newretail.comb.ActQryGroupActivityCombService;
import com.tydic.newretail.comb.bo.ActQryGroupActivityCombReqBO;
import com.tydic.newretail.comb.bo.ActQryGroupActivityCombRspBO;
import com.tydic.newretail.common.bo.ActQryGroupActivityBO;
import com.tydic.newretail.common.bo.AllActiveInfoBO;
import com.tydic.newretail.dao.SpecialSqlMapper;
import com.tydic.newretail.dao.po.ShopActivePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actQryGroupActivityCombService")
public class ActQryGroupActivityCombServiceImpl
implements ActQryGroupActivityCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActQryGroupActivityCombServiceImpl.class);
    private SpecialSqlMapper specialSqlMapper;
    private ActQueryActiveInfoAtomService actQueryActiveInfoAtomService;

    @Autowired
    private ActQryGroupActivityCombServiceImpl(SpecialSqlMapper specialSqlMapper, ActQueryActiveInfoAtomService actQueryActiveInfoAtomService) {
        this.specialSqlMapper = specialSqlMapper;
        this.actQueryActiveInfoAtomService = actQueryActiveInfoAtomService;
    }

    public ActQryGroupActivityCombRspBO qryGroupActivity(ActQryGroupActivityCombReqBO reqBO) {
        ActQryGroupActivityCombRspBO rspBO = new ActQryGroupActivityCombRspBO();
        ArrayList<ActQryGroupActivityBO> shopActiveInfoList = new ArrayList<ActQryGroupActivityBO>();
        rspBO.setActiveInfoList(shopActiveInfoList);
        rspBO.setRespCode("0000");
        HashMap shopActiveMap = new HashMap(reqBO.getPageSize());
        HashMap<Long, String> shopNameMap = new HashMap<Long, String>(reqBO.getPageSize());
        ShopActivePO shopActivePO = new ShopActivePO();
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        page.setLimit(reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        List<ActQryGroupActivityBO> shopList = this.specialSqlMapper.qryValidShopGroupByPage(shopActivePO, (Page<Map<String, Object>>)page);
        rspBO.setTotalRecords(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotalPages(Integer.valueOf(page.getTotalPages()));
        if (CollectionUtils.isEmpty(shopList)) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6709\u6548\u6d3b\u52a8\u4fe1\u606f");
            return rspBO;
        }
        for (ActQryGroupActivityBO actQryGroupActivityBO : shopList) {
            List<AllActiveInfoBO> allActiveList = this.specialSqlMapper.qryActivityInfo(actQryGroupActivityBO);
            if (CollectionUtils.isEmpty(allActiveList)) {
                LOGGER.error("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f[shopId=" + actQryGroupActivityBO.getShopId() + "]");
                continue;
            }
            Integer noQueryDetail = 1;
            for (AllActiveInfoBO activeInfoBO : allActiveList) {
                if (!noQueryDetail.equals(reqBO.getIsQueryDetail())) {
                    ActQueryActiveInfoAtomReqBO qryActiveInfoReqBO = new ActQueryActiveInfoAtomReqBO();
                    qryActiveInfoReqBO.setActiveId(activeInfoBO.getActiveId());
                    ActQueryActiveInfoAtomRspBO qryActiveInfoRspBO = this.actQueryActiveInfoAtomService.queryActiveInfo(qryActiveInfoReqBO);
                    if (!"0000".equals(qryActiveInfoRspBO.getRespCode())) {
                        LOGGER.error("\u672a\u67e5\u8be2\u5230\u5e97\u94fa\u6d3b\u52a8\u8be6\u7ec6\u4fe1\u606f[activeId=" + activeInfoBO.getActiveId() + "]");
                    }
                    activeInfoBO.setActiveAttributeList(qryActiveInfoRspBO.getActiveAttributeList());
                    activeInfoBO.setActiveExclusionRuleList(qryActiveInfoRspBO.getActiveExclusionRuleList());
                    activeInfoBO.setActiveGiftList(qryActiveInfoRspBO.getActiveGiftList());
                    activeInfoBO.setActiveGiftPkgList(qryActiveInfoRspBO.getActiveGiftPkgList());
                }
                if (shopActiveMap.containsKey(actQryGroupActivityBO.getShopId())) {
                    ((List)shopActiveMap.get(actQryGroupActivityBO.getShopId())).add(activeInfoBO);
                } else {
                    ArrayList<AllActiveInfoBO> activeInfoList = new ArrayList<AllActiveInfoBO>();
                    activeInfoList.add(activeInfoBO);
                    shopActiveMap.put(actQryGroupActivityBO.getShopId(), activeInfoList);
                }
                if (!StringUtils.isNotBlank((String)actQryGroupActivityBO.getShopName())) continue;
                shopNameMap.put(actQryGroupActivityBO.getShopId(), actQryGroupActivityBO.getShopName());
            }
        }
        if (shopActiveMap.isEmpty()) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5e97\u94fa\u6d3b\u52a8\u4fe1\u606f");
            return rspBO;
        }
        for (Map.Entry entry : shopActiveMap.entrySet()) {
            ActQryGroupActivityBO groupActivityBO = new ActQryGroupActivityBO();
            groupActivityBO.setShopId((Long)entry.getKey());
            groupActivityBO.setShopName((String)shopNameMap.get(entry.getKey()));
            groupActivityBO.setActiveInfoList((List)entry.getValue());
            shopActiveInfoList.add(groupActivityBO);
        }
        rspBO.setRespDesc("\u6d3b\u52a8\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

