/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActCouponValidCheckAtomService;
import com.tydic.newretail.atom.bo.ActCouponValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCouponValidCheckAtomRspBO;
import com.tydic.newretail.busi.ActReceiveCouponRollBackBusiService;
import com.tydic.newretail.busi.bo.ActReceiveCouponRollBackBusiReqBO;
import com.tydic.newretail.busi.bo.ActReceiveCouponRollBackBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.po.CouponInstPO;
import com.tydic.umc.ability.UmcCouponDeleteAbilityService;
import com.tydic.umc.ability.bo.UmcCouponDeleteAbilityReqBO;
import com.tydic.umc.ability.bo.UmcCouponDeleteAbilityRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actReceiveCouponRollBackBusiService")
public class ActReceiveCouponRollBackBusiServiceImpl
implements ActReceiveCouponRollBackBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActReceiveCouponRollBackBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private UmcCouponDeleteAbilityService umcCouponDeleteAbilityService;
    private ActCouponValidCheckAtomService actCouponValidCheckAtomService;
    private CouponInstMapper couponInstMapper;

    @Autowired
    public ActReceiveCouponRollBackBusiServiceImpl(UmcCouponDeleteAbilityService umcCouponDeleteAbilityService, ActCouponValidCheckAtomService actCouponValidCheckAtomService, CouponInstMapper couponInstMapper) {
        this.umcCouponDeleteAbilityService = umcCouponDeleteAbilityService;
        this.actCouponValidCheckAtomService = actCouponValidCheckAtomService;
        this.couponInstMapper = couponInstMapper;
    }

    public ActReceiveCouponRollBackBusiRspBO receiveCouponRollBack(ActReceiveCouponRollBackBusiReqBO reqBO) {
        ActReceiveCouponRollBackBusiRspBO rspBO = new ActReceiveCouponRollBackBusiRspBO();
        ActCouponValidCheckAtomReqBO checkAtomReqBO = new ActCouponValidCheckAtomReqBO();
        checkAtomReqBO.setCouponNo(reqBO.getCouponNo());
        ActCouponValidCheckAtomRspBO checkAtomRspBO = this.actCouponValidCheckAtomService.checkCouponValid(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u8c03\u7528\u4f18\u60e0\u5238\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            }
            rspBO.setRespCode("2027");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u6709\u6548\u6821\u9a8c\u5931\u8d25");
            return rspBO;
        }
        if (!ActCommConstant.CouponValidMark.VALID.equals(checkAtomRspBO.getCouponValidMark())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u4f18\u60e0\u5238\u65e0\u6548");
            return rspBO;
        }
        UmcCouponDeleteAbilityReqBO umcReqBO = new UmcCouponDeleteAbilityReqBO();
        umcReqBO.setMemId(reqBO.getMemId());
        umcReqBO.setCouponNo(reqBO.getCouponNo());
        UmcCouponDeleteAbilityRspBO umcRspBO = this.umcCouponDeleteAbilityService.deleteCoupon(umcReqBO);
        if (!"0000".equals(umcRspBO.getRespCode())) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u9886\u53d6\u56de\u9000\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f18\u60e0\u5238\u5220\u9664\u670d\u52a1\u5931\u8d25" + umcRspBO.getRespDesc());
            }
            rspBO.setRespCode("2028");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u56de\u9000\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5916\u90e8\u670d\u52a1\u5931\u8d25" + umcRspBO.getRespDesc());
            return rspBO;
        }
        CouponInstPO couponInstPO = new CouponInstPO();
        couponInstPO.setCouponNo(reqBO.getCouponNo());
        couponInstPO.setState(ActCommConstant.CouponState.TO_BE_RECEIVED);
        int result = this.couponInstMapper.update4ReceiveBack(couponInstPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u9886\u53d6\u56de\u9000\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u8868\u5931\u8d25\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6052", "\u4f18\u60e0\u5238\u9886\u53d6\u56de\u9000\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u8868\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u56de\u9000\u6210\u529f");
        return rspBO;
    }
}

