/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActSeckNumUpdateBusiService;
import com.tydic.newretail.busi.bo.ActSeckNumUpdateBusiReqBO;
import com.tydic.newretail.busi.bo.ActSeckNumUpdateBusiRspBO;
import com.tydic.newretail.dao.CommodityKillSkuMapper;
import com.tydic.newretail.dao.po.CommodityKillSkuPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSeckNumUpdateBusiService")
public class ActSeckNumUpdateBusiServiceImpl
implements ActSeckNumUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSeckNumUpdateBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private static final String SUCCESS_MSG = "\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u6210\u529f";
    private static final String ERROR_MSG = "\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u5931\u8d25";
    private static final String INCREASE = "0";
    private static final String REDUCE = "1";
    @Autowired
    private CommodityKillSkuMapper commodityKillSkuMapper;

    public ActSeckNumUpdateBusiRspBO updateSeckNum(ActSeckNumUpdateBusiReqBO reqBO) {
        ActSeckNumUpdateBusiRspBO rspBO = new ActSeckNumUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(SUCCESS_MSG);
        if (INCREASE.equals(reqBO.getOperType())) {
            this.increaseSeckNum(reqBO, rspBO);
        } else if (REDUCE.equals(reqBO.getOperType())) {
            this.reduceSeckNum(reqBO, rspBO);
        } else {
            rspBO.setRespCode("2002");
            rspBO.setRespDesc("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        return rspBO;
    }

    private void increaseSeckNum(ActSeckNumUpdateBusiReqBO reqBO, ActSeckNumUpdateBusiRspBO rspBO) {
        CommodityKillSkuPO killSkuPO = new CommodityKillSkuPO();
        killSkuPO.setSkuState(1);
        if (!StringUtils.isBlank((CharSequence)reqBO.getCycId())) {
            killSkuPO.setKillCycleId(Long.valueOf(reqBO.getCycId()));
        }
        killSkuPO.setShopId(Long.valueOf(reqBO.getShopId()));
        killSkuPO.setSkuId(reqBO.getSkuId());
        CommodityKillSkuPO skuPO = null;
        skuPO = this.commodityKillSkuMapper.getModelBy(killSkuPO);
        if (null == skuPO) {
            rspBO.setRespCode("2001");
            rspBO.setRespDesc("\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a");
            return;
        }
        if (skuPO.getLockNum() + Integer.valueOf(reqBO.getOperNum()) > skuPO.getActualNum()) {
            rspBO.setRespCode("2002");
            rspBO.setRespDesc("\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u53ef\u64cd\u4f5c\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            return;
        }
        CommodityKillSkuPO commodityKillSkuPO = new CommodityKillSkuPO();
        commodityKillSkuPO.setPlateRelId(skuPO.getPlateRelId());
        commodityKillSkuPO.setLockNum(skuPO.getLockNum() + Integer.valueOf(reqBO.getOperNum()));
        int result = this.commodityKillSkuMapper.updateById(commodityKillSkuPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\uff0c\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6082", "\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void reduceSeckNum(ActSeckNumUpdateBusiReqBO reqBO, ActSeckNumUpdateBusiRspBO rspBO) {
        CommodityKillSkuPO killSkuPO = new CommodityKillSkuPO();
        killSkuPO.setSkuState(1);
        if (!StringUtils.isBlank((CharSequence)reqBO.getCycId())) {
            killSkuPO.setKillCycleId(Long.valueOf(reqBO.getCycId()));
        }
        killSkuPO.setShopId(Long.valueOf(reqBO.getShopId()));
        killSkuPO.setSkuId(reqBO.getSkuId());
        CommodityKillSkuPO skuPO = null;
        skuPO = this.commodityKillSkuMapper.getModelBy(killSkuPO);
        if (null == skuPO) {
            rspBO.setRespCode("2001");
            rspBO.setRespDesc("\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a");
            return;
        }
        if (skuPO.getLockNum() - Integer.valueOf(reqBO.getOperNum()) < 0) {
            rspBO.setRespCode("2002");
            rspBO.setRespDesc("\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u53ef\u64cd\u4f5c\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            return;
        }
        CommodityKillSkuPO commodityKillSkuPO = new CommodityKillSkuPO();
        commodityKillSkuPO.setPlateRelId(skuPO.getPlateRelId());
        commodityKillSkuPO.setLockNum(skuPO.getLockNum() - Integer.valueOf(reqBO.getOperNum()));
        int result = this.commodityKillSkuMapper.updateById(commodityKillSkuPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\uff0c\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6082", "\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
    }
}

