/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActUpdateCouponStatusBusiService;
import com.tydic.newretail.busi.bo.ActUpdateCouponStatusBusiReqBO;
import com.tydic.newretail.busi.bo.ActUpdateCouponStatusBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.po.CouponInstPO;
import com.tydic.umc.ability.UmcUpdateCouponStateAbilityService;
import com.tydic.umc.ability.bo.UmcUpdateCouponStateAbilityReqBO;
import com.tydic.umc.ability.bo.UmcUpdateCouponStateAbilityRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actUpdateCouponStatusBusiService")
public class ActUpdateCouponStatusBusiServiceImpl
implements ActUpdateCouponStatusBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActUpdateCouponStatusBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private UmcUpdateCouponStateAbilityService umcUpdateCouponStateAbilityService;
    private CouponInstMapper couponInstMapper;

    @Autowired
    public ActUpdateCouponStatusBusiServiceImpl(UmcUpdateCouponStateAbilityService umcUpdateCouponStateAbilityService, CouponInstMapper couponInstMapper) {
        this.umcUpdateCouponStateAbilityService = umcUpdateCouponStateAbilityService;
        this.couponInstMapper = couponInstMapper;
    }

    public ActUpdateCouponStatusBusiRspBO updateCouponStatus(ActUpdateCouponStatusBusiReqBO reqBO) {
        ActUpdateCouponStatusBusiRspBO rspBO = new ActUpdateCouponStatusBusiRspBO();
        CouponInstPO couponPO = this.couponInstMapper.getModelById(reqBO.getCouponNo());
        if (null == couponPO) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3anull");
            }
            rspBO.setRespCode("2025");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
            return rspBO;
        }
        if (null != couponPO.getMemId()) {
            Integer state = this.transState(reqBO.getState());
            UmcUpdateCouponStateAbilityReqBO umcReqBO = new UmcUpdateCouponStateAbilityReqBO();
            umcReqBO.setUsedState(state);
            umcReqBO.setFmId(couponPO.getFmId());
            umcReqBO.setCouponType(couponPO.getCouponType());
            umcReqBO.setMemId(reqBO.getMemId());
            umcReqBO.setCouponSystem(reqBO.getCouponSystem());
            umcReqBO.setCouponNo(reqBO.getCouponNo());
            UmcUpdateCouponStateAbilityRspBO umcRspBO = this.umcUpdateCouponStateAbilityService.updateState(umcReqBO);
            if (!"0000".equals(umcRspBO.getRespCode())) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u4f18\u60e0\u5238\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f18\u60e0\u5238\u72b6\u6001\u66f4\u65b0\u670d\u52a1\u5931\u8d25" + umcRspBO.getRespDesc());
                }
                rspBO.setRespCode("2026");
                rspBO.setRespDesc("\u4f18\u60e0\u5238\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5916\u90e8\u670d\u52a1\u5931\u8d25" + umcRspBO.getRespDesc());
                return rspBO;
            }
        }
        CouponInstPO couponInstPO = new CouponInstPO();
        couponInstPO.setState(reqBO.getState());
        couponInstPO.setCouponNo(reqBO.getCouponNo());
        int result = this.couponInstMapper.updateById(couponInstPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25\uff0cupdate\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6043", "\u4f18\u60e0\u5238\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u72b6\u6001\u53d8\u66f4\u6210\u529f");
        return rspBO;
    }

    private Integer transState(Integer actState) {
        Integer state = null;
        if (ActCommConstant.CouponState.CREATED.equals(actState) || ActCommConstant.CouponState.TO_BE_RECEIVED.equals(actState) || ActCommConstant.CouponState.TO_BE_USED.equals(actState)) {
            state = ActCommConstant.MemberCouponState.UNUSED;
        } else if (ActCommConstant.CouponState.USED.equals(actState)) {
            state = ActCommConstant.MemberCouponState.USED;
        } else if (ActCommConstant.CouponState.EXPIRED.equals(actState)) {
            state = ActCommConstant.MemberCouponState.EXPIRED;
        }
        return state;
    }
}

