/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActDeleteRedisCacheAtomService;
import com.tydic.newretail.atom.bo.ActDeleteRedisCacheAtomReqBO;
import com.tydic.newretail.busi.ActActStartStopBusiService;
import com.tydic.newretail.busi.bo.ActActStartStopBusiReqBO;
import com.tydic.newretail.busi.bo.ActActStartStopBusiRspBO;
import com.tydic.newretail.common.bo.ChooseActivityBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActStartStopBusiService")
public class ActActStartStopBusiServiceImpl
implements ActActStartStopBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActStartStopBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private SkuActiveMapper skuActiveMapper;
    private ActivityMapper activityMapper;
    private ActDeleteRedisCacheAtomService actDeleteRedisCacheAtomService;

    @Autowired
    private ActActStartStopBusiServiceImpl(SkuActiveMapper skuActiveMapper, ActivityMapper activityMapper, ActDeleteRedisCacheAtomService actDeleteRedisCacheAtomService) {
        this.skuActiveMapper = skuActiveMapper;
        this.activityMapper = activityMapper;
        this.actDeleteRedisCacheAtomService = actDeleteRedisCacheAtomService;
    }

    public ActActStartStopBusiRspBO dealStartStop(ActActStartStopBusiReqBO busiReqBO) {
        ActActStartStopBusiRspBO rsp = new ActActStartStopBusiRspBO();
        for (ChooseActivityBO chooseActivityBO : busiReqBO.getStartStopActivityInfoList()) {
            SkuActivePO skuActivePO;
            ActivityPO activityPO = new ActivityPO();
            activityPO.setActiveCode(chooseActivityBO.getActiveCode());
            activityPO.setActiveId(chooseActivityBO.getActiveId());
            activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            ActivityPO activity = this.activityMapper.getModelBy(activityPO);
            if (null == activity) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01Code:[" + chooseActivityBO.getActiveCode() + "],Id:[" + chooseActivityBO.getActiveId() + "]");
                }
                throw new BusinessException("6012", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01Code:[" + chooseActivityBO.getActiveCode() + "],Id:[" + chooseActivityBO.getActiveId() + "]");
            }
            chooseActivityBO.setActiveId(activity.getActiveId());
            if (!StringUtils.isBlank((CharSequence)chooseActivityBO.getSkuId()) && null != chooseActivityBO.getShopId()) {
                skuActivePO = new SkuActivePO();
                BeanUtils.copyProperties((Object)chooseActivityBO, (Object)skuActivePO);
                skuActivePO.setStatus(this.startOrStop(busiReqBO.getOperType()));
                skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                this.updateSkuActive(skuActivePO);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)chooseActivityBO.getSkuId()) && null != chooseActivityBO.getShopId()) {
                skuActivePO = new SkuActivePO();
                BeanUtils.copyProperties((Object)chooseActivityBO, (Object)skuActivePO);
                skuActivePO.setStatus(this.startOrStop(busiReqBO.getOperType()));
                skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                this.updateShopActive(skuActivePO);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)chooseActivityBO.getSkuId()) && null == chooseActivityBO.getShopId()) {
                ActivityPO activitypo = new ActivityPO();
                BeanUtils.copyProperties((Object)chooseActivityBO, (Object)activitypo);
                activitypo.setActiveStatus(this.startOrStop(busiReqBO.getOperType()));
                activitypo.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                this.updateActive(activitypo);
                continue;
            }
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u9700\u8981\u542f\u505c\u7684\u6d3b\u52a8\u672a\u77e5\uff01");
            }
            throw new BusinessException("6012", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u9700\u8981\u542f\u505c\u7684\u6d3b\u52a8\u672a\u77e5\uff01");
        }
        ActDeleteRedisCacheAtomReqBO deleteRedisCacheAtomReqBO = new ActDeleteRedisCacheAtomReqBO();
        ArrayList<String> redisKeys = new ArrayList<String>();
        deleteRedisCacheAtomReqBO.setRedisKeys(redisKeys);
        for (ChooseActivityBO chooseActivityBO : busiReqBO.getStartStopActivityInfoList()) {
            if (StringUtils.isNotBlank((CharSequence)chooseActivityBO.getSkuId())) {
                redisKeys.add("MSC_SKU_" + chooseActivityBO.getSkuId());
                continue;
            }
            if (null != chooseActivityBO.getShopId()) {
                redisKeys.add("MSC_SHOP_" + chooseActivityBO.getShopId().toString());
                continue;
            }
            redisKeys.add("MSC_INFO_" + chooseActivityBO.getActiveId().toString());
        }
        this.actDeleteRedisCacheAtomService.deleteRedisCache(deleteRedisCacheAtomReqBO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private Integer startOrStop(Integer operType) {
        Integer status;
        switch (operType) {
            case 0: {
                status = ActCommConstant.ActivityState.STATE_EFFECTIVE;
                break;
            }
            case 1: {
                status = ActCommConstant.ActivityState.DISABLED;
                break;
            }
            default: {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
                }
                throw new BusinessException("6012", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
            }
        }
        return status;
    }

    private void updateActive(ActivityPO activityPO) {
        int isUpdate1 = this.activityMapper.updateById(activityPO);
        if (isUpdate1 < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
            }
            throw new BusinessException("6012", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
        }
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(activityPO.getActiveId());
        skuActivePO.setStatus(activityPO.getActiveStatus());
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        int isUpdate2 = this.skuActiveMapper.updateStatusWithWhetherDelete(skuActivePO);
        if (isUpdate2 < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8303\u56f4\u8868\u5931\u8d25\uff01");
            }
            throw new BusinessException("6012", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8303\u56f4\u8868\u5931\u8d25\uff01");
        }
    }

    private void updateShopActive(SkuActivePO shopActivePO) {
        int isUpdate = this.skuActiveMapper.updateWithWhetherDelete(shopActivePO);
        if (isUpdate < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u5e97\u94fa\u6d3b\u52a8\u5931\u8d25\uff01");
            }
            throw new BusinessException("6012", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u5e97\u94fa\u6d3b\u52a8\u5931\u8d25\uff01");
        }
    }

    private void updateSkuActive(SkuActivePO skuActivePO) {
        int isUpdate = this.skuActiveMapper.updateWithWhetherDelete(skuActivePO);
        if (isUpdate < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u5355\u54c1\u6d3b\u52a8\u5931\u8d25\uff01");
            }
            throw new BusinessException("6012", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u5355\u54c1\u6d3b\u52a8\u5931\u8d25\uff01");
        }
    }
}

