/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.ability.ActActivityDetailQueryAbilityService;
import com.tydic.newretail.ability.bo.ActActivityDetailQueryAbilityReqBO;
import com.tydic.newretail.ability.bo.ActActivityDetailQueryAbilityRspBO;
import com.tydic.newretail.busi.ActActivityDetailQueryBusiService;
import com.tydic.newretail.busi.ActSelectDictByCodeAndPcodeBusiService;
import com.tydic.newretail.busi.bo.ActActivityDetailQueryBusiReqBO;
import com.tydic.newretail.busi.bo.ActActivityDetailQueryBusiRspBO;
import com.tydic.newretail.busi.bo.ActSelectDictByCodeAndPcodeBusiReqBO;
import com.tydic.newretail.busi.bo.ActSelectDictByCodeAndPcodeBusiRspBO;
import com.tydic.newretail.common.bo.ActivityInfoBO;
import com.tydic.newretail.common.bo.ShopActiveBO;
import com.tydic.newretail.common.bo.SkuActiveBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActiveSearchAbilityService")
public class ActActivityDetailQueryAbilityServiceImpl
implements ActActivityDetailQueryAbilityService {
    private static final String PARAM_MSG = "\u6d3b\u52a8\u8be6\u60c5\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    private ActActivityDetailQueryBusiService actActivityDetailQueryBusiService;
    private ActSelectDictByCodeAndPcodeBusiService actSelectDictByCodeAndPcodeBusiService;
    private CacheClient cacheClient;

    @Autowired
    private ActActivityDetailQueryAbilityServiceImpl(ActActivityDetailQueryBusiService actActivityDetailQueryBusiService, ActSelectDictByCodeAndPcodeBusiService actSelectDictByCodeAndPcodeBusiService, CacheClient cacheClient) {
        this.actActivityDetailQueryBusiService = actActivityDetailQueryBusiService;
        this.actSelectDictByCodeAndPcodeBusiService = actSelectDictByCodeAndPcodeBusiService;
        this.cacheClient = cacheClient;
    }

    public ActActivityDetailQueryAbilityRspBO queryActiveDetail(ActActivityDetailQueryAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActActivityDetailQueryAbilityRspBO rspBO = new ActActivityDetailQueryAbilityRspBO();
        String redisKey = "MSC_INFO_";
        redisKey = reqBO.getActiveId() != null ? redisKey + reqBO.getActiveId().toString() : redisKey + reqBO.getActiveCode();
        Object redisObj = this.cacheClient.get(redisKey);
        if (redisObj != null) {
            rspBO = (ActActivityDetailQueryAbilityRspBO)redisObj;
        } else {
            this.queryActiveInfoFromDB(reqBO, rspBO);
            if (rspBO.getActivityInfoBO() != null) {
                this.cacheClient.set(redisKey, (Object)rspBO, 18000);
            }
        }
        return rspBO;
    }

    private void validateArg(ActActivityDetailQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u8be6\u60c5\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getActiveId() && StringUtils.isBlank((CharSequence)reqBO.getActiveCode())) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u8be6\u60c5\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2\u6d3b\u52a8ID[activeId]\u548c\u6d3b\u52a8\u7f16\u7801[activeCode]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    private void queryActiveInfoFromDB(ActActivityDetailQueryAbilityReqBO reqBO, ActActivityDetailQueryAbilityRspBO rspBO) {
        ActActivityDetailQueryBusiReqBO busiReqBO = new ActActivityDetailQueryBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        ActActivityDetailQueryBusiRspBO busiRspBO = this.actActivityDetailQueryBusiService.queryActiveDetail(busiReqBO);
        if (null == busiRspBO.getActivityInfoBO()) {
            rspBO.setRespCode(busiRspBO.getRespCode());
            rspBO.setRespDesc(busiRspBO.getRespDesc());
            return;
        }
        rspBO.setActivityInfoBO(busiRspBO.getActivityInfoBO());
        this.translate(rspBO.getActivityInfoBO());
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
    }

    private void translate(ActivityInfoBO activityInfoBO) {
        ActSelectDictByCodeAndPcodeBusiRspBO rspBO;
        ActSelectDictByCodeAndPcodeBusiReqBO reqBO;
        ActSelectDictByCodeAndPcodeBusiRspBO rspBO2;
        ActSelectDictByCodeAndPcodeBusiReqBO reqBO2;
        if (!StringUtils.isBlank((CharSequence)activityInfoBO.getActiveType())) {
            reqBO2 = new ActSelectDictByCodeAndPcodeBusiReqBO();
            reqBO2.setCode(activityInfoBO.getActiveType());
            reqBO2.setPCode("ACTIVE_TYPE");
            rspBO2 = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO2);
            if (null != rspBO2 && null != rspBO2.getDictionaryInfo()) {
                activityInfoBO.setActiveTypeStr(rspBO2.getDictionaryInfo().getDescrip());
            }
        }
        if (null != activityInfoBO.getActiveStatus()) {
            reqBO2 = new ActSelectDictByCodeAndPcodeBusiReqBO();
            reqBO2.setCode(activityInfoBO.getActiveStatus().toString());
            reqBO2.setPCode("ACTIVE_STATUS");
            rspBO2 = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO2);
            if (null != rspBO2 && null != rspBO2.getDictionaryInfo()) {
                activityInfoBO.setActiveStatusStr(rspBO2.getDictionaryInfo().getDescrip());
            }
        }
        if (null != activityInfoBO.getActiveTarget()) {
            reqBO2 = new ActSelectDictByCodeAndPcodeBusiReqBO();
            reqBO2.setCode(activityInfoBO.getActiveTarget().toString());
            reqBO2.setPCode("ACTIVE_TARGET");
            rspBO2 = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO2);
            if (null != rspBO2 && null != rspBO2.getDictionaryInfo()) {
                activityInfoBO.setActiveTargetStr(rspBO2.getDictionaryInfo().getDescrip());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activityInfoBO.getShopActiveList())) {
            for (ShopActiveBO shopActiveBO : activityInfoBO.getShopActiveList()) {
                if (null == shopActiveBO.getStatus()) continue;
                reqBO = new ActSelectDictByCodeAndPcodeBusiReqBO();
                reqBO.setCode(shopActiveBO.getStatus().toString());
                reqBO.setPCode("ACTIVE_STATUS");
                rspBO = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO);
                if (null == rspBO || null == rspBO.getDictionaryInfo()) continue;
                shopActiveBO.setStatusStr(rspBO.getDictionaryInfo().getDescrip());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activityInfoBO.getSkuActiveList())) {
            for (SkuActiveBO skuActiveBO : activityInfoBO.getSkuActiveList()) {
                if (null == skuActiveBO.getStatus()) continue;
                reqBO = new ActSelectDictByCodeAndPcodeBusiReqBO();
                reqBO.setCode(skuActiveBO.getStatus().toString());
                reqBO.setPCode("ACTIVE_STATUS");
                rspBO = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO);
                if (null == rspBO || null == rspBO.getDictionaryInfo()) continue;
                skuActiveBO.setStatusStr(rspBO.getDictionaryInfo().getDescrip());
            }
        }
    }
}

