/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.ability.ActQuerySkuActiveAbilityService;
import com.tydic.newretail.ability.bo.ActQuerySkuActiveAbilityReqBO;
import com.tydic.newretail.ability.bo.ActQuerySkuActiveAbilityRspBO;
import com.tydic.newretail.busi.ActQuerySkuActiveBusiService;
import com.tydic.newretail.busi.ActSelectDictByCodeAndPcodeBusiService;
import com.tydic.newretail.busi.bo.ActQuerySkuActiveBusiReqBO;
import com.tydic.newretail.busi.bo.ActQuerySkuActiveBusiRspBO;
import com.tydic.newretail.busi.bo.ActSelectDictByCodeAndPcodeBusiReqBO;
import com.tydic.newretail.busi.bo.ActSelectDictByCodeAndPcodeBusiRspBO;
import com.tydic.newretail.common.bo.SkuActRspInfoBO;
import com.tydic.newretail.common.bo.SkuActiveInfoBO;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actQuerySkuActiveAbilityService")
public class ActQuerySkuActiveAbilityServiceImpl
implements ActQuerySkuActiveAbilityService {
    private static final String PARAM_MSG = "\u5355\u54c1\u6d3b\u52a8\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    private ActQuerySkuActiveBusiService actQuerySkuActiveBusiService;
    private ActSelectDictByCodeAndPcodeBusiService actSelectDictByCodeAndPcodeBusiService;
    private CacheClient cacheClient;

    @Autowired
    private ActQuerySkuActiveAbilityServiceImpl(ActQuerySkuActiveBusiService actQuerySkuActiveBusiService, ActSelectDictByCodeAndPcodeBusiService actSelectDictByCodeAndPcodeBusiService, CacheClient cacheClient) {
        this.actQuerySkuActiveBusiService = actQuerySkuActiveBusiService;
        this.actSelectDictByCodeAndPcodeBusiService = actSelectDictByCodeAndPcodeBusiService;
        this.cacheClient = cacheClient;
    }

    public ActQuerySkuActiveAbilityRspBO querySkuActive(ActQuerySkuActiveAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActQuerySkuActiveAbilityRspBO rspBO = new ActQuerySkuActiveAbilityRspBO();
        ArrayList<SkuActRspInfoBO> skuActRspInfoBOList = new ArrayList<SkuActRspInfoBO>();
        rspBO.setSkuActInfoList(skuActRspInfoBOList);
        ArrayList<String> querySkuList = new ArrayList<String>();
        for (String skuId : reqBO.getSkuIdList()) {
            Object redisObj = this.cacheClient.get("MSC_SKU_" + skuId);
            if (redisObj != null) {
                SkuActRspInfoBO skuActRspInfoBO = (SkuActRspInfoBO)redisObj;
                skuActRspInfoBOList.add(skuActRspInfoBO);
                continue;
            }
            querySkuList.add(skuId);
        }
        if (!CollectionUtils.isEmpty(querySkuList)) {
            reqBO.setSkuIdList(querySkuList);
            this.querySkuActiveInfoFromDB(reqBO, rspBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private void validateArg(ActQuerySkuActiveAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u5355\u54c1\u6d3b\u52a8\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIdList())) {
            throw new BusinessException("8000", "\u5355\u54c1\u6d3b\u52a8\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5546\u54c1ID\u5217\u8868[skuIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void querySkuActiveInfoFromDB(ActQuerySkuActiveAbilityReqBO reqBO, ActQuerySkuActiveAbilityRspBO rspBO) {
        ActQuerySkuActiveBusiReqBO busiReqBO = new ActQuerySkuActiveBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        ActQuerySkuActiveBusiRspBO busiRspBO = this.actQuerySkuActiveBusiService.querySkuActive(busiReqBO);
        if (!CollectionUtils.isEmpty((Collection)busiRspBO.getSkuActInfoList())) {
            rspBO.setSkuActInfoList(busiRspBO.getSkuActInfoList());
            for (SkuActRspInfoBO skuActRspInfoBO : rspBO.getSkuActInfoList()) {
                for (SkuActiveInfoBO skuActiveInfoBO : skuActRspInfoBO.getSkuActiveList()) {
                    this.translate(skuActiveInfoBO);
                }
                this.cacheClient.set("MSC_SKU_" + skuActRspInfoBO.getSkuId(), (Object)skuActRspInfoBO, 96400);
            }
        }
    }

    private void translate(SkuActiveInfoBO skuActiveInfoBO) {
        ActSelectDictByCodeAndPcodeBusiRspBO rspBO;
        ActSelectDictByCodeAndPcodeBusiReqBO reqBO;
        if (null != skuActiveInfoBO.getStatus()) {
            reqBO = new ActSelectDictByCodeAndPcodeBusiReqBO();
            reqBO.setCode(skuActiveInfoBO.getStatus().toString());
            reqBO.setPCode("ACTIVE_STATUS");
            rspBO = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO);
            if (null != rspBO && null != rspBO.getDictionaryInfo()) {
                skuActiveInfoBO.setStatusStr(rspBO.getDictionaryInfo().getDescrip());
            }
        }
        if (null != skuActiveInfoBO.getActivityBO()) {
            if (!StringUtils.isBlank((CharSequence)skuActiveInfoBO.getActivityBO().getActiveType())) {
                reqBO = new ActSelectDictByCodeAndPcodeBusiReqBO();
                reqBO.setCode(skuActiveInfoBO.getActivityBO().getActiveType());
                reqBO.setPCode("ACTIVE_TYPE");
                rspBO = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO);
                if (null != rspBO && null != rspBO.getDictionaryInfo()) {
                    skuActiveInfoBO.getActivityBO().setActiveTypeStr(rspBO.getDictionaryInfo().getDescrip());
                }
            }
            if (null != skuActiveInfoBO.getActivityBO().getActiveStatus()) {
                reqBO = new ActSelectDictByCodeAndPcodeBusiReqBO();
                reqBO.setCode(skuActiveInfoBO.getActivityBO().getActiveStatus().toString());
                reqBO.setPCode("ACTIVE_STATUS");
                rspBO = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO);
                if (null != rspBO && null != rspBO.getDictionaryInfo()) {
                    skuActiveInfoBO.getActivityBO().setActiveStatusStr(rspBO.getDictionaryInfo().getDescrip());
                }
            }
            if (null != skuActiveInfoBO.getActivityBO().getActiveTarget()) {
                reqBO = new ActSelectDictByCodeAndPcodeBusiReqBO();
                reqBO.setCode(skuActiveInfoBO.getActivityBO().getActiveTarget().toString());
                reqBO.setPCode("ACTIVE_TARGET");
                rspBO = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO);
                if (null != rspBO && null != rspBO.getDictionaryInfo()) {
                    skuActiveInfoBO.getActivityBO().setActiveTargetStr(rspBO.getDictionaryInfo().getDescrip());
                }
            }
        }
    }
}

