/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActCycleCalculateAtomService;
import com.tydic.newretail.atom.bo.ActCycleCalculateAtomReqBO;
import com.tydic.newretail.atom.bo.ActCycleCalculateAtomRspBO;
import com.tydic.newretail.dao.CouponSendCycleMapper;
import com.tydic.newretail.dao.po.CouponSendCyclePO;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCycleCalculateAtomService")
public class ActCycleCalculateAtomServiceImpl
implements ActCycleCalculateAtomService {
    private CouponSendCycleMapper couponSendCycleMapper;
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static Map<Integer, BiFunction<Date, Integer, Date>> cirUnitActionMap = new HashMap<Integer, BiFunction<Date, Integer, Date>>(16);

    @Autowired
    private ActCycleCalculateAtomServiceImpl(CouponSendCycleMapper couponSendCycleMapper) {
        this.couponSendCycleMapper = couponSendCycleMapper;
    }

    @Override
    public ActCycleCalculateAtomRspBO cycleCalculate(ActCycleCalculateAtomReqBO reqBO) {
        ActCycleCalculateAtomRspBO rspBO = new ActCycleCalculateAtomRspBO();
        if (reqBO.getCircleId() == null) {
            rspBO.setRespCode("8000");
            rspBO.setRespDesc("\u5468\u671fID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        CouponSendCyclePO sendCyclePO = this.couponSendCycleMapper.getModelById(reqBO.getCircleId());
        if (!this.validCycle(sendCyclePO)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5468\u671f\u5f00\u59cb\u3001\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
            return rspBO;
        }
        Date cirBegin = sendCyclePO.getBeginTime();
        Date cirEnd = sendCyclePO.getEndTime();
        Date now = new Date();
        if (sendCyclePO.getCirNum() > 0) {
            long cirDuration = cirEnd.getTime() - cirBegin.getTime();
            long nowTime = now.getTime();
            long prevDifferTime = nowTime - cirBegin.getTime();
            Date nextBeginTime = cirUnitActionMap.get(sendCyclePO.getCirUnit()).apply(cirBegin, sendCyclePO.getCirNum());
            long nextDifferTime = nowTime - nextBeginTime.getTime();
            while (nextDifferTime >= 0L && nextDifferTime < prevDifferTime) {
                cirBegin = nextBeginTime;
                prevDifferTime = nextDifferTime;
                nextBeginTime = cirUnitActionMap.get(sendCyclePO.getCirUnit()).apply(cirBegin, sendCyclePO.getCirNum());
                nextDifferTime = nowTime - nextBeginTime.getTime();
            }
            cirEnd = new Date(cirBegin.getTime() + cirDuration);
        }
        if (now.before(cirBegin) || now.after(cirEnd)) {
            String errorMsg = "\u5f53\u524d\u65f6\u95f4\u4e0d\u5728\u6700\u8fd1\u5468\u671f\u5185\uff0c\u6700\u8fd1\u5468\u671f\u4e3a[" + DateFormatUtils.format((Date)cirBegin, (String)DATE_PATTERN) + " -> " + DateFormatUtils.format((Date)cirEnd, (String)DATE_PATTERN) + "]";
            throw new BusinessException("8000", errorMsg);
        }
        rspBO.setBeginTime(cirBegin);
        rspBO.setEndTime(cirEnd);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5468\u671f\u8ba1\u7b97\u6210\u529f");
        return rspBO;
    }

    private static Date addSeasons(Date date, Integer amount) {
        return DateUtils.addMonths((Date)date, (int)(amount * 3));
    }

    private boolean validCycle(CouponSendCyclePO sendCyclePO) {
        if (sendCyclePO == null) {
            throw new BusinessException("8000", "\u672a\u914d\u7f6e\u8be5\u5468\u671f");
        }
        if (sendCyclePO.getCirNum() != null && cirUnitActionMap.get(sendCyclePO.getCirUnit()) == null) {
            throw new BusinessException("8000", "\u914d\u7f6e\u7684\u5468\u671f\u95f4\u9694\u5355\u4f4d[cirUnit]\u4e0d\u652f\u6301\u8ba1\u7b97");
        }
        try {
            if (sendCyclePO.getBeginTime() == null && sendCyclePO.getEndTime() == null) {
                return false;
            }
            if (sendCyclePO.getBeginTime() == null) {
                sendCyclePO.setCirNum(0);
                sendCyclePO.setBeginTime(DateUtils.parseDate((String)"1900-01-01 00:00:00", (String[])new String[]{DATE_PATTERN}));
            } else if (sendCyclePO.getEndTime() == null) {
                sendCyclePO.setCirNum(0);
                sendCyclePO.setEndTime(DateUtils.parseDate((String)"2200-01-01 00:00:00", (String[])new String[]{DATE_PATTERN}));
            }
        }
        catch (ParseException e) {
            throw new BusinessException("8000", "\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
        }
        if (sendCyclePO.getBeginTime().after(sendCyclePO.getEndTime())) {
            throw new BusinessException("8000", "\u914d\u7f6e\u5468\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5728\u7ed3\u675f\u65f6\u95f4\u4e4b\u540e");
        }
        if (sendCyclePO.getBeginTime().after(new Date())) {
            throw new BusinessException("8000", "\u5f53\u524d\u914d\u7f6e\u5468\u671f\u672a\u5f00\u59cb");
        }
        if (sendCyclePO.getCirNum() == null) {
            sendCyclePO.setCirNum(0);
        }
        return true;
    }

    static {
        cirUnitActionMap.put(1, DateUtils::addSeconds);
        cirUnitActionMap.put(2, DateUtils::addMinutes);
        cirUnitActionMap.put(3, DateUtils::addHours);
        cirUnitActionMap.put(4, DateUtils::addDays);
        cirUnitActionMap.put(5, DateUtils::addWeeks);
        cirUnitActionMap.put(6, DateUtils::addMonths);
        cirUnitActionMap.put(7, ActCycleCalculateAtomServiceImpl::addSeasons);
        cirUnitActionMap.put(8, DateUtils::addYears);
    }
}

