/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActActivityRangeCheckAtomService;
import com.tydic.newretail.atom.ActActivityValidCheckAtomService;
import com.tydic.newretail.atom.ActGiftQueryAtomService;
import com.tydic.newretail.atom.ActOrderActivityCountAtomService;
import com.tydic.newretail.atom.ActOrderDiscountAtomService;
import com.tydic.newretail.atom.ActOrderJudgeAtomService;
import com.tydic.newretail.atom.bo.ActActivityRangeCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActActivityRangeCheckAtomRspBO;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomRspBO;
import com.tydic.newretail.atom.bo.ActCalcPriceAtomBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomRspBO;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomRspBO;
import com.tydic.newretail.atom.bo.ActOrderDiscountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderDiscountAtomRspBO;
import com.tydic.newretail.atom.bo.ActOrderJudgeAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderJudgeAtomRspBO;
import com.tydic.newretail.common.bo.ActiveGiftBO;
import com.tydic.newretail.common.bo.ActiveGiftPkgBO;
import com.tydic.newretail.common.bo.ActivityChoiceBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import com.tydic.newretail.dao.ActiveTemplateMapper;
import com.tydic.newretail.dao.po.ActiveTemplatePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actOrderActivityCountAtomService")
public class ActOrderActivityCountAtomServiceImpl
implements ActOrderActivityCountAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActOrderActivityCountAtomServiceImpl.class);
    private ActActivityValidCheckAtomService actActivityValidCheckAtomService;
    private ActActivityRangeCheckAtomService actActivityRangeCheckAtomService;
    private ActiveTemplateMapper activeTemplateMapper;
    private ActOrderJudgeAtomService actOrderJudgeAtomService;
    private ActOrderDiscountAtomService actOrderDiscountAtomService;
    private ActGiftQueryAtomService actGiftQueryAtomService;

    @Autowired
    private ActOrderActivityCountAtomServiceImpl(ActActivityValidCheckAtomService actActivityValidCheckAtomService, ActActivityRangeCheckAtomService actActivityRangeCheckAtomService, ActiveTemplateMapper activeTemplateMapper, ActOrderJudgeAtomService actOrderJudgeAtomService, ActOrderDiscountAtomService actOrderDiscountAtomService, ActGiftQueryAtomService actGiftQueryAtomService) {
        this.actActivityValidCheckAtomService = actActivityValidCheckAtomService;
        this.actActivityRangeCheckAtomService = actActivityRangeCheckAtomService;
        this.activeTemplateMapper = activeTemplateMapper;
        this.actOrderJudgeAtomService = actOrderJudgeAtomService;
        this.actOrderDiscountAtomService = actOrderDiscountAtomService;
        this.actGiftQueryAtomService = actGiftQueryAtomService;
    }

    @Override
    public ActOrderActivityCountAtomRspBO orderActivityCount(ActOrderActivityCountAtomReqBO atomReqBO) {
        if (atomReqBO.getFreightAmount() == null) {
            atomReqBO.setFreightAmount(BigDecimal.ZERO);
        }
        if (CollectionUtils.isEmpty(atomReqBO.getActivityAtomList())) {
            return this.returnOriginalRspBO(atomReqBO);
        }
        Collections.sort(atomReqBO.getActivityAtomList());
        ActOrderActivityCountAtomRspBO rspBO = new ActOrderActivityCountAtomRspBO();
        ActCalcPriceAtomBO actCalcPriceAtomBO = this.obtainDisPriceAndGifts(atomReqBO);
        if (!"0000".equals(actCalcPriceAtomBO.getRespCode())) {
            rspBO.setRespCode(actCalcPriceAtomBO.getRespCode());
            rspBO.setRespDesc("\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u5931\u8d25\uff1a" + actCalcPriceAtomBO.getRespDesc());
            return rspBO;
        }
        rspBO.setDisTotalAmo(actCalcPriceAtomBO.getDisTotalAmo());
        rspBO.setDisFreightAmo(actCalcPriceAtomBO.getDisFreightAmo());
        BigDecimal totalAmount = actCalcPriceAtomBO.getTotalAmount();
        if (totalAmount.compareTo(BigDecimal.ZERO) < 0) {
            rspBO.setTotalAmount(BigDecimal.ZERO);
        } else {
            rspBO.setTotalAmount(totalAmount);
        }
        rspBO.setFreightAmount(actCalcPriceAtomBO.getFreightAmount());
        rspBO.setOrderGiftList(actCalcPriceAtomBO.getGiftList());
        rspBO.setOrderGiftPkgList(actCalcPriceAtomBO.getGiftPkgList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return rspBO;
    }

    private ActCalcPriceAtomBO obtainDisPriceAndGifts(ActOrderActivityCountAtomReqBO atomReqBO) {
        ActCalcPriceAtomBO rspBO = new ActCalcPriceAtomBO();
        BigDecimal totalAmount = this.calculateTotalAmount(atomReqBO.getSkuDetailList());
        BigDecimal disTotalAmo = BigDecimal.ZERO;
        BigDecimal disFreightAmo = BigDecimal.ZERO;
        BigDecimal freightAmount = atomReqBO.getFreightAmount();
        ArrayList<ActiveGiftBO> allGiftList = new ArrayList<ActiveGiftBO>();
        ArrayList<ActiveGiftPkgBO> allGiftPkgList = new ArrayList<ActiveGiftPkgBO>();
        for (ActivityChoiceBO activityChoiceBO : atomReqBO.getActivityAtomList()) {
            ActActivityRangeCheckAtomReqBO rangeCheckAtomReqBO = new ActActivityRangeCheckAtomReqBO();
            rangeCheckAtomReqBO.setActiveId(activityChoiceBO.getActiveId());
            rangeCheckAtomReqBO.setSkuCheckList(atomReqBO.getSkuDetailList());
            ActActivityRangeCheckAtomRspBO rangeCheckAtomRspBO = this.actActivityRangeCheckAtomService.checkActivityRange(rangeCheckAtomReqBO);
            if (!CollectionUtils.isEmpty(rangeCheckAtomRspBO.getUnavailableSkuList())) {
                rspBO.setRespCode("1003");
                rspBO.setRespDesc("\u6d3b\u52a8\u8303\u56f4\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u4e0d\u53ef\u7528\u5355\u54c1[unavailableSkuList=" + rangeCheckAtomRspBO.getUnavailableSkuList().toString() + "]");
                return rspBO;
            }
            ActActivityValidCheckAtomRspBO activeValidCheckAtomRspBO = this.checkActiveValid(activityChoiceBO);
            if (!"0000".equals(activeValidCheckAtomRspBO.getRespCode())) {
                rspBO.setRespCode(activeValidCheckAtomRspBO.getRespCode());
                rspBO.setRespDesc("\u6d3b\u52a8ID:" + activityChoiceBO.getActiveId() + "\u6d3b\u52a8\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01" + activeValidCheckAtomRspBO.getRespDesc());
                return rspBO;
            }
            List<ActiveTemplatePO> activeTemplatePOS = this.checkActiveTempValid(activityChoiceBO);
            if (activeTemplatePOS == null) {
                rspBO.setRespCode("1012");
                rspBO.setRespDesc("\u5546\u94fa\u6d3b\u52a8[" + activityChoiceBO.getActiveId() + "]\u672a\u6210\u529f\u914d\u7f6e\u6d3b\u52a8\u6a21\u677f\u4fe1\u606f");
                return rspBO;
            }
            ActCalcPriceAtomBO actCalcPriceAtomBO = this.calculatePriceByTemp(activeTemplatePOS, activityChoiceBO, atomReqBO.getSkuDetailList(), totalAmount, freightAmount, disTotalAmo);
            if (!"0000".equals(actCalcPriceAtomBO.getRespCode())) {
                rspBO.setRespCode(actCalcPriceAtomBO.getRespCode());
                rspBO.setRespDesc(actCalcPriceAtomBO.getRespDesc());
                return rspBO;
            }
            totalAmount = actCalcPriceAtomBO.getTotalAmount();
            disTotalAmo = actCalcPriceAtomBO.getDisTotalAmo();
            freightAmount = actCalcPriceAtomBO.getFreightAmount();
            disFreightAmo = disFreightAmo.add(actCalcPriceAtomBO.getDisFreightAmo());
            allGiftList.addAll(actCalcPriceAtomBO.getGiftList());
            allGiftPkgList.addAll(actCalcPriceAtomBO.getGiftPkgList());
        }
        rspBO.setTotalAmount(totalAmount);
        rspBO.setFreightAmount(freightAmount);
        rspBO.setDisTotalAmo(disTotalAmo);
        rspBO.setDisFreightAmo(disFreightAmo);
        rspBO.setGiftList(allGiftList);
        rspBO.setGiftPkgList(allGiftPkgList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return rspBO;
    }

    private ActOrderActivityCountAtomRspBO returnOriginalRspBO(ActOrderActivityCountAtomReqBO atomReqBO) {
        ActOrderActivityCountAtomRspBO rspBO = new ActOrderActivityCountAtomRspBO();
        BigDecimal totalAmount = this.calculateTotalAmount(atomReqBO.getSkuDetailList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u65e0\u6d3b\u52a8");
        rspBO.setDisTotalAmo(BigDecimal.ZERO);
        rspBO.setTotalAmount(totalAmount);
        rspBO.setDisFreightAmo(BigDecimal.ZERO);
        rspBO.setFreightAmount(atomReqBO.getFreightAmount());
        return rspBO;
    }

    private BigDecimal calculateTotalAmount(List<SkuDetailBO> skuDetailList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (SkuDetailBO bo : skuDetailList) {
            totalAmount = totalAmount.add(bo.getSkuPrice().multiply(bo.getSkuNum()));
        }
        return totalAmount;
    }

    private ActActivityValidCheckAtomRspBO checkActiveValid(ActivityChoiceBO activityChoiceBO) {
        ActActivityValidCheckAtomReqBO checkActiveAtomReqBO = new ActActivityValidCheckAtomReqBO();
        BeanUtils.copyProperties((Object)activityChoiceBO, (Object)checkActiveAtomReqBO);
        ActActivityValidCheckAtomRspBO activeCheckResultAtomRspBO = this.actActivityValidCheckAtomService.checkActivityValid(checkActiveAtomReqBO);
        if (!"0000".equals(activeCheckResultAtomRspBO.getRespCode())) {
            LOGGER.error("\u6d3b\u52a8ID:" + activityChoiceBO.getActiveId() + "\u6d3b\u52a8\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01" + activeCheckResultAtomRspBO.getRespDesc());
        }
        return activeCheckResultAtomRspBO;
    }

    private List<ActiveTemplatePO> checkActiveTempValid(ActivityChoiceBO activityChoiceBO) {
        int templateNum = 2;
        ActiveTemplatePO activeTemplatePO = new ActiveTemplatePO();
        activeTemplatePO.setActiveId(activityChoiceBO.getActiveId());
        activeTemplatePO.setOrderBy("templateType");
        List<ActiveTemplatePO> activeTemplatePOList = this.activeTemplateMapper.getList(activeTemplatePO);
        if (null == activeTemplatePOList || activeTemplatePOList.size() <= 0) {
            LOGGER.error("\u8ba2\u5355\u6d3b\u52a8\u6a21\u7248\u8868\u96c6\u5408\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return null;
        }
        if (activeTemplatePOList.size() > templateNum) {
            LOGGER.error("\u8ba2\u5355\u6d3b\u52a8\u4e2d\u6bcf\u4e2a\u6a21\u7248\u7c7b\u578b\u6700\u591a\u4e00\u4e2a");
            return null;
        }
        if (activeTemplatePOList.size() == templateNum && activeTemplatePOList.get(0).getTemplateType().equals(activeTemplatePOList.get(1).getTemplateType())) {
            LOGGER.error("\u6d3b\u52a8\u6a21\u7248\u8868\u96c6\u5408\u67e5\u8be2\u7ed3\u679c\u4e24\u4e2a\u6a21\u7248\u7c7b\u578b\u76f8\u540c\uff01");
            return null;
        }
        return activeTemplatePOList;
    }

    private ActCalcPriceAtomBO calculatePriceByTemp(List<ActiveTemplatePO> activeTemplatePOS, ActivityChoiceBO activityChoiceBO, List<SkuDetailBO> skuDetailList, BigDecimal totalAmount, BigDecimal freightAmount, BigDecimal disTotalAmo) {
        ActCalcPriceAtomBO actCalcPriceAtomBO = new ActCalcPriceAtomBO();
        Integer mulCount = 0;
        BigDecimal disFreightAmo = BigDecimal.ZERO;
        ArrayList<ActiveGiftBO> singleActiveGiftList = new ArrayList<ActiveGiftBO>();
        ArrayList<ActiveGiftPkgBO> singleActiveGiftPkgList = new ArrayList<ActiveGiftPkgBO>();
        boolean isMeetCondition = true;
        for (ActiveTemplatePO activeTemplatePO : activeTemplatePOS) {
            if ("0".equals(activeTemplatePO.getTemplateType())) {
                ActOrderJudgeAtomRspBO actOrderJudgeAtomRspBO = this.judgeOrder(activityChoiceBO.getActiveId(), skuDetailList, activeTemplatePO.getTemplateId(), totalAmount);
                if (!"0000".equals(actOrderJudgeAtomRspBO.getRespCode()) && !"1011".equals(actOrderJudgeAtomRspBO.getRespCode())) {
                    LOGGER.error("\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u539f\u5b50\u670d\u52a1\u5931\u8d25!" + actOrderJudgeAtomRspBO.getRespDesc());
                    actCalcPriceAtomBO.setRespCode(actOrderJudgeAtomRspBO.getRespCode());
                    actCalcPriceAtomBO.setRespDesc("\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u539f\u5b50\u670d\u52a1\u5931\u8d25!" + actOrderJudgeAtomRspBO.getRespDesc());
                    return actCalcPriceAtomBO;
                }
                if ("1011".equals(actOrderJudgeAtomRspBO.getRespCode())) {
                    isMeetCondition = false;
                }
                mulCount = actOrderJudgeAtomRspBO.getMulCount();
            }
            if (!"1".equals(activeTemplatePO.getTemplateType())) continue;
            ActOrderDiscountAtomRspBO actOrderDiscountAtomRspBO = this.orderDiscount(totalAmount, freightAmount, disTotalAmo, activityChoiceBO.getActiveId(), activeTemplatePO.getTemplateId(), mulCount, skuDetailList);
            if (!"0000".equals(actOrderDiscountAtomRspBO.getRespCode())) {
                LOGGER.error("\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u8ba2\u5355\u4f18\u60e0\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff01" + actOrderDiscountAtomRspBO.getRespDesc());
                actCalcPriceAtomBO.setRespCode(actOrderDiscountAtomRspBO.getRespCode());
                actCalcPriceAtomBO.setRespDesc("\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u8ba2\u5355\u4f18\u60e0\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5931\u8d25!" + actOrderDiscountAtomRspBO.getRespDesc());
                return actCalcPriceAtomBO;
            }
            totalAmount = actOrderDiscountAtomRspBO.getTotalAmount();
            disTotalAmo = actOrderDiscountAtomRspBO.getDisTotalAmo();
            freightAmount = actOrderDiscountAtomRspBO.getFreightAmount();
            disFreightAmo = disFreightAmo.add(actOrderDiscountAtomRspBO.getDisFreightAmo());
        }
        if (isMeetCondition) {
            ActGiftQueryAtomReqBO actGiftQueryAtomReqBO = new ActGiftQueryAtomReqBO();
            actGiftQueryAtomReqBO.setActiveId(activityChoiceBO.getActiveId());
            ActGiftQueryAtomRspBO actGiftQueryAtomRspBO = this.actGiftQueryAtomService.queryGift(actGiftQueryAtomReqBO);
            singleActiveGiftList.addAll(actGiftQueryAtomRspBO.getGiftList());
            singleActiveGiftPkgList.addAll(actGiftQueryAtomRspBO.getGiftPkgList());
        }
        actCalcPriceAtomBO.setDisFreightAmo(disFreightAmo);
        actCalcPriceAtomBO.setDisTotalAmo(disTotalAmo);
        actCalcPriceAtomBO.setTotalAmount(totalAmount);
        actCalcPriceAtomBO.setFreightAmount(freightAmount);
        actCalcPriceAtomBO.setGiftList(singleActiveGiftList);
        actCalcPriceAtomBO.setGiftPkgList(singleActiveGiftPkgList);
        actCalcPriceAtomBO.setRespCode("0000");
        actCalcPriceAtomBO.setRespDesc("\u5546\u94fa\u4f18\u60e0\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return actCalcPriceAtomBO;
    }

    private ActOrderJudgeAtomRspBO judgeOrder(Long activeId, List<SkuDetailBO> skuDetailList, Long templateId, BigDecimal totalAmount) {
        ActOrderJudgeAtomReqBO actOrderJudgeAtomReqBO = new ActOrderJudgeAtomReqBO();
        actOrderJudgeAtomReqBO.setActiveId(activeId);
        actOrderJudgeAtomReqBO.setSkuDetailList(skuDetailList);
        actOrderJudgeAtomReqBO.setTemplateId(templateId);
        actOrderJudgeAtomReqBO.setTotalAmount(totalAmount);
        return this.actOrderJudgeAtomService.judgeOrder(actOrderJudgeAtomReqBO);
    }

    private ActOrderDiscountAtomRspBO orderDiscount(BigDecimal totalAmount, BigDecimal freightAmount, BigDecimal disTotalAmo, Long activeId, Long templateId, Integer mulCount, List<SkuDetailBO> skuDetailList) {
        ActOrderDiscountAtomReqBO actOrderDiscountAtomReqBO = new ActOrderDiscountAtomReqBO();
        actOrderDiscountAtomReqBO.setTotalAmount(totalAmount);
        actOrderDiscountAtomReqBO.setFreightAmount(freightAmount);
        actOrderDiscountAtomReqBO.setDisTotalAmo(disTotalAmo);
        actOrderDiscountAtomReqBO.setActiveId(activeId);
        actOrderDiscountAtomReqBO.setTemplateId(templateId);
        actOrderDiscountAtomReqBO.setMulCount(mulCount);
        actOrderDiscountAtomReqBO.setSkuDetailList(skuDetailList);
        return this.actOrderDiscountAtomService.orderDiscount(actOrderDiscountAtomReqBO);
    }
}

