/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActDeleteSeckActBusiService;
import com.tydic.newretail.busi.bo.ActDeleteSeckActBusiReqBO;
import com.tydic.newretail.busi.bo.ActDeleteSeckActBusiRspBO;
import com.tydic.newretail.common.bo.ChooseSeckActBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CommodityKillCycleMapper;
import com.tydic.newretail.dao.CommodityKillSkuMapper;
import com.tydic.newretail.dao.po.CommodityKillCyclePO;
import com.tydic.newretail.dao.po.CommodityKillSkuPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actDeleteSeckActBusiService")
public class ActDeleteSeckActBusiServiceImpl
implements ActDeleteSeckActBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActDeleteSeckActBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private CommodityKillCycleMapper commodityKillCycleMapper;
    private CommodityKillSkuMapper commodityKillSkuMapper;

    @Autowired
    private ActDeleteSeckActBusiServiceImpl(CommodityKillCycleMapper commodityKillCycleMapper, CommodityKillSkuMapper commodityKillSkuMapper) {
        this.commodityKillCycleMapper = commodityKillCycleMapper;
        this.commodityKillSkuMapper = commodityKillSkuMapper;
    }

    public ActDeleteSeckActBusiRspBO deleteSeckAct(ActDeleteSeckActBusiReqBO reqBO) {
        ActDeleteSeckActBusiRspBO rspBO = new ActDeleteSeckActBusiRspBO();
        for (ChooseSeckActBO chooseSeckActBO : reqBO.getDeleteSeckActInfoList()) {
            CommodityKillCyclePO killCyclePO = new CommodityKillCyclePO();
            killCyclePO.setKillCycleId(chooseSeckActBO.getKillCycleId());
            killCyclePO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
            int check = this.commodityKillCycleMapper.getCheckBy(killCyclePO);
            if (check < 1) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug(JSON.toJSONString((Object)chooseSeckActBO) + "\u8be5\u79d2\u6740\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
                }
                throw new BusinessException("6018", JSON.toJSONString((Object)chooseSeckActBO) + "\u8be5\u79d2\u6740\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            if (StringUtils.isBlank((CharSequence)chooseSeckActBO.getSkuId())) {
                this.deleteSeckActAndSku(chooseSeckActBO.getKillCycleId());
                continue;
            }
            this.deleteSeckSku(chooseSeckActBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u79d2\u6740\u6d3b\u52a8\u5220\u9664\u6210\u529f");
        return rspBO;
    }

    private void deleteSeckActAndSku(Long killCycleId) {
        CommodityKillCyclePO killCyclePO = new CommodityKillCyclePO();
        killCyclePO.setKillCycleId(killCycleId);
        killCyclePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        killCyclePO.setIsDelete(ActCommConstant.IsDelete.DELETED);
        int updateCycle = this.commodityKillCycleMapper.updateById(killCyclePO);
        if (updateCycle < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u79d2\u6740\u6d3b\u52a8\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u79d2\u6740\u5468\u671f\u8868\u5931\u8d25\uff0ckillCycleId=[" + killCycleId + "]\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6018", "\u79d2\u6740\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        CommodityKillSkuPO killSkuPO = new CommodityKillSkuPO();
        killSkuPO.setKillCycleId(killCycleId);
        killSkuPO.setSkuState(ActCommConstant.ActivityState.DISABLED);
        killSkuPO.setIsDelete(ActCommConstant.IsDelete.DELETED);
        int updateSku = this.commodityKillSkuMapper.updateById(killSkuPO);
        if (updateSku < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u79d2\u6740\u6d3b\u52a8\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u79d2\u6740\u5355\u54c1\u8868\u5931\u8d25\uff0ckillCycleId=[" + killCycleId + "]\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6018", "\u79d2\u6740\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }

    private void deleteSeckSku(ChooseSeckActBO chooseSeckActBO) {
        CommodityKillSkuPO killSkuPO = new CommodityKillSkuPO();
        killSkuPO.setKillCycleId(chooseSeckActBO.getKillCycleId());
        killSkuPO.setSkuId(chooseSeckActBO.getSkuId());
        killSkuPO.setShopId(chooseSeckActBO.getShopId());
        killSkuPO.setSkuState(ActCommConstant.ActivityState.DISABLED);
        killSkuPO.setIsDelete(ActCommConstant.IsDelete.DELETED);
        int updateSku = this.commodityKillSkuMapper.updateById(killSkuPO);
        if (updateSku < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u79d2\u6740\u6d3b\u52a8\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u79d2\u6740\u5355\u54c1\u8868\u5931\u8d25\uff0ckillCycleId=[" + chooseSeckActBO.getKillCycleId() + "]\uff0cskuId=[" + chooseSeckActBO.getSkuId() + "],update\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6018", "\u79d2\u6740\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }
}

