/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.atom.ActOrderActivityCountAtomService;
import com.tydic.newretail.atom.ActSkuActivityCountAtomService;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountReqBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountRspBO;
import com.tydic.newretail.atom.bo.SkuDetailReqAtomBO;
import com.tydic.newretail.busi.ActActivityCountBusiService;
import com.tydic.newretail.busi.bo.ActActivityCountBusiReqBO;
import com.tydic.newretail.busi.bo.ActActivityCountBusiRspBO;
import com.tydic.newretail.common.bo.SkuCountDetailRspBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import com.tydic.newretail.common.bo.SkuDetailReqBO;
import com.tydic.newretail.utils.ActPropertiesUtils;
import com.tydic.umc.ability.UmcMemDetailQueryAbilityService;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActivityCountBusiService")
public class ActActivityCountBusiServiceImpl
implements ActActivityCountBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActivityCountBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    @Autowired
    private ActOrderActivityCountAtomService actOrderActivityCountAtomService;
    @Autowired
    private ActSkuActivityCountAtomService actSkuActivityCountAtomService;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;

    public ActActivityCountBusiRspBO countActivity(ActActivityCountBusiReqBO reqBO) {
        ActActivityCountBusiRspBO rspBO = new ActActivityCountBusiRspBO();
        rspBO.setSeckillFlag("0");
        ArrayList<SkuCountDetailRspBO> skuCountDetailRspBOList = new ArrayList<SkuCountDetailRspBO>();
        BigDecimal depositRateDec = new BigDecimal(0);
        String depositRate = null;
        BigDecimal depositRateAmountt = new BigDecimal(0);
        if (null != reqBO.getMemId() && reqBO.getMemId() != -1L) {
            depositRate = this.getMemDepositRate(reqBO.getMemId());
            if (null == depositRate) {
                rspBO.setRespCode("2033");
                rspBO.setRespDesc("\u67e5\u8be2\u4f1a\u5458\u6298\u6263\u7387\u51fa\u9519\uff01");
                return rspBO;
            }
            depositRateDec = new BigDecimal(depositRate);
        }
        HashMap<String, BigDecimal> skuPriceMap = new HashMap<String, BigDecimal>();
        for (SkuDetailReqBO skuDetailReqBO : reqBO.getSkuDetailList()) {
            ActSkuActivityCountRspBO skuAtomRspBO;
            if (depositRateDec.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal skuPriceNew = skuDetailReqBO.getSkuPrice().multiply(depositRateDec).setScale(2, 4);
                LOGGER.info("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u5355\u54c1" + skuDetailReqBO.getSkuId() + "\u6298\u6263\u540e\u4ef7\u683c\uff1a" + skuPriceNew);
                if (skuPriceNew.compareTo(BigDecimal.ZERO) > 0 && skuPriceNew.compareTo(new BigDecimal(0.01)) <= 0) {
                    skuPriceNew = new BigDecimal(0.01).setScale(2, 4);
                    LOGGER.info("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u5355\u54c1" + skuDetailReqBO.getSkuId() + "\u6298\u6263\u540e\u4ef7\u683c1\uff1a" + skuPriceNew);
                }
                BigDecimal depositRateAmountItem = skuDetailReqBO.getSkuPrice().subtract(skuPriceNew).setScale(2, 4);
                depositRateAmountt = depositRateAmountt.add(depositRateAmountItem.multiply(skuDetailReqBO.getSkuNum()).setScale(2, 4));
                skuDetailReqBO.setSkuPrice(skuPriceNew);
                skuPriceMap.put(skuDetailReqBO.getSkuId(), skuDetailReqBO.getSkuPrice());
                LOGGER.info("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u4f1a\u5458\u6298\u6263\u7387\uff1a" + depositRateDec);
                LOGGER.info("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u5355\u54c1" + skuDetailReqBO.getSkuId() + "\u6298\u6263\uff1a" + depositRateAmountItem);
                LOGGER.info("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u5355\u54c1" + skuDetailReqBO.getSkuId() + "\u6570\u91cf\uff1a" + skuDetailReqBO.getSkuNum());
                LOGGER.info("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u5355\u54c1" + skuDetailReqBO.getSkuId() + "\u6298\u6263\u6570\uff1a" + depositRateAmountItem.multiply(skuDetailReqBO.getSkuNum()).setScale(2, 4));
                LOGGER.info("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u4f1a\u5458\u6298\u6263\u603b\u4ef7\uff1a" + depositRateAmountt);
            }
            if (!"0000".equals((skuAtomRspBO = this.callSkuActivityCount(skuDetailReqBO)).getRespCode())) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5355\u54c1\u6d3b\u52a8\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5931\u8d25" + skuAtomRspBO.getRespDesc());
                }
                rspBO.setRespCode("2011");
                rspBO.setRespDesc(skuAtomRspBO.getRespDesc());
                return rspBO;
            }
            if (null == skuAtomRspBO.getSkuDetailRspAtomBO()) continue;
            SkuCountDetailRspBO skuCountDetailRspBO = new SkuCountDetailRspBO();
            BeanUtils.copyProperties((Object)skuAtomRspBO.getSkuDetailRspAtomBO(), (Object)skuCountDetailRspBO);
            if ("1".equals(skuCountDetailRspBO.getSeckillFlag())) {
                reqBO.setOrderActivityList(null);
                rspBO.setSeckillFlag("1");
            }
            skuCountDetailRspBO.setGiftList(skuAtomRspBO.getSkuDetailRspAtomBO().getGiftList());
            skuCountDetailRspBO.setGiftPkgList(skuAtomRspBO.getSkuDetailRspAtomBO().getGiftPkgList());
            skuCountDetailRspBOList.add(skuCountDetailRspBO);
        }
        ActOrderActivityCountAtomRspBO orderAtomRspBO = this.callOrderActiveCount(reqBO, skuCountDetailRspBOList);
        if (!"0000".equals(orderAtomRspBO.getRespCode())) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5931\u8d25" + orderAtomRspBO.getRespDesc());
            }
            rspBO.setRespCode("2011");
            rspBO.setRespDesc(orderAtomRspBO.getRespDesc());
            return rspBO;
        }
        this.formatRspInfo(skuCountDetailRspBOList, orderAtomRspBO, rspBO, depositRateAmountt, depositRate, skuPriceMap);
        rspBO.setRespTime(new Date());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return rspBO;
    }

    private ActSkuActivityCountRspBO callSkuActivityCount(SkuDetailReqBO skuDetailReqBO) {
        ActSkuActivityCountReqBO skuAtomReqBO = new ActSkuActivityCountReqBO();
        SkuDetailReqAtomBO skuDetailActivityReqBO = new SkuDetailReqAtomBO();
        BeanUtils.copyProperties((Object)skuDetailReqBO, (Object)((Object)skuDetailActivityReqBO));
        skuDetailActivityReqBO.setActivityChoiceList(skuDetailReqBO.getSkuActivityList());
        skuAtomReqBO.setActSkuActivityDetailReqBO(skuDetailActivityReqBO);
        return this.actSkuActivityCountAtomService.skuActivityCount(skuAtomReqBO);
    }

    private ActOrderActivityCountAtomRspBO callOrderActiveCount(ActActivityCountBusiReqBO reqBO, List<SkuCountDetailRspBO> orderAtomReqList) {
        ActOrderActivityCountAtomReqBO orderAtomReqBO = new ActOrderActivityCountAtomReqBO();
        ArrayList<SkuDetailBO> skuDetailList = new ArrayList<SkuDetailBO>();
        for (SkuCountDetailRspBO atomSkuDetailReqBusiBO : orderAtomReqList) {
            SkuDetailBO skuDetailBO = new SkuDetailBO();
            BeanUtils.copyProperties((Object)atomSkuDetailReqBusiBO, (Object)skuDetailBO);
            skuDetailBO.setSkuPrice(atomSkuDetailReqBusiBO.getSkuDisPrice());
            skuDetailList.add(skuDetailBO);
        }
        orderAtomReqBO.setSkuDetailList(skuDetailList);
        orderAtomReqBO.setActivityAtomList(reqBO.getOrderActivityList());
        orderAtomReqBO.setFreightAmount(reqBO.getFreightAmount());
        return this.actOrderActivityCountAtomService.orderActivityCount(orderAtomReqBO);
    }

    private void formatRspInfo(List<SkuCountDetailRspBO> skuCountDetailRspBOList, ActOrderActivityCountAtomRspBO orderAtomRspBO, ActActivityCountBusiRspBO rspBO, BigDecimal depositRateAmount, String depositRate, Map<String, BigDecimal> skuPriceMap) {
        BigDecimal orderDiscount;
        BigDecimal totalSkuDisCount = skuCountDetailRspBOList.stream().map(skuDetail -> skuDetail.getSkuDisAmount().multiply(skuDetail.getSkuNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal bigDecimal = orderDiscount = orderAtomRspBO.getDisTotalAmo() != null ? orderAtomRspBO.getDisTotalAmo() : BigDecimal.ZERO;
        if (orderDiscount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal totalAmount = totalSkuDisCount.add(orderDiscount).add(orderAtomRspBO.getTotalAmount());
            BigDecimal totalAmountDivideSkuDisCount = orderDiscount.add(orderAtomRspBO.getTotalAmount());
            BigDecimal orderRate = orderDiscount.divide(totalAmountDivideSkuDisCount, 2, 5);
            BigDecimal shareDiscount = BigDecimal.ZERO;
            int skuLength = skuCountDetailRspBOList.size();
            for (int index = 0; index < skuLength; ++index) {
                BigDecimal shareOrderDiscount;
                SkuCountDetailRspBO skuDetailRsp = skuCountDetailRspBOList.get(index);
                skuDetailRsp.setSkuPrice(skuPriceMap.get(skuDetailRsp.getSkuId()));
                BigDecimal skuNum = skuDetailRsp.getSkuNum();
                if (index == skuLength - 1) {
                    shareOrderDiscount = orderDiscount.subtract(shareDiscount);
                } else {
                    shareOrderDiscount = skuDetailRsp.getSkuDisPrice().multiply(skuNum).multiply(orderRate);
                    shareDiscount = shareDiscount.add(shareOrderDiscount);
                }
                skuDetailRsp.setSkuTotalAmount(skuDetailRsp.getSkuDisAmount().multiply(skuNum).add(shareOrderDiscount).setScale(2, 5));
                BigDecimal skuDisPrice = skuDetailRsp.getSkuDisPrice().subtract(skuDetailRsp.getSkuDisPrice().multiply(orderRate)).setScale(2, 5);
                BigDecimal skuTotalPrice = skuDetailRsp.getSkuDisPrice().multiply(skuNum).subtract(shareOrderDiscount);
                skuDetailRsp.setSkuDisPrice(skuDisPrice);
                if (skuTotalPrice.compareTo(BigDecimal.ZERO) < 0) {
                    skuDetailRsp.setSkuTotalPrice(BigDecimal.ZERO);
                    continue;
                }
                skuDetailRsp.setSkuTotalPrice(skuTotalPrice.setScale(2, 5));
            }
        } else {
            for (SkuCountDetailRspBO skuDetailRsp : skuCountDetailRspBOList) {
                skuDetailRsp.setSkuPrice(skuPriceMap.get(skuDetailRsp.getSkuId()));
                LOGGER.info("\u7b97\u660e\u7ec6\u539f\u4ef7sku:" + skuDetailRsp.getSkuId() + "\u7684\u4ef7\u683c" + skuDetailRsp.getSkuPrice());
                LOGGER.info("\u7b97\u660e\u7ec6\u6298\u540e\u4ef7sku:" + skuDetailRsp.getSkuId() + "\u7684\u4ef7\u683c" + skuDetailRsp.getSkuDisPrice());
                BigDecimal skuNum = skuDetailRsp.getSkuNum();
                skuDetailRsp.setSkuTotalAmount(skuDetailRsp.getSkuDisAmount().multiply(skuNum).setScale(2, 5));
                skuDetailRsp.setSkuTotalPrice(skuDetailRsp.getSkuDisPrice().multiply(skuNum).setScale(2, 5));
            }
        }
        BigDecimal finalTotalAmount = BigDecimal.ZERO;
        rspBO.setActivityDisAmo(orderDiscount.setScale(2, 5));
        rspBO.setDisTotalAmo(orderDiscount.add(totalSkuDisCount).add(depositRateAmount).setScale(2, 5));
        if (null != orderAtomRspBO.getTotalAmount()) {
            finalTotalAmount = finalTotalAmount.add(orderAtomRspBO.getTotalAmount());
            rspBO.setTotalAmount(orderAtomRspBO.getTotalAmount().setScale(2, 5));
        }
        if (null != orderAtomRspBO.getDisFreightAmo()) {
            rspBO.setDisFreightAmo(orderAtomRspBO.getDisFreightAmo().setScale(2, 5));
        }
        if (null != orderAtomRspBO.getFreightAmount()) {
            finalTotalAmount = finalTotalAmount.add(orderAtomRspBO.getFreightAmount());
            rspBO.setFreightAmount(orderAtomRspBO.getFreightAmount().setScale(2, 5));
        }
        rspBO.setFinalTotalAmount(finalTotalAmount.setScale(2, 5));
        rspBO.setOrderGiftList(orderAtomRspBO.getOrderGiftList());
        rspBO.setOrderGiftPkgList(orderAtomRspBO.getOrderGiftPkgList());
        rspBO.setSkuDetailList(skuCountDetailRspBOList);
        rspBO.setMemDepositate(depositRate);
        rspBO.setMemDisAmo(depositRateAmount);
    }

    private String getMemDepositRate(Long memId) {
        String depositRate = null;
        try {
            UmcMemDetailQueryAbilityReqBO reqBO = new UmcMemDetailQueryAbilityReqBO();
            reqBO.setMemId(memId);
            UmcMemDetailQueryAbilityRspBO rsp = this.umcMemDetailQueryAbilityService.memDetailQuery(reqBO);
            if (null == rsp || !"0000".equals(rsp.getRespCode())) {
                LOGGER.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u8fd4\u56de\u9519\u8bef\uff1a" + rsp.toString());
                return null;
            }
            UmcMemDetailInfoAbilityBO mem = rsp.getUmcMemDetailInfoAbilityRspBO();
            if (null == mem) {
                LOGGER.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u8fd4\u56de\u9519\u8bef\uff1a\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a");
                return null;
            }
            Integer memLevel = mem.getMemLevel();
            depositRate = ActPropertiesUtils.getProperty("ACT_MEM_RATE_" + memLevel);
            if (null == depositRate) {
                LOGGER.error("\u67e5\u8be2\u4f1a\u5458\u6298\u65e7\u7387\u51fa\u9519\uff1a\u672a\u914d\u7f6e\u4f1a\u5458\u7b49\u7ea7\u4e3a" + memLevel + "\u7684\u6298\u6263\u7387");
                return null;
            }
            return depositRate;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u4f1a\u5458\u6298\u65e7\u7387\u51fa\u9519\uff1a", (Throwable)e);
            return depositRate;
        }
    }
}

