/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.busi.ActSeckCycListQueryBusiService;
import com.tydic.newretail.busi.bo.ActSeckCycListQueryBusiReqBO;
import com.tydic.newretail.busi.bo.ActSeckCycListQueryBusiRspBO;
import com.tydic.newretail.busi.bo.SeckillCycBusiBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CommodityKillCycleMapper;
import com.tydic.newretail.dao.CommodityKillSkuMapper;
import com.tydic.newretail.dao.po.CommodityKillCyclePO;
import com.tydic.newretail.dao.po.CommodityKillSkuPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actSeckCycListQueryBusiService")
public class ActSeckCycListQueryBusiServiceImpl
implements ActSeckCycListQueryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSeckCycListQueryBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    @Autowired
    private CommodityKillSkuMapper commodityKillSkuMapper;
    @Autowired
    private CommodityKillCycleMapper commodityKillCycleMapper;

    public ActSeckCycListQueryBusiRspBO querySeckCycList(ActSeckCycListQueryBusiReqBO busiReqBO) {
        ActSeckCycListQueryBusiRspBO rsp = new ActSeckCycListQueryBusiRspBO();
        Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(busiReqBO.getQueryDay());
        ((Calendar)calendar).add(5, 1);
        Date queryDatEnd = calendar.getTime();
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getSkuId())) {
            CommodityKillSkuPO commodityKillSkuPO = new CommodityKillSkuPO();
            commodityKillSkuPO.setSkuId(busiReqBO.getSkuId());
            List<CommodityKillSkuPO> commodityKillSkuPOList = this.commodityKillSkuMapper.getList(commodityKillSkuPO);
            if (null == commodityKillSkuPOList || commodityKillSkuPOList.size() <= 0) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u79d2\u6740\u5355\u54c1\u8868\u67e5\u8be2\u4e3a\u7a7a\uff01");
                }
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u79d2\u6740\u5355\u54c1\u8868\u67e5\u8be2\u4e3a\u7a7a\uff01");
                return rsp;
            }
            if (null != busiReqBO.getKillCycleId()) {
                int isHave = 0;
                for (CommodityKillSkuPO po : commodityKillSkuPOList) {
                    if (!po.getKillCycleId().equals(busiReqBO.getKillCycleId())) continue;
                    ++isHave;
                    break;
                }
                if (isHave > 0) {
                    CommodityKillCyclePO commodityKillCyclePO = new CommodityKillCyclePO();
                    BeanUtils.copyProperties((Object)busiReqBO, (Object)commodityKillCyclePO);
                    commodityKillCyclePO.setQueryDayStart(busiReqBO.getQueryDay());
                    commodityKillCyclePO.setQueryDayEnd(queryDatEnd);
                    commodityKillCyclePO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
                    List<CommodityKillCyclePO> commodityKillCyclePOList = this.commodityKillCycleMapper.getListPage(commodityKillCyclePO, (Page<CommodityKillCyclePO>)page);
                    if (null == commodityKillCyclePOList || commodityKillCyclePOList.size() <= 0) {
                        if (IS_DEBUGABLE) {
                            LOGGER.debug("\u79d2\u6740\u5468\u671f\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                        }
                        rsp.setRespCode("0000");
                        rsp.setRespDesc("\u79d2\u6740\u5468\u671f\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                        return rsp;
                    }
                    ArrayList<SeckillCycBusiBO> seckillCycList = new ArrayList<SeckillCycBusiBO>();
                    for (CommodityKillCyclePO po : commodityKillCyclePOList) {
                        SeckillCycBusiBO seckillCycBusiBO = new SeckillCycBusiBO();
                        BeanUtils.copyProperties((Object)po, (Object)seckillCycBusiBO);
                        seckillCycList.add(seckillCycBusiBO);
                    }
                    rsp.setRows(seckillCycList);
                    rsp.setTotalPages(Integer.valueOf(page.getTotalPages()));
                    rsp.setTotalRecords(Integer.valueOf(page.getTotalCount()));
                    rsp.setPageNo(Integer.valueOf(page.getPageNo()));
                    rsp.setRespCode("0000");
                    rsp.setRespDesc("\u79d2\u6740\u5468\u671f\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
                    return rsp;
                }
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6839\u636eSkuId\u67e5\u51fa\u7684\u5468\u671fId\u4e0e\u4f20\u5165\u7684\u5468\u671fId\u65e0\u4ea4\u96c6!");
                }
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u6839\u636eSkuId\u67e5\u51fa\u7684\u5468\u671fId\u4e0e\u4f20\u5165\u7684\u5468\u671fId\u65e0\u4ea4\u96c6!");
                return rsp;
            }
            ArrayList<SeckillCycBusiBO> seckillCycList = new ArrayList<SeckillCycBusiBO>();
            for (CommodityKillSkuPO po : commodityKillSkuPOList) {
                CommodityKillCyclePO commodityKillCyclePO = new CommodityKillCyclePO();
                BeanUtils.copyProperties((Object)busiReqBO, (Object)commodityKillCyclePO);
                commodityKillCyclePO.setKillCycleId(po.getKillCycleId());
                commodityKillCyclePO.setQueryDayStart(busiReqBO.getQueryDay());
                commodityKillCyclePO.setQueryDayEnd(queryDatEnd);
                commodityKillCyclePO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
                List<CommodityKillCyclePO> commodityKillCyclePOList = this.commodityKillCycleMapper.getListPage(commodityKillCyclePO, (Page<CommodityKillCyclePO>)page);
                if (null == commodityKillCyclePOList || commodityKillCyclePOList.size() <= 0) continue;
                for (CommodityKillCyclePO po2 : commodityKillCyclePOList) {
                    SeckillCycBusiBO seckillCycBusiBO = new SeckillCycBusiBO();
                    BeanUtils.copyProperties((Object)po2, (Object)seckillCycBusiBO);
                    seckillCycList.add(seckillCycBusiBO);
                }
            }
            if (CollectionUtils.isEmpty(seckillCycList)) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u79d2\u6740\u5468\u671f\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a3\uff01");
                }
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u79d2\u6740\u5468\u671f\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rsp;
            }
            rsp.setRows(seckillCycList);
            rsp.setTotalPages(Integer.valueOf(page.getTotalPages()));
            rsp.setTotalRecords(Integer.valueOf(page.getTotalCount()));
            rsp.setPageNo(Integer.valueOf(page.getPageNo()));
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u79d2\u6740\u5468\u671f\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
            return rsp;
        }
        CommodityKillCyclePO commodityKillCyclePO = new CommodityKillCyclePO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)commodityKillCyclePO);
        commodityKillCyclePO.setQueryDayStart(busiReqBO.getQueryDay());
        commodityKillCyclePO.setQueryDayEnd(queryDatEnd);
        commodityKillCyclePO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
        List<CommodityKillCyclePO> commodityKillCyclePOList = this.commodityKillCycleMapper.getListPage(commodityKillCyclePO, (Page<CommodityKillCyclePO>)page);
        if (null == commodityKillCyclePOList || commodityKillCyclePOList.size() <= 0) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u79d2\u6740\u5468\u671f\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a2\uff01");
            }
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u79d2\u6740\u5468\u671f\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        ArrayList<SeckillCycBusiBO> seckillCycList = new ArrayList<SeckillCycBusiBO>();
        for (CommodityKillCyclePO po : commodityKillCyclePOList) {
            SeckillCycBusiBO seckillCycBusiBO = new SeckillCycBusiBO();
            BeanUtils.copyProperties((Object)po, (Object)seckillCycBusiBO);
            seckillCycList.add(seckillCycBusiBO);
        }
        rsp.setRows(seckillCycList);
        rsp.setTotalPages(Integer.valueOf(page.getTotalPages()));
        rsp.setTotalRecords(Integer.valueOf(page.getTotalCount()));
        rsp.setPageNo(Integer.valueOf(page.getPageNo()));
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u79d2\u6740\u5468\u671f\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }
}

