/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.external.api.umc.bo.ActUmcCouponDeductionAbilityReqBO;
import com.tydic.active.external.api.umc.bo.ActUmcCouponDeductionAbilityRspBO;
import com.tydic.newretail.atom.ActCouponValidCheckAtomService;
import com.tydic.newretail.atom.bo.ActCouponValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCouponValidCheckAtomRspBO;
import com.tydic.newretail.busi.ActCouponDeductionBusiService;
import com.tydic.newretail.busi.bo.ActCouponDeductionBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponDeductionBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.po.CouponInstPO;
import com.tydic.newretail.facde.ActUmcServiceHolder;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCouponDeductionBusiService")
public class ActCouponDeductionBusiServiceImpl
implements ActCouponDeductionBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCouponDeductionBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private ActCouponValidCheckAtomService actCouponValidCheckAtomService;
    private CouponInstMapper couponInstMapper;
    @Autowired
    private ActUmcServiceHolder actUmcServiceHolder;

    @Autowired
    private ActCouponDeductionBusiServiceImpl(ActCouponValidCheckAtomService actCouponValidCheckAtomService, CouponInstMapper couponInstMapper) {
        this.actCouponValidCheckAtomService = actCouponValidCheckAtomService;
        this.couponInstMapper = couponInstMapper;
    }

    public ActCouponDeductionBusiRspBO couponDeduction(ActCouponDeductionBusiReqBO reqBO) {
        ActUmcCouponDeductionAbilityRspBO umcRspBO;
        ActCouponDeductionBusiRspBO rspBO = new ActCouponDeductionBusiRspBO();
        ActCouponValidCheckAtomReqBO checkAtomReqBO = new ActCouponValidCheckAtomReqBO();
        checkAtomReqBO.setCouponNo(reqBO.getCouponNo());
        ActCouponValidCheckAtomRspBO checkAtomRspBO = this.actCouponValidCheckAtomService.checkCouponValid(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f18\u60e0\u5238\u62b5\u6263\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4f18\u60e0\u5238\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            }
            rspBO.setRespCode("2021");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u6709\u6548\u6821\u9a8c\u5931\u8d25");
            return rspBO;
        }
        if (!ActCommConstant.CouponValidMark.VALID.equals(checkAtomRspBO.getCouponValidMark())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u4f18\u60e0\u5238\u65e0\u6548");
            return rspBO;
        }
        ActUmcCouponDeductionAbilityReqBO actUmcCouponDeductionAbilityReqBO = new ActUmcCouponDeductionAbilityReqBO();
        actUmcCouponDeductionAbilityReqBO.setMemId(reqBO.getMemId());
        actUmcCouponDeductionAbilityReqBO.setCouponNo(reqBO.getCouponNo());
        actUmcCouponDeductionAbilityReqBO.setUsedSn(reqBO.getUsedSn());
        actUmcCouponDeductionAbilityReqBO.setUsedSystem(reqBO.getUsedSystem());
        if (!StringUtils.isBlank((CharSequence)reqBO.getDeductionMoney())) {
            actUmcCouponDeductionAbilityReqBO.setDeductionMoney(new BigDecimal(reqBO.getDeductionMoney()));
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getUsedTime())) {
            actUmcCouponDeductionAbilityReqBO.setUsedTime(reqBO.getUsedTime());
        }
        if (!"0000".equals((umcRspBO = this.actUmcServiceHolder.getActExternalUmcConponService().invokeCouponDeduction(actUmcCouponDeductionAbilityReqBO)).getRespCode())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f18\u60e0\u5238\u62b5\u6263\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f18\u60e0\u5238\u62b5\u6263\u670d\u52a1\u5931\u8d25" + umcRspBO.getRespDesc());
            }
            rspBO.setRespCode("2022");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u62b5\u6263\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5916\u90e8\u670d\u52a1\u5931\u8d25" + umcRspBO.getRespDesc());
            return rspBO;
        }
        CouponInstPO couponInstPO = new CouponInstPO();
        couponInstPO.setCouponNo(reqBO.getCouponNo());
        couponInstPO.setUsedSn(reqBO.getUsedSn());
        couponInstPO.setState(ActCommConstant.CouponState.USED);
        int updateResult = this.couponInstMapper.updateById(couponInstPO);
        if (updateResult < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f18\u60e0\u5238\u62b5\u6263\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25\uff0cupdate\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6041", "\u4f18\u60e0\u5238\u62b5\u6263\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u62b5\u6263\u6210\u529f");
        return rspBO;
    }
}

