/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.newretail.atom.ActGiftQueryAtomService;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomRspBO;
import com.tydic.newretail.common.bo.ActiveGiftBO;
import com.tydic.newretail.common.bo.ActiveGiftPkgBO;
import com.tydic.newretail.dao.ActiveGiftMapper;
import com.tydic.newretail.dao.ActiveGiftPkgMapper;
import com.tydic.newretail.dao.ActiveGiftStockMapper;
import com.tydic.newretail.dao.ActivePkgComposeMapper;
import com.tydic.newretail.dao.po.ActiveGiftPO;
import com.tydic.newretail.dao.po.ActiveGiftPkgPO;
import com.tydic.newretail.dao.po.ActiveGiftStockPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actGiftQueryAtomService")
public class ActGiftQueryAtomServiceImpl
implements ActGiftQueryAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActGiftQueryAtomServiceImpl.class);
    @Autowired
    private ActiveGiftMapper activeGiftMapper;
    @Autowired
    private ActiveGiftStockMapper activeGiftStockMapper;
    @Autowired
    private ActiveGiftPkgMapper activeGiftPkgMapper;
    @Autowired
    private ActivePkgComposeMapper activePkgComposeMapper;

    @Override
    public ActGiftQueryAtomRspBO queryGift(ActGiftQueryAtomReqBO reqBO) {
        Long activeId = reqBO.getActiveId();
        ActGiftQueryAtomRspBO rspBO = new ActGiftQueryAtomRspBO();
        ArrayList<ActiveGiftBO> giftAtomBoList = new ArrayList<ActiveGiftBO>();
        ArrayList<ActiveGiftPkgBO> giftPkgBOList = new ArrayList<ActiveGiftPkgBO>();
        ActiveGiftPO activeGiftPO = new ActiveGiftPO();
        activeGiftPO.setActiveId(activeId);
        List<ActiveGiftPO> activeGiftPOList = this.activeGiftMapper.getList(activeGiftPO);
        if (!CollectionUtils.isEmpty(activeGiftPOList)) {
            for (ActiveGiftPO giftPO : activeGiftPOList) {
                if (null != giftPO.getPkgId()) continue;
                ActiveGiftBO giftAtomBo = new ActiveGiftBO();
                BeanUtils.copyProperties((Object)giftPO, (Object)giftAtomBo);
                try {
                    giftAtomBo.setGiftPrice(MoneyUtils.Long2BigDecimal((Long)giftPO.getGiftPrice()));
                }
                catch (Exception e) {
                    LOGGER.error("\u8d60\u54c1\u67e5\u8be2\u539f\u5b50\u670d\u52a1\uff0c\u8d60\u54c1\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
                }
                this.queryGiftCount(giftAtomBo, null);
                giftAtomBoList.add(giftAtomBo);
            }
        }
        ActiveGiftPkgPO activeGiftPkgPO = new ActiveGiftPkgPO();
        activeGiftPkgPO.setActiveId(activeId);
        List<ActiveGiftPkgPO> activeGiftPkgPOList = this.activeGiftPkgMapper.getList(activeGiftPkgPO);
        if (!CollectionUtils.isEmpty(activeGiftPkgPOList)) {
            for (ActiveGiftPkgPO giftPkgPO : activeGiftPkgPOList) {
                ActiveGiftPkgBO activeGiftPkgBO = new ActiveGiftPkgBO();
                BeanUtils.copyProperties((Object)giftPkgPO, (Object)activeGiftPkgBO);
                ArrayList<ActiveGiftBO> giftBOList = new ArrayList<ActiveGiftBO>();
                ActiveGiftPO activeGiftPO2 = new ActiveGiftPO();
                activeGiftPO2.setActiveId(activeId);
                activeGiftPO2.setPkgId(giftPkgPO.getPkgId());
                List<ActiveGiftPO> activeGiftPO2List = this.activeGiftMapper.getList(activeGiftPO2);
                if (!CollectionUtils.isEmpty(activeGiftPO2List)) {
                    for (ActiveGiftPO activeGift : activeGiftPO2List) {
                        ActiveGiftBO giftBo = new ActiveGiftBO();
                        BeanUtils.copyProperties((Object)activeGift, (Object)giftBo);
                        try {
                            giftBo.setGiftPrice(MoneyUtils.Long2BigDecimal((Long)activeGift.getGiftPrice()));
                        }
                        catch (Exception e) {
                            LOGGER.error("\u8d60\u54c1\u67e5\u8be2\u539f\u5b50\u670d\u52a1\uff0c\u8d60\u54c1\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
                        }
                        this.queryGiftCount(giftBo, activeGift.getPkgId());
                        giftBOList.add(giftBo);
                    }
                }
                activeGiftPkgBO.setGiftList(giftBOList);
                giftPkgBOList.add(activeGiftPkgBO);
            }
        }
        rspBO.setGiftList(giftAtomBoList);
        rspBO.setGiftPkgList(giftPkgBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8d60\u54c1\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u6210\u529f");
        return rspBO;
    }

    private void queryGiftCount(ActiveGiftBO giftBo, Long pkgId) {
        ActiveGiftStockPO giftStockPO = new ActiveGiftStockPO();
        giftStockPO.setActiveId(giftBo.getActiveId());
        giftStockPO.setPkgId(pkgId);
        giftStockPO.setGiftId(giftBo.getId());
        ActiveGiftStockPO giftStock = this.activeGiftStockMapper.getModelBy(giftStockPO);
        if (null != giftStock) {
            giftBo.setAlCount(giftStock.getGiftCount());
            giftBo.setSendCount(giftStock.getSendCount());
        }
    }
}

