/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.timetask.impl;

import com.tydic.newretail.comb.ActCreateCouponCombService;
import com.tydic.newretail.comb.bo.ActCreateCouponCombReqBO;
import com.tydic.newretail.comb.bo.ActCreateCouponCombRspBO;
import com.tydic.newretail.dao.ActDicDictionaryMapper;
import com.tydic.newretail.dao.CouponTaskMapper;
import com.tydic.newretail.dao.po.DicDictionaryPO;
import com.tydic.newretail.timetask.ActCreateCouponInstTimeTaskService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCreateCouponInstTimeTaskService")
public class ActCreateCouponInstTimeTaskServiceImpl
implements ActCreateCouponInstTimeTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateCouponInstTimeTaskServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    private ActDicDictionaryMapper actDicDictionaryMapper;
    private CouponTaskMapper couponTaskMapper;
    private ActCreateCouponCombService actCreateCouponCombService;

    @Autowired
    private ActCreateCouponInstTimeTaskServiceImpl(ActDicDictionaryMapper actDicDictionaryMapper, CouponTaskMapper couponTaskMapper, ActCreateCouponCombService actCreateCouponCombService) {
        this.actDicDictionaryMapper = actDicDictionaryMapper;
        this.couponTaskMapper = couponTaskMapper;
        this.actCreateCouponCombService = actCreateCouponCombService;
    }

    public void execute(String currentShardValue) {
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("==========\u5f00\u59cb\u6267\u884c\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff0ccurrentShardValue:[" + currentShardValue + "]==========");
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setPCode("MSC_totalShardCount");
        dicDictionaryPO.setCode("MSC_totalShardCount");
        DicDictionaryPO dictionaryPO = this.actDicDictionaryMapper.getModelByCondition(dicDictionaryPO);
        if (null == dictionaryPO) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u603b\u5206\u7247\u503c");
            }
            return;
        }
        List<Long> taskIdList = this.couponTaskMapper.select4CreateInstTimeTask(dictionaryPO.getTitle(), currentShardValue);
        ActCreateCouponCombReqBO createCouponCombReqBO = new ActCreateCouponCombReqBO();
        for (Long taskId : taskIdList) {
            createCouponCombReqBO.setTaskId(taskId);
            ActCreateCouponCombRspBO createCouponCombRspBO = this.actCreateCouponCombService.createCoupon(createCouponCombReqBO);
            if ("0000".equals(createCouponCombRspBO.getRespCode())) continue;
            LOGGER.error("\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u8c03\u7528\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff01" + createCouponCombRspBO.getRespDesc());
        }
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("==========\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0ccurrentShardValue:[" + currentShardValue + "]==========");
        }
    }
}

