/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.atom.ActSelectDictByCodeAndPcodeAtomService;
import com.tydic.newretail.atom.bo.ActSelectDictByCodeAndPcodeAtomReqBO;
import com.tydic.newretail.atom.bo.ActSelectDictByCodeAndPcodeAtomRspBO;
import com.tydic.newretail.busi.ActDictionaryBusiService;
import com.tydic.newretail.common.bo.ActDicDictionaryBO;
import com.tydic.newretail.dao.ActDicDictionaryMapper;
import com.tydic.newretail.dao.po.DicDictionaryPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actSelectDictByCodeAndPcodeAtomService")
public class ActSelectDictByCodeAndPcodeAtomServiceImpl
implements ActSelectDictByCodeAndPcodeAtomService {
    @Autowired
    private ActDicDictionaryMapper actDicDictionaryMapper;
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private ActDictionaryBusiService actDictionaryBusiService;

    @Override
    public ActSelectDictByCodeAndPcodeAtomRspBO queryDictByCodeAndPcode(ActSelectDictByCodeAndPcodeAtomReqBO atomReqBO) {
        ActSelectDictByCodeAndPcodeAtomRspBO rspBO = new ActSelectDictByCodeAndPcodeAtomRspBO();
        String pCode = atomReqBO.getPCode();
        String code = atomReqBO.getCode();
        String sysCode = atomReqBO.getSysCode();
        String redisKey = pCode + "_" + code + "_" + sysCode;
        Object object = this.cacheService.get(redisKey);
        if (object != null) {
            ActDicDictionaryBO dicDictionary = (ActDicDictionaryBO)object;
            rspBO.setDictionaryInfo(dicDictionary);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u4fe1\u606f\u6210\u529f");
            return rspBO;
        }
        DicDictionaryPO dictionaryPO = new DicDictionaryPO();
        dictionaryPO.setPCode(pCode);
        List<DicDictionaryPO> actDicDictionaryPOList = this.actDicDictionaryMapper.getListByCondition(dictionaryPO);
        if (CollectionUtils.isEmpty(actDicDictionaryPOList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6\u5b57\u5178\u503c\u4e0d\u5b58\u5728");
            return rspBO;
        }
        ArrayList<ActDicDictionaryBO> dicDictionaryBOList = new ArrayList<ActDicDictionaryBO>();
        for (DicDictionaryPO dicPO : actDicDictionaryPOList) {
            ActDicDictionaryBO dictionaryBO = new ActDicDictionaryBO();
            BeanUtils.copyProperties((Object)dicPO, (Object)dictionaryBO);
            dicDictionaryBOList.add(dictionaryBO);
            String key = dictionaryBO.getPCode() + "_" + dictionaryBO.getCode() + "_" + dictionaryBO.getSysCode();
            this.cacheService.set(key, (Object)dictionaryBO, 129600);
        }
        for (ActDicDictionaryBO dicDictionary : dicDictionaryBOList) {
            if (!dicDictionary.getCode().equals(code)) continue;
            rspBO.setDictionaryInfo(dicDictionary);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u4fe1\u606f\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u4fe1\u606f\u6210\u529f");
        return rspBO;
    }

    @Override
    public Map<String, String> queryDictBySysCodeAndPcode(String sysCode, String pCode) {
        Map result;
        if (StringUtils.isBlank((CharSequence)sysCode)) {
            throw new BusinessException("6666", "sysCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)pCode)) {
            throw new BusinessException("6666", "pCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String redisKey = pCode + "_" + sysCode;
        Object object = this.cacheService.get(redisKey);
        if (object != null) {
            result = (Map)object;
        } else {
            result = this.actDictionaryBusiService.queryBypCodeBackMap(sysCode, pCode);
            String key = pCode + "_" + sysCode;
            this.cacheService.set(key, (Object)result, 129600);
        }
        return result;
    }
}

