/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActCouponRecommendAbilityService;
import com.tydic.newretail.ability.bo.ActCouponRecommendAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCouponRecommendAbilityRspBO;
import com.tydic.newretail.busi.ActCouponRecommendBusiService;
import com.tydic.newretail.busi.bo.ActCouponRecommendBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponRecommendBusiRspBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponRecommendAbilityService")
public class ActCouponRecommendAbilityServiceImpl
implements ActCouponRecommendAbilityService {
    private ActCouponRecommendBusiService actCouponRecommendBusiService;

    @Autowired
    private ActCouponRecommendAbilityServiceImpl(ActCouponRecommendBusiService actCouponRecommendBusiService) {
        this.actCouponRecommendBusiService = actCouponRecommendBusiService;
    }

    public ActCouponRecommendAbilityRspBO recommendCoupon(ActCouponRecommendAbilityReqBO reqBO) {
        this.validParam(reqBO);
        ActCouponRecommendBusiReqBO busiReqBO = new ActCouponRecommendBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        ActCouponRecommendBusiRspBO busiRspBO = this.actCouponRecommendBusiService.recommendCoupon(busiReqBO);
        ActCouponRecommendAbilityRspBO rspBO = new ActCouponRecommendAbilityRspBO();
        BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
        return rspBO;
    }

    private void validParam(ActCouponRecommendAbilityReqBO reqBO) {
        String paramMsg = "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1";
        if (null == reqBO) {
            throw new BusinessException("8000", paramMsg + "\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getMemId() == null) {
            throw new BusinessException("8000", paramMsg + "\u4f1a\u5458ID[memId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getShopId() == null) {
            throw new BusinessException("8000", paramMsg + "\u5e97\u94faID[shopId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuList())) {
            throw new BusinessException("8000", paramMsg + "\u5355\u54c1\u5217\u8868[skuList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SkuDetailBO skuDetailBO : reqBO.getSkuList()) {
            if (StringUtils.isBlank((CharSequence)skuDetailBO.getSkuId())) {
                throw new BusinessException("8000", paramMsg + "\u5355\u54c1\u5217\u8868[skuList]\u4e2d\u7684\u5355\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailBO.getShopId()) {
                skuDetailBO.setShopId(reqBO.getShopId());
            }
            if (null == skuDetailBO.getSkuNum()) {
                throw new BusinessException("8000", paramMsg + "\u5355\u54c1\u5217\u8868[skuList]\u4e2d\u7684\u5355\u54c1\u6570\u91cf[skuNum]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != skuDetailBO.getSkuPrice()) continue;
            throw new BusinessException("8000", paramMsg + "\u5355\u54c1\u5217\u8868[skuList]\u4e2d\u7684\u5546\u54c1\u5355\u4ef7[skuPrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

