/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActCountFullReductionCountAtomService;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.newretail.common.bo.ActDiscountSkuListBO;
import com.tydic.newretail.common.bo.ActTemplateAttrBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actCountFullReductionCountAtomService")
public class ActCountFullReductionCountAtomServiceImpl
implements ActCountFullReductionCountAtomService {
    @Override
    public ActCalculationUniversalAtomRspBO calculateCountFullReductionCount(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        Collections.sort(atomReqBO.getSkuInfoList(), new Comparator<SkuCalculationActiveBO>(){

            @Override
            public int compare(SkuCalculationActiveBO o1, SkuCalculationActiveBO o2) {
                return o1.getSalePrice().subtract(o2.getSalePrice()).intValue();
            }
        });
        BigDecimal oldDiscountCount = new BigDecimal(0);
        for (SkuCalculationActiveBO skuCalculationActiveBO : atomReqBO.getSkuInfoList()) {
            if (null == skuCalculationActiveBO.getDiscountPrice()) continue;
            BigDecimal discountCount = skuCalculationActiveBO.getDiscountPrice().divide(skuCalculationActiveBO.getSalePrice());
            oldDiscountCount = oldDiscountCount.add(discountCount);
        }
        Integer totalSaleCount = 0;
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalSaleCount = totalSaleCount + bo.getActCount();
        }
        BigDecimal bigDecimal = new BigDecimal(totalSaleCount).subtract(oldDiscountCount);
        BigDecimal discountMoney = new BigDecimal(0);
        BigDecimal discountCount = new BigDecimal(0);
        if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal countReach = new BigDecimal(0);
        BigDecimal countReachDiscount = new BigDecimal(0);
        Integer isLoopAdd2 = ActCommConstant.isLoopAdd.NO;
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("count_reach".equals(bo.getAttrCode())) {
                countReach = new BigDecimal(bo.getParaValue());
                continue;
            }
            if ("count_reach_discount".equals(bo.getAttrCode())) {
                countReachDiscount = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"is_loop_add".equals(bo.getAttrCode())) continue;
            isLoopAdd2 = Integer.valueOf(bo.getParaValue());
        }
        if (bigDecimal.compareTo(countReach) >= 0) {
            if (ActCommConstant.isLoopAdd.YES.equals(isLoopAdd2)) {
                BigDecimal multply = bigDecimal.divide(countReach, 0, RoundingMode.DOWN);
                discountCount = countReachDiscount.multiply(multply);
            } else {
                discountCount = countReachDiscount;
            }
        }
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            BigDecimal lessDiscountCount = new BigDecimal(0);
            lessDiscountCount = null != bo.getDiscountPrice() ? bo.getTotalPrice().subtract(bo.getDiscountPrice()).divide(bo.getSalePrice()) : bo.getTotalPrice().divide(bo.getSalePrice());
            if (lessDiscountCount.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (discountCount.compareTo(lessDiscountCount) <= 0) {
                discountMoney = discountMoney.add(discountCount.multiply(bo.getSalePrice()));
                skuDiscountMap.put(bo.getSkuId(), discountCount.multiply(bo.getSalePrice()));
                break;
            }
            discountMoney = discountMoney.add(lessDiscountCount.multiply(bo.getSalePrice()));
            discountCount = discountCount.subtract(lessDiscountCount);
            skuDiscountMap.put(bo.getSkuId(), lessDiscountCount.multiply(bo.getSalePrice()));
        }
        actDiscountSkuListBO.setDiscountMoney(discountMoney);
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

