/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActLadderCountFullReductionDiscountRateAtomService;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.newretail.common.bo.ActDiscountSkuListBO;
import com.tydic.newretail.common.bo.ActTemplateAttrBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actLadderCountFullReductionDiscountRateAtomService")
public class ActLadderCountFullReductionDiscountRateAtomServiceImpl
implements ActLadderCountFullReductionDiscountRateAtomService {
    @Override
    public ActCalculationUniversalAtomRspBO calculateLadderCountFullReductionDiscountRate(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        Integer totalCount = 0;
        BigDecimal totalSalePrice = new BigDecimal(0);
        BigDecimal oldDiscountMoney = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalCount = totalCount + bo.getActCount();
            totalSalePrice = totalSalePrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            oldDiscountMoney = oldDiscountMoney.add(bo.getDiscountPrice());
        }
        BigDecimal calculateMoney = totalSalePrice.subtract(oldDiscountMoney);
        BigDecimal discountMoney = new BigDecimal(0);
        if (calculateMoney.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal countReachStar = new BigDecimal(0);
        BigDecimal countReachEnd = new BigDecimal(0);
        BigDecimal countReachDiscountRate = new BigDecimal(0);
        Integer isLoopAdd2 = ActCommConstant.isLoopAdd.NO;
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("count_reach_star".equals(bo.getAttrCode())) {
                countReachStar = new BigDecimal(bo.getParaValue());
                continue;
            }
            if ("count_reach_end".equals(bo.getAttrCode())) {
                countReachEnd = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"count_reach_discountRate".equals(bo.getAttrCode())) continue;
            countReachDiscountRate = new BigDecimal(bo.getParaValue());
        }
        if (calculateMoney.compareTo(countReachStar) >= 0) {
            discountMoney = calculateMoney.subtract(calculateMoney.multiply(countReachDiscountRate));
        }
        actDiscountSkuListBO.setDiscountMoney(discountMoney);
        BigDecimal averageDiscountPrice = discountMoney.divide(new BigDecimal(atomReqBO.getSkuInfoList().size()), 2, RoundingMode.HALF_UP);
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        int fullFeeCount = 0;
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            if (bo.getTotalPrice().compareTo(averageDiscountPrice) > 0) {
                skuDiscountMap.put(bo.getSkuId(), averageDiscountPrice);
                continue;
            }
            skuDiscountMap.put(bo.getSkuId(), bo.getTotalPrice());
            averageDiscountPrice = discountMoney.subtract(bo.getTotalPrice()).divide(new BigDecimal(atomReqBO.getSkuInfoList().size() - ++fullFeeCount), 2, RoundingMode.HALF_UP);
        }
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

