/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActUniversalCalculationAbilityService;
import com.tydic.newretail.ability.bo.ActUniversalCalculationAbilityReqBO;
import com.tydic.newretail.ability.bo.ActUniversalCalculationAbilityRspBO;
import com.tydic.newretail.comb.ActUniversalCalculationCombService;
import com.tydic.newretail.comb.bo.ActUniversalCalculationCombReqBO;
import com.tydic.newretail.comb.bo.ActUniversalCalculationCombRspBO;
import com.tydic.newretail.common.bo.SkuActiveChoiceBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actUniversalCalculationAbilityService")
public class ActUniversalCalculationAbilityServiceImpl
implements ActUniversalCalculationAbilityService {
    @Autowired
    private ActUniversalCalculationCombService actUniversalCalculationCombService;

    public ActUniversalCalculationAbilityRspBO calculatePrice(ActUniversalCalculationAbilityReqBO abilityReqBO) {
        ActUniversalCalculationAbilityRspBO rsp = new ActUniversalCalculationAbilityRspBO();
        this.validateParam(abilityReqBO);
        for (SkuCalculationActiveBO bo : abilityReqBO.getSkuInfoList()) {
            bo.setTotalPrice(bo.getSalePrice().multiply(bo.getActCount()));
        }
        ActUniversalCalculationCombReqBO actUniversalCalculationCombReqBO = new ActUniversalCalculationCombReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)actUniversalCalculationCombReqBO);
        ActUniversalCalculationCombRspBO actUniversalCalculationCombRspBO = this.actUniversalCalculationCombService.calculatePrice(actUniversalCalculationCombReqBO);
        BeanUtils.copyProperties((Object)actUniversalCalculationCombRspBO, (Object)rsp);
        return rsp;
    }

    private void validateParam(ActUniversalCalculationAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getSkuInfoList())) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (SkuCalculationActiveBO bo : abilityReqBO.getSkuInfoList()) {
            if (StringUtils.isBlank((CharSequence)bo.getSkuId())) {
                throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getShopId()) {
                throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.shopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getActCount()) {
                throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.actCount\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != bo.getSalePrice()) continue;
            throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.salePrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getChoiceSkuInfoBOList())) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010choiceSkuInfoBOList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (SkuActiveChoiceBO bo2 : abilityReqBO.getChoiceSkuInfoBOList()) {
            if (null == bo2.getActiveId()) {
                throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010choiceSkuInfoBOList.activeId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)bo2.getSkuIdList())) {
                throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010choiceSkuInfoBOList.skuIdList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            for (String skuId : bo2.getSkuIdList()) {
                if (!StringUtils.isBlank((CharSequence)skuId)) continue;
                throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010choiceSkuInfoBOList.skuIdList.skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

