/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.atom.ActAddActivityGiftAtomService;
import com.tydic.newretail.atom.bo.ActAddActivityGiftAtomReqBO;
import com.tydic.newretail.atom.bo.ActAddActivityGiftAtomRspBO;
import com.tydic.newretail.common.bo.ActiveGiftBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveGiftMapper;
import com.tydic.newretail.dao.ActiveGiftStockMapper;
import com.tydic.newretail.dao.po.ActiveGiftPO;
import com.tydic.newretail.dao.po.ActiveGiftStockPO;
import java.math.BigDecimal;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actAddActivityGiftAtomService")
public class ActAddActivityGiftAtomServiceImpl
implements ActAddActivityGiftAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActAddActivityGiftAtomServiceImpl.class);
    @Autowired
    private ActiveGiftMapper activeGiftMapper;
    @Autowired
    private ActiveGiftStockMapper activeGiftStockMapper;

    @Override
    public ActAddActivityGiftAtomRspBO addActivityGift(ActAddActivityGiftAtomReqBO atomReqBO) {
        ActAddActivityGiftAtomRspBO atomRspBO = new ActAddActivityGiftAtomRspBO();
        if (CollectionUtils.isNotEmpty(atomReqBO.getActiveGiftList())) {
            for (ActiveGiftBO activeGiftBO : atomReqBO.getActiveGiftList()) {
                int activityGiftInsertResult;
                ActiveGiftPO activeGiftPO = new ActiveGiftPO();
                BeanUtils.copyProperties((Object)activeGiftBO, (Object)activeGiftPO);
                activeGiftPO.setId(Sequence.getInstance().nextId());
                activeGiftPO.setActiveId(atomReqBO.getActiveId());
                try {
                    activeGiftPO.setGiftPrice(MoneyUtils.BigDecimal2Long((BigDecimal)activeGiftBO.getGiftPrice()));
                }
                catch (Exception e) {
                    LOGGER.error("\u8d60\u54c1\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
                    atomRspBO.setRespCode("1021");
                    atomRspBO.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8d60\u54c1\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
                    return atomRspBO;
                }
                if (null == activeGiftPO.getGiftCount()) {
                    activeGiftPO.setGiftCount(ActCommConstant.ACT_COUNT_DEFAULT_VALUE);
                }
                if (null == activeGiftPO.getSendCount()) {
                    activeGiftPO.setSendCount(ActCommConstant.SALE_SEND_COUNT_DEFAULT_VALUE);
                }
                if (null == activeGiftPO.getAlCount()) {
                    activeGiftPO.setAlCount(ActCommConstant.SINGLE_GIFT_DEFAULT_VALUE);
                }
                if (null == activeGiftPO.getIsSend()) {
                    activeGiftPO.setIsSend(ActCommConstant.WHETHER_GIFT_MUST_SEND_DEFAULT_VALUE);
                }
                if (null == activeGiftPO.getGiftType()) {
                    activeGiftPO.setGiftType(ActCommConstant.GIFT_TYPE_DEFAULT_VALUE);
                }
                if ((activityGiftInsertResult = this.activeGiftMapper.insert(activeGiftPO)) <= 0) {
                    atomRspBO.setRespCode("1020");
                    atomRspBO.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u6d3b\u52a8\u8d60\u54c1\u8868\u5931\u8d25\uff01");
                    return atomRspBO;
                }
                ActiveGiftStockPO activeGiftStockPO = new ActiveGiftStockPO();
                BeanUtils.copyProperties((Object)activeGiftBO, (Object)activeGiftStockPO);
                if (null == activeGiftStockPO.getGiftCount()) {
                    activeGiftStockPO.setGiftCount(ActCommConstant.ACT_COUNT_DEFAULT_VALUE);
                }
                if (null == activeGiftStockPO.getSendCount()) {
                    activeGiftStockPO.setSendCount(ActCommConstant.SALE_SEND_COUNT_DEFAULT_VALUE);
                }
                activeGiftStockPO.setId(Sequence.getInstance().nextId());
                activeGiftStockPO.setActiveId(atomReqBO.getActiveId());
                activeGiftStockPO.setGiftId(activeGiftPO.getId());
                int activityGiftStockInsertResult = this.activeGiftStockMapper.insert(activeGiftStockPO);
                if (activityGiftStockInsertResult > 0) continue;
                atomRspBO.setRespCode("1020");
                atomRspBO.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u6d3b\u52a8\u8d60\u54c1\u5e93\u5b58\u8868\u5931\u8d25\uff01");
                return atomRspBO;
            }
        }
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6d3b\u52a8\u8d60\u54c1\u65b0\u589e\u6210\u529f");
        return atomRspBO;
    }
}

