/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.utils;

import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class ActPropertiesUtils
implements ApplicationListener<ContextRefreshedEvent> {
    private static TreeMap treeMap = new TreeMap();
    private static Properties propertiesFileLoader;

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (contextRefreshedEvent.getApplicationContext().getParent() == null) {
            ActPropertiesUtils.init();
        }
    }

    public static void init() {
        propertiesFileLoader.entrySet().stream().forEach(e -> treeMap.put(e.getKey(), e.getValue()));
    }

    public static String getProperty(String key) {
        if (!treeMap.containsKey(key)) {
            ActPropertiesUtils.init();
        }
        return null == treeMap.get(key) ? null : String.valueOf(treeMap.get(key)).trim();
    }

    public static String getProperty(String key, String defaultValue) {
        String value;
        if (!treeMap.containsKey(key)) {
            ActPropertiesUtils.init();
        }
        return StringUtils.isBlank((CharSequence)(value = ActPropertiesUtils.getProperty(key))) ? defaultValue : value;
    }

    public static Long getLongProperty(String key) {
        String value = ActPropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    public static Long getLongProperty(String key, Long defaultValue) {
        Long value = ActPropertiesUtils.getLongProperty(key);
        return null == value ? defaultValue : value;
    }

    public static Integer getIntProperty(String key) {
        String value = ActPropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public static Integer getIntProperty(String key, Integer defaultValue) {
        Integer value = ActPropertiesUtils.getIntProperty(key);
        return null == value ? defaultValue : value;
    }

    public static Boolean getBooleanProperty(String key) {
        String value = ActPropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public static Boolean getBooleanProperty(String key, Boolean defaultValue) {
        Boolean value = ActPropertiesUtils.getBooleanProperty(key);
        return null == value ? defaultValue : value;
    }

    @Autowired
    public void setProps(Properties propertiesFileLoader) {
        ActPropertiesUtils.propertiesFileLoader = propertiesFileLoader;
    }
}

