/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActCouponListValidCheckAtomService;
import com.tydic.newretail.atom.bo.ActCouponListValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCouponListValidCheckAtomRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.po.CouponInstPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCouponListValidCheckAtomService")
public class ActCouponListValidCheckAtomServiceImpl
implements ActCouponListValidCheckAtomService {
    @Autowired
    private CouponInstMapper couponInstMapper;

    @Override
    public ActCouponListValidCheckAtomRspBO checkCouponListValid(ActCouponListValidCheckAtomReqBO atomReqBO) {
        ActCouponListValidCheckAtomRspBO atomRspBO = new ActCouponListValidCheckAtomRspBO();
        List<CouponInstPO> couponInstPOList = this.couponInstMapper.getListByPKList(atomReqBO.getCouponNoList());
        if (CollectionUtils.isEmpty(couponInstPOList)) {
            atomRspBO.setCouponValidMark(ActCommConstant.CouponValidMark.INEFFECTIVE);
            atomRspBO.setRespCode("0000");
            atomRspBO.setRespDesc("\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
            return atomRspBO;
        }
        ArrayList<String> expiredList = new ArrayList<String>();
        ArrayList<String> usedList = new ArrayList<String>();
        ArrayList<String> overdueList = new ArrayList<String>();
        ArrayList<String> ineffList = new ArrayList<String>();
        Date now = new Date();
        for (CouponInstPO couponInstPO : couponInstPOList) {
            if (ActCommConstant.CouponState.EXPIRED.equals(couponInstPO.getState())) {
                expiredList.add(couponInstPO.getCouponNo());
            }
            if (ActCommConstant.CouponState.USED.equals(couponInstPO.getState())) {
                usedList.add(couponInstPO.getCouponNo());
            }
            if (couponInstPO.getExpTime().before(now)) {
                overdueList.add(couponInstPO.getCouponNo());
            }
            if (!couponInstPO.getEffTime().after(now)) continue;
            ineffList.add(couponInstPO.getCouponNo());
        }
        if (CollectionUtils.isNotEmpty(expiredList)) {
            atomRspBO.setExpiredList(expiredList);
        }
        if (CollectionUtils.isNotEmpty(usedList)) {
            atomRspBO.setUsedList(usedList);
        }
        if (CollectionUtils.isNotEmpty(overdueList)) {
            atomRspBO.setOverdueList(overdueList);
        }
        if (CollectionUtils.isNotEmpty(ineffList)) {
            atomRspBO.setIneffList(ineffList);
        }
        if (CollectionUtils.isEmpty(expiredList) && CollectionUtils.isEmpty(usedList) && CollectionUtils.isEmpty(overdueList) && CollectionUtils.isEmpty(ineffList)) {
            atomRspBO.setCouponValidMark(ActCommConstant.CouponValidMark.VALID);
            atomRspBO.setRespCode("0000");
            atomRspBO.setRespDesc("\u4f18\u60e0\u5238\u6709\u6548");
        } else {
            atomRspBO.setCouponValidMark(ActCommConstant.CouponValidMark.INEFFECTIVE);
            atomRspBO.setRespCode("0000");
            atomRspBO.setRespDesc("\u4f18\u60e0\u5238\u65e0\u6548");
        }
        return atomRspBO;
    }
}

