/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.atom.ActActivityCheckAtomService;
import com.tydic.newretail.atom.ActAddActivityTemplateAttrAtomService;
import com.tydic.newretail.atom.bo.ActAddActivityTemplateAttrAtomReqBO;
import com.tydic.newretail.atom.bo.ActAddActivityTemplateAttrAtomRspBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomRspBO;
import com.tydic.newretail.busi.ActActivitySkuAddBusiService;
import com.tydic.newretail.busi.ActCreateCouponBusiService;
import com.tydic.newretail.busi.bo.ActActivitySkuAddBusiReqBO;
import com.tydic.newretail.busi.bo.ActActivitySkuAddBusiRspBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiRspBO;
import com.tydic.newretail.common.bo.ActDiscountBO;
import com.tydic.newretail.common.bo.ActMemRangeBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveMemRangeMapper;
import com.tydic.newretail.dao.ActiveShowPozitionMapper;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponNumMapper;
import com.tydic.newretail.dao.po.ActiveMemRangePO;
import com.tydic.newretail.dao.po.ActiveShowPozitionPO;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.CouponNumPO;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponBusiService")
public class ActCreateCouponBusiServiceImpl
implements ActCreateCouponBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateCouponBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Autowired
    private ActAddActivityTemplateAttrAtomService actAddActivityTemplateAttrAtomService;
    @Autowired
    private ActActivitySkuAddBusiService actActivitySkuAddBusiService;
    @Autowired
    private ActiveMemRangeMapper activeMemRangeMapper;
    @Autowired
    private ActiveShowPozitionMapper activeShowPozitionMapper;
    @Autowired
    private CouponNumMapper couponNumMapper;
    @Autowired
    private ActActivityCheckAtomService actActivityCheckAtomService;
    @Value(value="${couponDetailUrl}")
    private String couponDetailUrl;

    public ActCreateCouponBusiRspBO createCoupon(ActCreateCouponBusiReqBO busiReqBO) {
        int isInsert4;
        ActCreateCouponBusiRspBO rsp = new ActCreateCouponBusiRspBO();
        ActCreateActivityCheckAtomReqBO checkAtomReqBO = new ActCreateActivityCheckAtomReqBO();
        checkAtomReqBO.setActTemplateBOS(busiReqBO.getActTemplateBOS());
        ActCreateActivityCheckAtomRspBO checkAtomRspBO = this.actActivityCheckAtomService.checkCreateActivityInfo(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            LOGGER.error("\u4f18\u60e0\u5238\u65b0\u589e\u6821\u9a8c\u5931\u8d25" + checkAtomRspBO.getRespDesc());
            BeanUtils.copyProperties((Object)((Object)checkAtomRspBO), (Object)rsp);
            return rsp;
        }
        Long fmId = Sequence.getInstance().nextId();
        CouponFormPO couponFormPO = this.buildCouponFormPO(busiReqBO, checkAtomRspBO);
        couponFormPO.setFmId(fmId);
        couponFormPO.setDetailUrl(this.couponDetailUrl + fmId + "&admOrgId=" + couponFormPO.getAdmOrgId());
        int isInsert = this.couponFormMapper.insert(couponFormPO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u4f18\u60e0\u5377\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        ActAddActivityTemplateAttrAtomReqBO actAddActivityTemplateAttrAtomReqBO = new ActAddActivityTemplateAttrAtomReqBO();
        actAddActivityTemplateAttrAtomReqBO.setActTemplateBOS(busiReqBO.getActTemplateBOS());
        actAddActivityTemplateAttrAtomReqBO.setMarketingType("11");
        actAddActivityTemplateAttrAtomReqBO.setActiveId(fmId);
        actAddActivityTemplateAttrAtomReqBO.setOperType("operTemplate");
        ActAddActivityTemplateAttrAtomRspBO actAddActivityTemplateAttrAtomRspBO = this.actAddActivityTemplateAttrAtomService.addActivityTemplateAttr(actAddActivityTemplateAttrAtomReqBO);
        if (!"0000".equals(actAddActivityTemplateAttrAtomRspBO.getRespCode())) {
            throw new BusinessException(actAddActivityTemplateAttrAtomRspBO.getRespCode(), actAddActivityTemplateAttrAtomRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getSkuInfoList())) {
            ActActivitySkuAddBusiReqBO actActivitySkuAddBusiReqBO = new ActActivitySkuAddBusiReqBO();
            actActivitySkuAddBusiReqBO.setActiveId(fmId);
            actActivitySkuAddBusiReqBO.setMarketingType("11");
            actActivitySkuAddBusiReqBO.setSkuInfoList(busiReqBO.getSkuInfoList());
            ActActivitySkuAddBusiRspBO actActivitySkuAddBusiRspBO = this.actActivitySkuAddBusiService.addActivitySku(actActivitySkuAddBusiReqBO);
            if (!"0000".equals(actActivitySkuAddBusiRspBO.getRespCode())) {
                throw new BusinessException(actActivitySkuAddBusiRspBO.getRespCode(), actActivitySkuAddBusiRspBO.getRespDesc());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getMemRangeList())) {
            ArrayList<ActiveMemRangePO> activeMemRangePOList = new ArrayList<ActiveMemRangePO>();
            for (ActMemRangeBO bo : busiReqBO.getMemRangeList()) {
                ActiveMemRangePO activeMemRangePO = new ActiveMemRangePO();
                BeanUtils.copyProperties((Object)bo, (Object)activeMemRangePO);
                activeMemRangePO.setMemRangeId(Sequence.getInstance().nextId());
                activeMemRangePO.setActiveId(fmId);
                activeMemRangePO.setMarketingType("11");
                activeMemRangePOList.add(activeMemRangePO);
            }
            int isInsert2 = this.activeMemRangeMapper.insertBatch(activeMemRangePOList);
            if (isInsert2 != activeMemRangePOList.size()) {
                throw new BusinessException("8888", "\u6d3b\u52a8\u4f1a\u5458\u8303\u56f4\u8868\u65b0\u589e\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getShowPozitonList())) {
            ArrayList<ActiveShowPozitionPO> activeShowPozitionPOList = new ArrayList<ActiveShowPozitionPO>();
            for (ActMemRangeBO bo : busiReqBO.getShowPozitonList()) {
                ActiveShowPozitionPO activeShowPozitionPO = new ActiveShowPozitionPO();
                BeanUtils.copyProperties((Object)bo, (Object)activeShowPozitionPO);
                activeShowPozitionPO.setShowPozitionId(Sequence.getInstance().nextId());
                activeShowPozitionPO.setActiveId(fmId);
                activeShowPozitionPO.setMarketingType("11");
                activeShowPozitionPO.setState(ActCommConstant.CouponValidMark.VALID);
                activeShowPozitionPOList.add(activeShowPozitionPO);
            }
            int isInsert3 = this.activeShowPozitionMapper.insertBatch(activeShowPozitionPOList);
            if (isInsert3 != activeShowPozitionPOList.size()) {
                throw new BusinessException("8888", "\u6d3b\u52a8\u6295\u653e\u4f4d\u7f6e\u8868\u65b0\u589e\u5931\u8d25\uff01");
            }
        }
        CouponNumPO couponNumPO = new CouponNumPO();
        couponNumPO.setAmountTotalId(Sequence.getInstance().nextId());
        couponNumPO.setFmId(fmId);
        couponNumPO.setTotalNum(busiReqBO.getTotalAmount());
        couponNumPO.setMemLimitNum(busiReqBO.getMemLimitAmount());
        if (null == couponNumPO.getTotalNum()) {
            couponNumPO.setTotalNum(0L);
        }
        if ((isInsert4 = this.couponNumMapper.insert(couponNumPO)) < 1) {
            throw new BusinessException("8888", "\u4f18\u60e0\u5377\u6570\u91cf\u63a7\u5236\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f18\u60e0\u5238\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
        return rsp;
    }

    private CouponFormPO buildCouponFormPO(ActCreateCouponBusiReqBO busiReqBO, ActCreateActivityCheckAtomRspBO checkAtomRspBO) {
        CouponFormPO couponFormPO = new CouponFormPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)couponFormPO);
        couponFormPO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
        couponFormPO.setState(ActCommConstant.CouponFormState.AUDIT_PASS);
        if (!CollectionUtils.isEmpty(checkAtomRspBO.getActDiscountBOs())) {
            ActDiscountBO actDiscountBO = checkAtomRspBO.getActDiscountBOs().get(0);
            couponFormPO.setConditionType(actDiscountBO.getConditionType());
            couponFormPO.setConditionValue(actDiscountBO.getConditionValue());
            couponFormPO.setDiscountType(actDiscountBO.getDiscountType());
            couponFormPO.setDiscountValue(actDiscountBO.getDiscountValue());
        }
        return couponFormPO;
    }
}

