/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActCreateCouponAppApprovalBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponAppApprovalBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponAppApprovalBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponTaskMapper;
import com.tydic.newretail.dao.po.CouponTaskPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCreateCouponAppApprovalBusiService")
public class ActCreateCouponAppApprovalBusiServiceImpl
implements ActCreateCouponAppApprovalBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateCouponAppApprovalBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final Integer AGREE = 1;
    private static final Integer NOT_AGREE = 2;
    private CouponTaskMapper couponTaskMapper;

    @Autowired
    private ActCreateCouponAppApprovalBusiServiceImpl(CouponTaskMapper couponTaskMapper) {
        this.couponTaskMapper = couponTaskMapper;
    }

    public ActCreateCouponAppApprovalBusiRspBO executeCreateCouponAppApproval(ActCreateCouponAppApprovalBusiReqBO reqBO) {
        int result;
        ActCreateCouponAppApprovalBusiRspBO rspBO = new ActCreateCouponAppApprovalBusiRspBO();
        for (Long taskId : reqBO.getTaskIdList()) {
            CouponTaskPO taskPO = new CouponTaskPO();
            taskPO.setTaskId(taskId);
            taskPO.setTaskState(ActCommConstant.CouponTaskState.PENDING_AUDIT);
            int check = this.couponTaskMapper.getCheckBy(taskPO);
            if (check >= 1) continue;
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("taskId:[" + taskId + "]\u4e0d\u5b58\u5728\u6216\u4e0d\u5904\u4e8e\u5f85\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6279");
            }
            throw new BusinessException("6038", "\u5ba1\u6279\u5931\u8d25\uff01taskId:[" + taskId + "]\u4e0d\u5b58\u5728\u6216\u4e0d\u5904\u4e8e\u5f85\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6279");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAuditDesc())) {
            if (AGREE.equals(reqBO.getOperType())) {
                reqBO.setAuditDesc("\u540c\u610f");
            } else if (NOT_AGREE.equals(reqBO.getOperType())) {
                reqBO.setAuditDesc("\u4e0d\u540c\u610f");
            }
        }
        if ((result = this.couponTaskMapper.taskApproval(reqBO)) < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f18\u60e0\u5238\u521b\u5efa\u7533\u8bf7\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u6267\u884c\u66f4\u65b0\u5931\u8d25\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6038", "\u4f18\u60e0\u5238\u521b\u5efa\u7533\u8bf7\u5ba1\u6279\u670d\u52a1\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u521b\u5efa\u7533\u8bf7\u5ba1\u6279\u670d\u52a1\u6210\u529f");
        return rspBO;
    }
}

