/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActCouponCalculationAbilityService;
import com.tydic.newretail.ability.bo.ActCouponCalculationAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCouponCalculationAbilityRspBO;
import com.tydic.newretail.comb.ActCouponCalculationCombService;
import com.tydic.newretail.comb.bo.ActCouponCalculationCombReqBO;
import com.tydic.newretail.comb.bo.ActCouponCalculationCombRspBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponCalculationAbilityService")
public class ActCouponCalculationAbilityServiceImpl
implements ActCouponCalculationAbilityService {
    @Autowired
    private ActCouponCalculationCombService actCouponCalculationCombService;

    public ActCouponCalculationAbilityRspBO couponCalculatePrice(ActCouponCalculationAbilityReqBO abilityReqBO) {
        ActCouponCalculationAbilityRspBO rsp = new ActCouponCalculationAbilityRspBO();
        this.validateParam(abilityReqBO);
        ActCouponCalculationCombReqBO actCouponCalculationCombReqBO = new ActCouponCalculationCombReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)actCouponCalculationCombReqBO);
        ActCouponCalculationCombRspBO actCouponCalculationCombRspBO = this.actCouponCalculationCombService.couponCalculatePrice(actCouponCalculationCombReqBO);
        BeanUtils.copyProperties((Object)actCouponCalculationCombRspBO, (Object)rsp);
        return rsp;
    }

    private void validateParam(ActCouponCalculationAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO) {
            throw new BusinessException("14000", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getSkuInfoList())) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (SkuCalculationActiveBO bo : abilityReqBO.getSkuInfoList()) {
            if (StringUtils.isBlank((CharSequence)bo.getSkuId())) {
                throw new BusinessException("14001", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)bo.getCommodityId())) {
                throw new BusinessException("14001", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.commodityId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getShopId()) {
                throw new BusinessException("14001", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.shopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getActCount()) {
                throw new BusinessException("14001", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.actCount\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != bo.getSalePrice()) continue;
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.salePrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getCouponNolist())) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010couponNolist\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (SkuCalculationActiveBO bo : abilityReqBO.getCouponNolist()) {
            if (null == bo.getFmId()) {
                throw new BusinessException("14001", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010couponNolist.fmId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isBlank((CharSequence)bo.getCouponNo())) continue;
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1API\u5165\u53c2\u3010couponNolist.couponNo\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

