/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActMoneyFullReductionDiscountRateAtomService;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.newretail.common.bo.ActDiscountSkuListBO;
import com.tydic.newretail.common.bo.ActTemplateAttrBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actMoneyFullReductionDiscountRateAtomService")
public class ActMoneyFullReductionDiscountRateAtomServiceImpl
implements ActMoneyFullReductionDiscountRateAtomService {
    @Override
    public ActCalculationUniversalAtomRspBO calculateMoneyFullReductionDiscountRate(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        BigDecimal totalSalePrice = new BigDecimal(0);
        BigDecimal oldDiscountMoney = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalSalePrice = totalSalePrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            oldDiscountMoney = oldDiscountMoney.add(bo.getDiscountPrice());
        }
        BigDecimal calculateMoney = totalSalePrice.subtract(oldDiscountMoney);
        BigDecimal discountMoney = new BigDecimal(0);
        if (calculateMoney.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal feeReach = new BigDecimal(0);
        BigDecimal feeReachDiscountRate = new BigDecimal(0);
        Integer isLoopAdd2 = ActCommConstant.isLoopAdd.NO;
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("fee_reach".equals(bo.getAttrCode())) {
                feeReach = new BigDecimal(bo.getParaValue());
                continue;
            }
            if ("fee_reach_discountRate".equals(bo.getAttrCode())) {
                feeReachDiscountRate = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"is_loop_add".equals(bo.getAttrCode())) continue;
            isLoopAdd2 = Integer.valueOf(bo.getParaValue());
        }
        if (calculateMoney.compareTo(feeReach) >= 0) {
            if (ActCommConstant.isLoopAdd.YES.equals(isLoopAdd2)) {
                BigDecimal multply = calculateMoney.divide(feeReach, 0, RoundingMode.DOWN);
                discountMoney = calculateMoney.subtract(calculateMoney.multiply(feeReachDiscountRate).multiply(multply));
            } else {
                discountMoney = calculateMoney.subtract(calculateMoney.multiply(feeReachDiscountRate));
            }
        }
        actDiscountSkuListBO.setDiscountMoney(discountMoney);
        BigDecimal averageDiscountPrice = discountMoney.divide(new BigDecimal(atomReqBO.getSkuInfoList().size()), 2, RoundingMode.HALF_UP);
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        int fullFeeCount = 0;
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            if (bo.getTotalPrice().compareTo(averageDiscountPrice) > 0) {
                skuDiscountMap.put(bo.getSkuId(), averageDiscountPrice);
                continue;
            }
            skuDiscountMap.put(bo.getSkuId(), bo.getTotalPrice());
            averageDiscountPrice = discountMoney.subtract(bo.getTotalPrice()).divide(new BigDecimal(atomReqBO.getSkuInfoList().size() - ++fullFeeCount), 2, RoundingMode.HALF_UP);
        }
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

