/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.ability.ActCreateCouponAbilityService;
import com.tydic.newretail.ability.bo.ActCreateCouponAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCreateCouponAbilityRspBO;
import com.tydic.newretail.busi.ActCreateCouponBusiService;
import com.tydic.newretail.busi.ActDictionaryBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiRspBO;
import com.tydic.newretail.common.bo.ActMemRangeBO;
import com.tydic.newretail.common.bo.SkuActiveBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponAbillityService")
public class ActCreateCouponAbillityServiceImpl
implements ActCreateCouponAbilityService {
    private static final String PARAM_MSG = "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    @Autowired
    private ActCreateCouponBusiService actCreateCouponBusiService;
    @Autowired
    private ActDictionaryBusiService actDictionaryBusiService;

    public ActCreateCouponAbilityRspBO createCoupon(ActCreateCouponAbilityReqBO abilityReqBO) {
        this.validateArg(abilityReqBO);
        ActCreateCouponAbilityRspBO rsp = new ActCreateCouponAbilityRspBO();
        ActCreateCouponBusiReqBO busiReqBO = new ActCreateCouponBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)busiReqBO);
        ActCreateCouponBusiRspBO actCreateCouponBusiRspBO = this.actCreateCouponBusiService.createCoupon(busiReqBO);
        BeanUtils.copyProperties((Object)actCreateCouponBusiRspBO, (Object)rsp);
        return rsp;
    }

    private void validateArg(ActCreateCouponAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[abilityReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getAdmOrgId())) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[admOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getFmName())) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[fmName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getCouponMark())) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[couponMark]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getImageUrl())) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[imageUrl]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getCouponType()) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[couponType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((abilityReqBO.getCouponType().equals(ActCommConstant.CouponTypeCode.FULL_SUBTRACTION) || abilityReqBO.getCouponType().equals(ActCommConstant.CouponTypeCode.FULL_DISCOUNT)) && null == abilityReqBO.getCouponLevel()) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[couponLevel]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getEffTime()) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[effTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        abilityReqBO.setEffTime(DateUtils.strToDateLong((String)DateUtils.getCurrentMinDate((String)DateUtils.dateToStrLong((Date)abilityReqBO.getEffTime()))));
        if (null == abilityReqBO.getExpTime()) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[expTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        abilityReqBO.setExpTime(DateUtils.strToDateLong((String)DateUtils.getCurrentMaxDate((String)DateUtils.dateToStrLong((Date)abilityReqBO.getExpTime()))));
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getActTemplateBOS())) {
            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[actTemplateBOS]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getMemRangeList())) {
            Map memParamType = this.actDictionaryBusiService.queryBypCodeBackMap("MSC", "MEM_PARAM_TYPE");
            if (CollectionUtils.isEmpty((Map)memParamType)) {
                throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u6682\u4e0d\u652f\u6301\u4f1a\u5458\u8303\u56f4\u914d\u7f6e");
            }
            for (ActMemRangeBO bo : abilityReqBO.getMemRangeList()) {
                if (StringUtils.isBlank((CharSequence)bo.getMemParamType())) {
                    throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[memRangeList.memParamType]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String memParamTypeCode = (String)memParamType.get(bo.getMemParamType());
                if (memParamTypeCode == null) {
                    throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f1a\u5458\u53c2\u6570\u7c7b\u578b\u3010" + bo.getMemParamType() + "\u6682\u4e0d\u652f\u6301\u3011");
                }
                if (StringUtils.isBlank((CharSequence)bo.getParamInsCode())) {
                    throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[memRangeList.paramInsCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isBlank((CharSequence)bo.getParamInsName())) continue;
                throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[memRangeList.paramInsName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getShowPozitonList())) {
            Map positionCode = this.actDictionaryBusiService.queryBypCodeBackMap("MSC", "POSITION_CODE");
            if (CollectionUtils.isEmpty((Map)positionCode)) {
                throw new BusinessException("0002", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u6682\u4e0d\u652f\u6301\u6309\u5c55\u793a\u4f4d\u7f6e\u914d\u7f6e");
            }
            for (ActMemRangeBO bo : abilityReqBO.getShowPozitonList()) {
                if (StringUtils.isBlank((CharSequence)bo.getPozitionCode())) {
                    throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[showPozitonList.pozitionCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String positionCodeName = (String)positionCode.get(bo.getPozitionCode());
                if (positionCodeName == null) {
                    throw new BusinessException("0002", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f4d\u7f6e\u7f16\u7801\u3010" + bo.getPozitionCode() + "\u6682\u4e0d\u652f\u6301\u3011");
                }
                bo.setPozitionName(positionCodeName);
            }
        }
        if (abilityReqBO.getCouponType().equals(ActCommConstant.CouponTypeCode.FULL_SUBTRACTION) || abilityReqBO.getCouponType().equals(ActCommConstant.CouponTypeCode.FULL_DISCOUNT)) {
            ArrayList<SkuActiveBO> skuInfoListNew = new ArrayList<SkuActiveBO>();
            if (!abilityReqBO.getCouponLevel().equals(ActCommConstant.CouponLevel.LEVEL_PLATFORM) && !CollectionUtils.isEmpty((Collection)abilityReqBO.getSkuInfoList())) {
                for (ActMemRangeBO bo : abilityReqBO.getSkuInfoList()) {
                    SkuActiveBO boNew = new SkuActiveBO();
                    if (abilityReqBO.getCouponLevel().equals(ActCommConstant.CouponLevel.LEVEL_SKU)) {
                        if (StringUtils.isBlank((CharSequence)bo.getSkuId())) {
                            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[skuInfoList.skuId]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)bo.getCommodityId())) {
                            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[skuInfoList.commodityId]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        boNew.setSkuId(bo.getSkuId());
                        boNew.setCommodityId(bo.getCommodityId());
                        skuInfoListNew.add(boNew);
                    }
                    if (abilityReqBO.getCouponLevel().equals(ActCommConstant.CouponLevel.SKU_COMMODITY)) {
                        if (StringUtils.isBlank((CharSequence)bo.getCommodityId())) {
                            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[skuInfoList.commodityId]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        boNew.setCommodityId(bo.getCommodityId());
                        skuInfoListNew.add(boNew);
                    }
                    if (abilityReqBO.getCouponLevel().equals(ActCommConstant.CouponLevel.SKU_L1CATEGORY)) {
                        if (StringUtils.isBlank((CharSequence)bo.getCategory1Id())) {
                            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[skuInfoList.Category1Id]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        boNew.setCategory1Id(bo.getCategory1Id());
                        skuInfoListNew.add(boNew);
                    }
                    if (abilityReqBO.getCouponLevel().equals(ActCommConstant.CouponLevel.SKU_L2CATEGORY)) {
                        if (StringUtils.isBlank((CharSequence)bo.getCategory2Id())) {
                            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[skuInfoList.Category2Id]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        boNew.setCategory2Id(bo.getCategory2Id());
                        skuInfoListNew.add(boNew);
                    }
                    if (abilityReqBO.getCouponLevel().equals(ActCommConstant.CouponLevel.SKU_L3CATEGORY)) {
                        if (StringUtils.isBlank((CharSequence)bo.getCategory3Id())) {
                            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[skuInfoList.Category3Id]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        boNew.setCategory3Id(bo.getCategory3Id());
                        skuInfoListNew.add(boNew);
                    }
                    if (abilityReqBO.getCouponLevel().equals(ActCommConstant.CouponLevel.SKU_L4CATEGORY)) {
                        if (StringUtils.isBlank((CharSequence)bo.getCategory4Id())) {
                            throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[skuInfoList.Category4Id]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        boNew.setCategory4Id(bo.getCategory4Id());
                        skuInfoListNew.add(boNew);
                    }
                    if (!abilityReqBO.getCouponLevel().equals(ActCommConstant.CouponLevel.LEVEL_SHOP)) continue;
                    if (StringUtils.isBlank((CharSequence)bo.getShopId())) {
                        throw new BusinessException("0001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[skuInfoList.ShopId]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    boNew.setShopId(bo.getShopId());
                    skuInfoListNew.add(boNew);
                }
            }
            abilityReqBO.setSkuInfoList(skuInfoListNew);
        }
    }
}

