/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActLadderCountFullGiveAtomService;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.newretail.common.bo.ActDiscountSkuListBO;
import com.tydic.newretail.common.bo.ActTemplateAttrBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import java.math.BigDecimal;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actLadderCountFullGiveAtomService")
public class ActLadderCountFullGiveAtomServiceImpl
implements ActLadderCountFullGiveAtomService {
    @Override
    public ActCalculationUniversalAtomRspBO calculateLadderCountFullGive(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        BigDecimal totalCount = new BigDecimal(0);
        BigDecimal totalSalePrice = new BigDecimal(0);
        BigDecimal oldDiscountMoney = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalCount = totalCount.add(bo.getActCount());
            totalSalePrice = totalSalePrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            oldDiscountMoney = oldDiscountMoney.add(bo.getDiscountPrice());
        }
        BigDecimal calculateMoney = totalSalePrice.subtract(oldDiscountMoney);
        if (calculateMoney.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal countReachStar = new BigDecimal(0);
        BigDecimal countReachEnd = new BigDecimal(0);
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("count_reach_star".equals(bo.getAttrCode())) {
                countReachStar = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"count_reach_end".equals(bo.getAttrCode())) continue;
            countReachEnd = new BigDecimal(bo.getParaValue());
        }
        if (totalCount.compareTo(countReachStar) >= 0) {
            actDiscountSkuListBO.setActiveTemplateGroupId(atomReqBO.getActTemplateBO().getActiveTemplateGroupId());
        }
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

