/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.active.external.api.umc.bo.ActUmcMemDetailInfoAbilityBO;
import com.tydic.active.external.api.umc.bo.ActUmcMemDetailQueryAbilityReqBO;
import com.tydic.active.external.api.umc.bo.ActUmcMemDetailQueryAbilityRspBO;
import com.tydic.active.external.api.umc.bo.ActUmcReceiveCouponAbilityReqBO;
import com.tydic.active.external.api.umc.bo.ActUmcReceiveCouponAbilityRspBO;
import com.tydic.newretail.busi.ActCouponReceiveBusiService;
import com.tydic.newretail.busi.bo.ActCouponReceiveBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponReceiveBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActActiveMemJoinNumMapper;
import com.tydic.newretail.dao.ActiveMemRangeMapper;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.CouponNumMapper;
import com.tydic.newretail.dao.po.ActActiveMemJoinNumPO;
import com.tydic.newretail.dao.po.ActiveMemRangePO;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.CouponInstPO;
import com.tydic.newretail.dao.po.CouponNumPO;
import com.tydic.newretail.facde.ActUmcServiceHolder;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponReceiveBusiService")
public class ActCouponReceiveBusiServiceImpl
implements ActCouponReceiveBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCouponReceiveBusiServiceImpl.class);
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Autowired
    private ActActiveMemJoinNumMapper actActiveMemJoinNumMapper;
    @Autowired
    private CouponNumMapper couponNumMapper;
    @Autowired
    private ActiveMemRangeMapper activeMemRangeMapper;
    @Autowired
    private CouponInstMapper couponInstMapper;
    @Autowired
    private ActUmcServiceHolder actUmcServiceHolder;
    @Resource(name="couponNoSequencePager")
    private OrderSequence couponNoSequencePager;

    public ActCouponReceiveBusiRspBO couponReceive(ActCouponReceiveBusiReqBO busiReqBO) {
        ActCouponReceiveBusiRspBO busiRspBO = new ActCouponReceiveBusiRspBO();
        CouponFormPO couponFormPO = this.checkcouponForm(busiReqBO);
        this.checkCouponUserRange(busiReqBO);
        CouponNumPO couponNumPO = this.checkUserReceiveNum(busiReqBO);
        CouponInstPO couponInstPO = this.insertCouponInst(couponFormPO, busiReqBO.getMemId().toString());
        CouponNumPO couponNumPO1 = new CouponNumPO();
        couponNumPO1.setFmId(busiReqBO.getFmId());
        couponNumPO1.setTotalNum(couponNumPO.getTotalNum());
        int count = this.couponNumMapper.updateCouponSendNum(couponNumPO1);
        if (couponNumPO.getTotalNum() != null && couponNumPO.getTotalNum() != 0L && count < 1) {
            throw new BusinessException("8888", "\u4f18\u60e0\u5238\u5df2\u62a2\u5b8c");
        }
        ActActiveMemJoinNumPO actActiveMemJoinNumPO = new ActActiveMemJoinNumPO();
        actActiveMemJoinNumPO.setMemId(busiReqBO.getMemId().toString());
        actActiveMemJoinNumPO.setActiveId(busiReqBO.getFmId());
        actActiveMemJoinNumPO.setMarketingType("11");
        actActiveMemJoinNumPO.setMemLimitNum(couponNumPO.getMemLimitNum());
        int count1 = this.actActiveMemJoinNumMapper.updateJoinNum(actActiveMemJoinNumPO);
        if (couponNumPO.getMemLimitNum() != null && couponNumPO.getMemLimitNum() != 0 && count1 < 1) {
            throw new BusinessException("8888", "\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u8fbe\u4e0a\u9650");
        }
        this.callMemCouponReceiveService(couponFormPO, couponInstPO, busiReqBO);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
        return busiRspBO;
    }

    private void callMemCouponReceiveService(CouponFormPO couponFormPO, CouponInstPO couponInstPO, ActCouponReceiveBusiReqBO busiReqBO) {
        ActUmcReceiveCouponAbilityRspBO rspBO;
        ActUmcReceiveCouponAbilityReqBO umcReqBO = new ActUmcReceiveCouponAbilityReqBO();
        umcReqBO.setMemId(busiReqBO.getMemId());
        umcReqBO.setCouponNo(couponInstPO.getCouponNo());
        umcReqBO.setCouponDesc(couponFormPO.getFmDesc());
        umcReqBO.setCouponType(couponInstPO.getCouponType());
        umcReqBO.setExpTime(DateUtils.dateToStrLong((Date)couponInstPO.getExpTime()));
        umcReqBO.setFmId(couponInstPO.getFmId());
        umcReqBO.setCouponValue(couponFormPO.getDiscountValue());
        umcReqBO.setCouponJson(JSON.toJSONString((Object)couponInstPO));
        umcReqBO.setCouponPicUrl(couponFormPO.getImageUrl());
        umcReqBO.setEffTime(DateUtils.dateToStrLong((Date)couponFormPO.getEffTime()));
        umcReqBO.setCouponName(couponFormPO.getFmName());
        if (ActCommConstant.CouponLevel.LEVEL_PLATFORM.equals(couponFormPO.getCouponLevel())) {
            umcReqBO.setCouponKind(Integer.valueOf(4));
        }
        if (ActCommConstant.CouponLevel.SKU_COMMODITY.equals(couponFormPO.getCouponLevel())) {
            umcReqBO.setCouponKind(Integer.valueOf(1));
        }
        if (ActCommConstant.CouponLevel.LEVEL_SHOP.equals(couponFormPO.getCouponLevel())) {
            umcReqBO.setCouponKind(Integer.valueOf(2));
        }
        if (ActCommConstant.CouponLevel.SKU_L1CATEGORY.equals(couponFormPO.getCouponLevel()) || ActCommConstant.CouponLevel.SKU_L2CATEGORY.equals(couponFormPO.getCouponLevel()) || ActCommConstant.CouponLevel.SKU_L3CATEGORY.equals(couponFormPO.getCouponLevel()) || ActCommConstant.CouponLevel.SKU_L4CATEGORY.equals(couponFormPO.getCouponLevel())) {
            umcReqBO.setCouponKind(Integer.valueOf(3));
        }
        if (!"0000".equals((rspBO = this.actUmcServiceHolder.getActExternalUmcConponService().invokeReceiveCoupon(umcReqBO)).getRespCode())) {
            throw new BusinessException("1022", "\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u8c03\u7528\u5916\u90e8\u670d\u52a1\u5931\u8d25");
        }
    }

    private CouponInstPO insertCouponInst(CouponFormPO couponFormPO, String MemId) {
        CouponInstPO couponInstPO = new CouponInstPO();
        BeanUtils.copyProperties((Object)couponFormPO, (Object)couponInstPO);
        try {
            couponInstPO.setCouponNo(couponFormPO.getCouponType() + new SimpleDateFormat("yyyyMMdd").format(couponFormPO.getEffTime()) + new DecimalFormat("000000000000").format(this.couponNoSequencePager.nextId()));
        }
        catch (SQLException e) {
            LOGGER.error("\u83b7\u53d6\u4f18\u60e0\u5238\u7f16\u7801\u5e8f\u5217\u53f7\u5f02\u5e38" + e);
            throw new BusinessException("6031", "\u751f\u6210\u4f18\u60e0\u5238\u7f16\u7801\u5931\u8d25");
        }
        couponInstPO.setMemId(MemId);
        couponInstPO.setCreateTime(new Date());
        couponInstPO.setReceiveTime(new Date());
        if (couponFormPO.getDiscountValue() != null) {
            couponInstPO.setCouponValue(Integer.parseInt(couponFormPO.getDiscountValue()));
        }
        couponInstPO.setState(ActCommConstant.CouponState.TO_BE_USED);
        int count = this.couponInstMapper.insert(couponInstPO);
        if (count != 1) {
            throw new BusinessException("6031", "[" + couponInstPO.getCouponNo() + "]\u8be5\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u5931\u8d25");
        }
        return couponInstPO;
    }

    private CouponFormPO checkcouponForm(ActCouponReceiveBusiReqBO busiReqBO) {
        CouponFormPO couponFormPO = this.couponFormMapper.selectByPrimaryKey(busiReqBO.getFmId());
        if (couponFormPO == null) {
            throw new BusinessException("8888", "\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        }
        if (new Date().compareTo(couponFormPO.getEffTime()) < 0) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u672a\u5f00\u59cb");
        }
        if (new Date().compareTo(couponFormPO.getExpTime()) > 0) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        if (couponFormPO.getState() != ActCommConstant.CouponFormState.AUDIT_PASS) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        return couponFormPO;
    }

    private CouponNumPO checkUserReceiveNum(ActCouponReceiveBusiReqBO busiReqBO) {
        CouponNumPO couponNumPO = this.couponNumMapper.selectByPrimaryKey(busiReqBO.getFmId());
        if (couponNumPO != null) {
            if (couponNumPO.getTotalNum() != null && couponNumPO.getTotalNum() != 0L && couponNumPO.getSendNum() != null && couponNumPO.getSendNum() >= couponNumPO.getTotalNum()) {
                throw new BusinessException("8888", "\u4f18\u60e0\u5238\u5df2\u62a2\u5b8c");
            }
            if (couponNumPO.getMemLimitNum() != null && couponNumPO.getMemLimitNum() != 0) {
                ActActiveMemJoinNumPO actActiveMemJoinNumPO = new ActActiveMemJoinNumPO();
                actActiveMemJoinNumPO.setActiveId(busiReqBO.getFmId());
                actActiveMemJoinNumPO.setMarketingType("11");
                ActActiveMemJoinNumPO joinNumPO = this.actActiveMemJoinNumMapper.selectByRecord(actActiveMemJoinNumPO);
                if (joinNumPO == null) {
                    actActiveMemJoinNumPO.setMemId(busiReqBO.getMemId().toString());
                    actActiveMemJoinNumPO.setJoinNum(0);
                    try {
                        this.actActiveMemJoinNumMapper.insert(actActiveMemJoinNumPO);
                    }
                    catch (Exception e) {
                        if (e instanceof DuplicateKeyException) {
                            LOGGER.debug("\u522b\u7684\u7ebf\u7a0b\u5df2\u65b0\u589e\u6570\u636e");
                        }
                    }
                } else if (joinNumPO.getJoinNum() >= couponNumPO.getMemLimitNum()) {
                    throw new BusinessException("8888", "\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u8fbe\u4e0a\u9650");
                }
            }
        }
        return couponNumPO;
    }

    private void checkCouponUserRange(ActCouponReceiveBusiReqBO busiReqBO) {
        String memLevel1;
        ActUmcMemDetailQueryAbilityReqBO actUmcMemDetailQueryAbilityReqBO = new ActUmcMemDetailQueryAbilityReqBO();
        actUmcMemDetailQueryAbilityReqBO.setMemId(busiReqBO.getMemId());
        ActUmcMemDetailQueryAbilityRspBO rsp = this.actUmcServiceHolder.getActExternalUmcMemBaseInfoService().invokeMemDetailQuery(actUmcMemDetailQueryAbilityReqBO);
        if (null == rsp || !"0000".equals(rsp.getRespCode())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u9519");
        }
        ActUmcMemDetailInfoAbilityBO mem = rsp.getActUmcMemDetailInfoAbilityBO();
        if (null == mem) {
            throw new BusinessException("8888", "\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        ActiveMemRangePO activeMemRangePO = new ActiveMemRangePO();
        activeMemRangePO.setActiveId(busiReqBO.getFmId());
        activeMemRangePO.setMarketingType("11");
        List<ActiveMemRangePO> daoList = this.activeMemRangeMapper.getList(activeMemRangePO);
        ArrayList<String> memMark = new ArrayList<String>();
        ArrayList<String> memGroup = new ArrayList<String>();
        ArrayList<String> memLevel = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(daoList)) {
            for (ActiveMemRangePO po : daoList) {
                if (po.getMemParamType().equals("12")) {
                    memGroup.add(po.getParamInsCode());
                }
                if (po.getMemParamType().equals("10")) {
                    memLevel.add(po.getParamInsCode());
                }
                if (!po.getMemParamType().equals("11")) continue;
                memMark.add(po.getParamInsCode());
            }
        }
        if (!CollectionUtils.isEmpty(memMark)) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(memGroup)) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(memLevel) && !memLevel.contains(memLevel1 = mem.getMemLevel().toString())) {
            throw new BusinessException("8888", "\u5f53\u524d\u4f1a\u5458\u65e0\u6743\u9886\u53d6\u5f53\u524d\u4f18\u60e0\u5238");
        }
    }
}

