/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActLadderMoneyFullReductionDiscountRateAtomService;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.newretail.common.bo.ActDiscountSkuListBO;
import com.tydic.newretail.common.bo.ActTemplateAttrBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actLadderMoneyFullReductionDiscountRateAtomService")
public class ActLadderMoneyFullReductionDiscountRateAtomServiceImpl
implements ActLadderMoneyFullReductionDiscountRateAtomService {
    @Override
    public ActCalculationUniversalAtomRspBO calculateLadderMoneyFullReductionDiscountRate(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        BigDecimal totalSalePrice = new BigDecimal(0);
        BigDecimal oldDiscountMoney = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalSalePrice = totalSalePrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            oldDiscountMoney = oldDiscountMoney.add(bo.getDiscountPrice());
        }
        BigDecimal calculateMoney = totalSalePrice.subtract(oldDiscountMoney);
        BigDecimal discountMoney = new BigDecimal(0);
        if (calculateMoney.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal feeReachStar = new BigDecimal(0);
        BigDecimal feeReachEnd = new BigDecimal(0);
        BigDecimal feeReachDiscountRate = new BigDecimal(0);
        Integer isLoopAdd2 = ActCommConstant.isLoopAdd.NO;
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("fee_reach_star".equals(bo.getAttrCode())) {
                feeReachStar = new BigDecimal(bo.getParaValue());
                continue;
            }
            if ("fee_reach_end".equals(bo.getAttrCode())) {
                feeReachEnd = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"fee_reach_discountRate".equals(bo.getAttrCode())) continue;
            feeReachDiscountRate = new BigDecimal(bo.getParaValue());
        }
        if (calculateMoney.compareTo(feeReachStar) >= 0) {
            BigDecimal money;
            if (calculateMoney.compareTo(feeReachEnd) < 0) {
                money = calculateMoney.subtract(feeReachStar);
                discountMoney = money.subtract(money.multiply(feeReachDiscountRate));
            } else {
                money = feeReachEnd.subtract(feeReachStar);
                discountMoney = money.subtract(money.multiply(feeReachDiscountRate));
            }
        }
        actDiscountSkuListBO.setDiscountMoney(discountMoney);
        BigDecimal averageDiscountPrice = discountMoney.divide(new BigDecimal(atomReqBO.getSkuInfoList().size()), 2, RoundingMode.HALF_UP);
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        int fullFeeCount = 0;
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            if (bo.getTotalPrice().compareTo(averageDiscountPrice) > 0) {
                skuDiscountMap.put(bo.getSkuId(), averageDiscountPrice);
                continue;
            }
            skuDiscountMap.put(bo.getSkuId(), bo.getTotalPrice());
            averageDiscountPrice = discountMoney.subtract(bo.getTotalPrice()).divide(new BigDecimal(atomReqBO.getSkuInfoList().size() - ++fullFeeCount), 2, RoundingMode.HALF_UP);
        }
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

