/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActCouponRecommendAbilityService;
import com.tydic.newretail.ability.bo.ActCouponRecommendAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCouponRecommendAbilityRspBO;
import com.tydic.newretail.comb.ActCouponRecommendCombService;
import com.tydic.newretail.comb.bo.ActCouponRecommendCombReqBO;
import com.tydic.newretail.comb.bo.ActCouponRecommendCombRspBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponRecommendAbilityService")
public class ActCouponRecommendAbilityServiceImpl
implements ActCouponRecommendAbilityService {
    @Autowired
    private ActCouponRecommendCombService actCouponRecommendCombService;

    public ActCouponRecommendAbilityRspBO recommendCoupon(ActCouponRecommendAbilityReqBO reqBO) {
        ActCouponRecommendAbilityRspBO rsp = new ActCouponRecommendAbilityRspBO();
        this.validateParam(reqBO);
        ActCouponRecommendCombReqBO actCouponRecommendCombReqBO = new ActCouponRecommendCombReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)actCouponRecommendCombReqBO);
        ActCouponRecommendCombRspBO actCouponRecommendCombRspBO = this.actCouponRecommendCombService.orderCouponRecommend(actCouponRecommendCombReqBO);
        BeanUtils.copyProperties((Object)actCouponRecommendCombRspBO, (Object)rsp);
        return rsp;
    }

    private void validateParam(ActCouponRecommendAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("14000", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuInfoList())) {
            throw new BusinessException("0001", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u3010skuInfoList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (SkuCalculationActiveBO bo : reqBO.getSkuInfoList()) {
            if (StringUtils.isBlank((CharSequence)bo.getSkuId())) {
                throw new BusinessException("0001", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)bo.getShopId())) {
                throw new BusinessException("0001", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.shopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)bo.getCommodityId())) {
                throw new BusinessException("0001", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.commodityId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getActCount()) {
                throw new BusinessException("0001", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.actCount\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != bo.getSalePrice()) continue;
            throw new BusinessException("0001", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u3010skuInfoList.salePrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCouponNolist())) {
            throw new BusinessException("0001", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u3010couponNolist\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (SkuCalculationActiveBO bo : reqBO.getCouponNolist()) {
            if (null == bo.getFmId()) {
                throw new BusinessException("0001", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u3010couponNolist.fmId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isBlank((CharSequence)bo.getCouponNo())) continue;
            throw new BusinessException("0001", "\u6d3b\u52a8\u4e2d\u5fc3\u4f18\u60e0\u5238\u63a8\u8350\u670d\u52a1API\u5165\u53c2\u3010couponNolist.couponNo\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

