/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActActivityRangeCheckAtomService;
import com.tydic.newretail.atom.ActActivityValidCheckAtomService;
import com.tydic.newretail.atom.ActGiftQueryAtomService;
import com.tydic.newretail.atom.ActSkuActivityCountAtomService;
import com.tydic.newretail.atom.ActSkuDiscountAtomService;
import com.tydic.newretail.atom.ActSkuJudgeAtomService;
import com.tydic.newretail.atom.ActSkuSeckPriceQueryAtomService;
import com.tydic.newretail.atom.bo.ActActivityRangeCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActActivityRangeCheckAtomRspBO;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomRspBO;
import com.tydic.newretail.atom.bo.ActCalcPriceAtomBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountReqBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountRspBO;
import com.tydic.newretail.atom.bo.ActSkuDiscountReqBO;
import com.tydic.newretail.atom.bo.ActSkuDiscountRspBO;
import com.tydic.newretail.atom.bo.ActSkuJudgeAtomReqBO;
import com.tydic.newretail.atom.bo.ActSkuJudgeAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuSeckPriceQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActSkuSeckPriceQueryAtomRspBO;
import com.tydic.newretail.atom.bo.SkuDetailReqAtomBO;
import com.tydic.newretail.atom.bo.SkuDetailRspAtomBO;
import com.tydic.newretail.common.bo.ActiveGiftBO;
import com.tydic.newretail.common.bo.ActiveGiftPkgBO;
import com.tydic.newretail.common.bo.ActivityChoiceBO;
import com.tydic.newretail.common.bo.SeckPriceQryReqBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveTemplateMapper;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.po.ActiveTemplatePO;
import com.tydic.newretail.dao.po.ActivityPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actSkuActivityCountAtomService")
public class ActSkuActivityCountAtomServiceImpl
implements ActSkuActivityCountAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSkuActivityCountAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private ActActivityValidCheckAtomService actActivityValidCheckAtomService;
    private ActActivityRangeCheckAtomService actActivityRangeCheckAtomService;
    private ActSkuJudgeAtomService actSkuJudgeAtomService;
    private ActSkuDiscountAtomService actSkuDiscountAtomService;
    private ActGiftQueryAtomService actGiftQueryAtomService;
    private ActiveTemplateMapper activeTemplateMapper;
    private ActSkuSeckPriceQueryAtomService actSkuSeckPriceQueryAtomService;
    private ActivityMapper activityMapper;

    @Autowired
    public ActSkuActivityCountAtomServiceImpl(ActActivityValidCheckAtomService actActivityValidCheckAtomService, ActActivityRangeCheckAtomService actActivityRangeCheckAtomService, ActSkuJudgeAtomService actSkuJudgeAtomService, ActSkuDiscountAtomService actSkuDiscountAtomService, ActGiftQueryAtomService actGiftQueryAtomService, ActiveTemplateMapper activeTemplateMapper, ActSkuSeckPriceQueryAtomService actSkuSeckPriceQueryAtomService, ActivityMapper activityMapper) {
        this.actActivityValidCheckAtomService = actActivityValidCheckAtomService;
        this.actActivityRangeCheckAtomService = actActivityRangeCheckAtomService;
        this.actSkuJudgeAtomService = actSkuJudgeAtomService;
        this.actSkuDiscountAtomService = actSkuDiscountAtomService;
        this.actGiftQueryAtomService = actGiftQueryAtomService;
        this.activeTemplateMapper = activeTemplateMapper;
        this.actSkuSeckPriceQueryAtomService = actSkuSeckPriceQueryAtomService;
        this.activityMapper = activityMapper;
    }

    @Override
    public ActSkuActivityCountRspBO skuActivityCount(ActSkuActivityCountReqBO actSkuActivityCountReqBO) {
        SkuDetailReqAtomBO skuDetailReqAtomBO = actSkuActivityCountReqBO.getActSkuActivityDetailReqBO();
        List<ActivityChoiceBO> activityChoiceList = skuDetailReqAtomBO.getActivityChoiceList();
        if (CollectionUtils.isEmpty(activityChoiceList) && "0".equals(skuDetailReqAtomBO.getSeckillFlag())) {
            return this.returnOriginalInfo(skuDetailReqAtomBO);
        }
        if ("1".equals(skuDetailReqAtomBO.getSeckillFlag())) {
            return this.judgeSeckillActive(skuDetailReqAtomBO);
        }
        Collections.sort(activityChoiceList);
        ActSkuActivityCountRspBO rspBO = new ActSkuActivityCountRspBO();
        ActCalcPriceAtomBO actCalcPriceAtomBO = this.obtainDisPriceAndGifts(activityChoiceList, skuDetailReqAtomBO);
        if (!"0000".equals(actCalcPriceAtomBO.getRespCode())) {
            rspBO.setRespCode(actCalcPriceAtomBO.getRespCode());
            rspBO.setRespDesc(actCalcPriceAtomBO.getRespDesc());
            rspBO.setSkuDetailRspAtomBO(null);
            return rspBO;
        }
        BigDecimal disCountAmont = actCalcPriceAtomBO.getDisCountAmont();
        BigDecimal disPrice = actCalcPriceAtomBO.getDisSkuPrice();
        SkuDetailRspAtomBO skuDetailRspAtomBO = new SkuDetailRspAtomBO();
        skuDetailRspAtomBO.setSeckillFlag("0");
        skuDetailRspAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailRspAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailRspAtomBO.setSkuPrice(skuDetailReqAtomBO.getSkuPrice());
        skuDetailRspAtomBO.setSkuDisAmount(disCountAmont.setScale(2, 5));
        if (disPrice.compareTo(BigDecimal.ZERO) < 0) {
            skuDetailRspAtomBO.setSkuDisPrice(BigDecimal.ZERO);
        } else {
            skuDetailRspAtomBO.setSkuDisPrice(disPrice.setScale(2, 5));
        }
        skuDetailRspAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailRspAtomBO.setGiftList(actCalcPriceAtomBO.getGiftList());
        skuDetailRspAtomBO.setGiftPkgList(actCalcPriceAtomBO.getGiftPkgList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u54c1\u4ef7\u683c\u8ba1\u7b97\u6210\u529f");
        rspBO.setSkuDetailRspAtomBO(skuDetailRspAtomBO);
        return rspBO;
    }

    private ActSkuActivityCountRspBO returnOriginalInfo(SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActSkuActivityCountRspBO rspBO = new ActSkuActivityCountRspBO();
        SkuDetailRspAtomBO skuDetailRspAtomBO = new SkuDetailRspAtomBO();
        skuDetailRspAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailRspAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailRspAtomBO.setSkuPrice(skuDetailReqAtomBO.getSkuPrice());
        skuDetailRspAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailRspAtomBO.setSkuDisAmount(BigDecimal.ZERO);
        skuDetailRspAtomBO.setSkuDisPrice(skuDetailReqAtomBO.getSkuPrice());
        skuDetailRspAtomBO.setSeckillFlag("0");
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u4ef7\u683c\u8ba1\u7b97\u5b8c\u6210");
        rspBO.setSkuDetailRspAtomBO(skuDetailRspAtomBO);
        return rspBO;
    }

    private ActSkuActivityCountRspBO judgeSeckillActive(SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActSkuActivityCountRspBO seckillSkuRspBO = new ActSkuActivityCountRspBO();
        ActSkuSeckPriceQueryAtomRspBO actSkuSeckPriceQueryAtomRspBO = this.qrySkuSeckPrice(skuDetailReqAtomBO.getSkuId(), skuDetailReqAtomBO.getShopId());
        if ("0000".equals(actSkuSeckPriceQueryAtomRspBO.getRespCode())) {
            if (CollectionUtils.isEmpty(actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList())) {
                seckillSkuRspBO.setRespCode("1007");
                seckillSkuRspBO.setRespDesc(actSkuSeckPriceQueryAtomRspBO.getRespDesc());
                return seckillSkuRspBO;
            }
            if ("0".equals(actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList().get(0).getSeckillFlag())) {
                seckillSkuRspBO.setRespCode("1007");
                seckillSkuRspBO.setRespDesc("\u5f53\u524d\u4f20\u9012\u5355\u54c1\u4e0d\u662f\u79d2\u6740\u5355\u54c1");
                return seckillSkuRspBO;
            }
            if (skuDetailReqAtomBO.getSkuPrice().compareTo(actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList().get(0).getKillPrice()) != 0) {
                seckillSkuRspBO.setRespCode("1007");
                seckillSkuRspBO.setRespDesc("\u5f53\u524d\u4f20\u9012\u5355\u54c1\u79d2\u6740\u4ef7\u683c\u6821\u9a8c\u4e0d\u901a\u8fc7!");
                return seckillSkuRspBO;
            }
            if ("1".equals(actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList().get(0).getSeckillFlag()) && ActCommConstant.SoldOutFlag.NO.equals(actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList().get(0).getSoldOutFlag())) {
                seckillSkuRspBO = this.returnSeckillSkuInfo(skuDetailReqAtomBO, "1", skuDetailReqAtomBO.getSkuPrice(), actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList().get(0).getKillPrice());
            }
            if ("0".equals(actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList().get(0).getSeckillFlag()) && ActCommConstant.SoldOutFlag.NO.equals(actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList().get(0).getSoldOutFlag())) {
                seckillSkuRspBO = this.returnSeckillSkuInfo(skuDetailReqAtomBO, "0", actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList().get(0).getSkuPrice(), actSkuSeckPriceQueryAtomRspBO.getSeckPriceQryResultList().get(0).getSkuPrice());
            }
        } else {
            seckillSkuRspBO.setRespCode("1007");
            seckillSkuRspBO.setRespDesc("\u67e5\u8be2\u79d2\u6740\u4ef7\u683c\u5931\u8d25" + actSkuSeckPriceQueryAtomRspBO.getRespDesc());
            return seckillSkuRspBO;
        }
        return seckillSkuRspBO;
    }

    private ActSkuSeckPriceQueryAtomRspBO qrySkuSeckPrice(String skuId, String shopId) {
        ActSkuSeckPriceQueryAtomReqBO reqBO = new ActSkuSeckPriceQueryAtomReqBO();
        ArrayList<SeckPriceQryReqBO> seckPriceQryReqBOList = new ArrayList<SeckPriceQryReqBO>();
        SeckPriceQryReqBO seckPriceQryReqBO = new SeckPriceQryReqBO();
        seckPriceQryReqBO.setSkuId(skuId);
        seckPriceQryReqBO.setShopId(shopId);
        seckPriceQryReqBOList.add(seckPriceQryReqBO);
        reqBO.setSeckPriceQryInfoList(seckPriceQryReqBOList);
        return this.actSkuSeckPriceQueryAtomService.querySkuSeckPrice(reqBO);
    }

    private ActSkuActivityCountRspBO returnSeckillSkuInfo(SkuDetailReqAtomBO skuDetailReqAtomBO, String seckillFlag, BigDecimal skuPrice, BigDecimal killPrice) {
        ActSkuActivityCountRspBO seckillSku = new ActSkuActivityCountRspBO();
        SkuDetailRspAtomBO skuDetailRspAtomBO = new SkuDetailRspAtomBO();
        skuDetailRspAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailRspAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailRspAtomBO.setSkuPrice(skuPrice);
        skuDetailRspAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailRspAtomBO.setSkuDisAmount(BigDecimal.ZERO);
        skuDetailRspAtomBO.setSkuDisPrice(killPrice);
        skuDetailRspAtomBO.setSeckillFlag(seckillFlag);
        seckillSku.setSkuDetailRspAtomBO(skuDetailRspAtomBO);
        seckillSku.setRespCode("0000");
        seckillSku.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u4ef7\u683c\u8ba1\u7b97\u5b8c\u6210");
        return seckillSku;
    }

    private ActCalcPriceAtomBO obtainDisPriceAndGifts(List<ActivityChoiceBO> activityChoiceList, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActCalcPriceAtomBO actCalcPriceAtomBO = new ActCalcPriceAtomBO();
        BigDecimal disCountAmont = BigDecimal.ZERO;
        BigDecimal disSkuPrice = skuDetailReqAtomBO.getSkuPrice();
        ArrayList<ActiveGiftBO> giftList = new ArrayList<ActiveGiftBO>();
        ArrayList<ActiveGiftPkgBO> giftPkgList = new ArrayList<ActiveGiftPkgBO>();
        for (ActivityChoiceBO activityChoiceAtomBO : activityChoiceList) {
            boolean isCheckSuccess = this.checkActivityValid(activityChoiceAtomBO, skuDetailReqAtomBO);
            if (!isCheckSuccess) {
                actCalcPriceAtomBO.setRespCode("1003");
                actCalcPriceAtomBO.setRespDesc("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u4e2d\u6240\u5305\u542b\u7684\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u65e0\u6548\u6216\u4e0d\u53ef\u7528");
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u4e2d\u6240\u5305\u542b\u7684\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u65e0\u6548\u6216\u4e0d\u53ef\u7528");
                }
                return actCalcPriceAtomBO;
            }
            List<ActiveTemplatePO> activeTemplatePOS = this.checkTemplateValid(activityChoiceAtomBO);
            if (activeTemplatePOS == null) {
                actCalcPriceAtomBO.setRespCode("1004");
                actCalcPriceAtomBO.setRespDesc("\u67e5\u8be2\u6d3b\u52a8\u7c7b\u578b\u5931\u8d25\u6216\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u672a\u6210\u529f\u914d\u7f6e\u6d3b\u52a8\u6a21\u677f\u4fe1\u606f");
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u67e5\u8be2\u6d3b\u52a8\u7c7b\u578b\u5931\u8d25\u6216\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u672a\u6210\u529f\u914d\u7f6e\u6d3b\u52a8\u6a21\u677f\u4fe1\u606f");
                }
                return actCalcPriceAtomBO;
            }
            actCalcPriceAtomBO = this.calculatePriceByTemp(activeTemplatePOS, activityChoiceAtomBO, skuDetailReqAtomBO, disCountAmont, disSkuPrice);
            if (!"0000".equals(actCalcPriceAtomBO.getRespCode())) {
                return actCalcPriceAtomBO;
            }
            disCountAmont = actCalcPriceAtomBO.getDisCountAmont();
            disSkuPrice = actCalcPriceAtomBO.getDisSkuPrice();
            giftList.addAll(actCalcPriceAtomBO.getGiftList());
            giftPkgList.addAll(actCalcPriceAtomBO.getGiftPkgList());
        }
        actCalcPriceAtomBO.setDisCountAmont(disCountAmont);
        actCalcPriceAtomBO.setDisSkuPrice(disSkuPrice);
        actCalcPriceAtomBO.setGiftList(giftList);
        actCalcPriceAtomBO.setGiftPkgList(giftPkgList);
        actCalcPriceAtomBO.setRespCode("0000");
        actCalcPriceAtomBO.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return actCalcPriceAtomBO;
    }

    private boolean checkActivityValid(ActivityChoiceBO activityChoiceBO, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActActivityValidCheckAtomReqBO validCheckAtomReqBO = new ActActivityValidCheckAtomReqBO();
        validCheckAtomReqBO.setActiveId(activityChoiceBO.getActiveId());
        validCheckAtomReqBO.setShopId(skuDetailReqAtomBO.getShopId());
        validCheckAtomReqBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        ActActivityValidCheckAtomRspBO validCheckAtomRspBO = this.actActivityValidCheckAtomService.checkActivityValid(validCheckAtomReqBO);
        if (!"0000".equals(validCheckAtomRspBO.getRespCode())) {
            return false;
        }
        ActActivityRangeCheckAtomReqBO rangeCheckAtomReqBO = new ActActivityRangeCheckAtomReqBO();
        rangeCheckAtomReqBO.setActiveId(activityChoiceBO.getActiveId());
        rangeCheckAtomReqBO.setSkuCheckList(Collections.singletonList(skuDetailReqAtomBO));
        ActActivityRangeCheckAtomRspBO rangeCheckAtomRspBO = this.actActivityRangeCheckAtomService.checkActivityRange(rangeCheckAtomReqBO);
        return CollectionUtils.isEmpty(rangeCheckAtomRspBO.getUnavailableSkuList());
    }

    private List<ActiveTemplatePO> checkTemplateValid(ActivityChoiceBO activityChoiceBO) {
        ActivityPO activityPO = new ActivityPO();
        activityPO.setActiveId(activityChoiceBO.getActiveId());
        ActivityPO activity = this.activityMapper.getModelBy(activityPO);
        if (null == activity) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u67e5\u8be2\u6d3b\u52a8[" + activityChoiceBO.getActiveId() + "]\u7684\u7c7b\u578b\u5931\u8d25");
            }
            return null;
        }
        if ("14".equals(activity.getActiveType())) {
            return new ArrayList<ActiveTemplatePO>();
        }
        int templateNum = 2;
        ActiveTemplatePO activeTemplateModel = new ActiveTemplatePO();
        activeTemplateModel.setActiveId(activityChoiceBO.getActiveId());
        List<ActiveTemplatePO> activeTemplatePOS = this.activeTemplateMapper.getList(activeTemplateModel);
        if (activeTemplatePOS == null || activeTemplatePOS.isEmpty()) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8[" + activityChoiceBO.getActiveId() + "]\u8fd8\u672a\u914d\u7f6e\u6a21\u677f\u4fe1\u606f");
            }
            return null;
        }
        if (activeTemplatePOS.size() > templateNum) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8[" + activityChoiceBO.getActiveId() + "]\u6240\u914d\u7f6e\u7684\u6a21\u677f\u7c7b\u578b\u5927\u4e8e2\u6761");
            }
            return null;
        }
        if (activeTemplatePOS.size() == templateNum && activeTemplatePOS.get(0).getTemplateType().equals(activeTemplatePOS.get(1).getTemplateType())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8[" + activityChoiceBO.getActiveId() + "]\u6240\u914d\u7f6e\u7684\u6a21\u677f\u7c7b\u578b\u91cd\u590d");
            }
            return null;
        }
        return activeTemplatePOS;
    }

    private ActCalcPriceAtomBO calculatePriceByTemp(List<ActiveTemplatePO> activeTemplatePOS, ActivityChoiceBO activityChoiceBO, SkuDetailReqAtomBO skuDetailReqAtomBO, BigDecimal disCountAmont, BigDecimal disSkuPrice) {
        ActCalcPriceAtomBO actCalcPriceAtomBO = new ActCalcPriceAtomBO();
        ArrayList<ActiveGiftBO> singleActiveGiftList = new ArrayList<ActiveGiftBO>();
        ArrayList<ActiveGiftPkgBO> singleActiveGiftPkgList = new ArrayList<ActiveGiftPkgBO>();
        boolean isMeetCondition = true;
        for (ActiveTemplatePO activeTemplatePO : activeTemplatePOS) {
            if ("0".equals(activeTemplatePO.getTemplateType())) {
                ActSkuJudgeAtomRspBO actSkuJudgeAtomRspBO = this.judgeCondition(activityChoiceBO, activeTemplatePO, skuDetailReqAtomBO);
                if (!"0000".equals(actSkuJudgeAtomRspBO.getRespCode()) && !"1014".equals(actSkuJudgeAtomRspBO.getRespCode())) {
                    actCalcPriceAtomBO.setRespCode(actSkuJudgeAtomRspBO.getRespCode());
                    actCalcPriceAtomBO.setRespDesc(actSkuJudgeAtomRspBO.getRespDesc());
                    return actCalcPriceAtomBO;
                }
                if ("1014".equals(actSkuJudgeAtomRspBO.getRespCode())) {
                    isMeetCondition = false;
                }
            }
            if (!isMeetCondition) break;
            if (!"1".equals(activeTemplatePO.getTemplateType())) continue;
            ActSkuDiscountRspBO actSkuDiscountRspBO = this.calculationPreferential(activityChoiceBO, activeTemplatePO, skuDetailReqAtomBO, disCountAmont, disSkuPrice);
            if (!"0000".equals(actSkuDiscountRspBO.getRespCode())) {
                actCalcPriceAtomBO.setRespCode(actSkuDiscountRspBO.getRespCode());
                actCalcPriceAtomBO.setRespDesc("\u5355\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u8ba1\u7b97\u4ef7\u683c\u5931\u8d25:" + actSkuDiscountRspBO.getRespDesc());
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u5355\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u8ba1\u7b97\u4ef7\u683c\u5931\u8d25:" + actSkuDiscountRspBO.getRespDesc());
                }
                return actCalcPriceAtomBO;
            }
            disCountAmont = actSkuDiscountRspBO.getSkuDetailActRspAtomBO().getSkuDisAmount();
            disSkuPrice = actSkuDiscountRspBO.getSkuDetailActRspAtomBO().getSkuDisPrice();
        }
        if (isMeetCondition) {
            ActGiftQueryAtomRspBO giftQueryRspBO = this.qryGifts(activityChoiceBO.getActiveId());
            singleActiveGiftList.addAll(giftQueryRspBO.getGiftList());
            singleActiveGiftPkgList.addAll(giftQueryRspBO.getGiftPkgList());
        }
        actCalcPriceAtomBO.setRespCode("0000");
        actCalcPriceAtomBO.setDisCountAmont(disCountAmont);
        actCalcPriceAtomBO.setDisSkuPrice(disSkuPrice);
        actCalcPriceAtomBO.setGiftList(singleActiveGiftList);
        actCalcPriceAtomBO.setGiftPkgList(singleActiveGiftPkgList);
        return actCalcPriceAtomBO;
    }

    private ActSkuJudgeAtomRspBO judgeCondition(ActivityChoiceBO activityChoiceBO, ActiveTemplatePO activeTemplatePO, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActSkuJudgeAtomReqBO actSkuJudgeAtomReqBO = new ActSkuJudgeAtomReqBO();
        actSkuJudgeAtomReqBO.setActId(activityChoiceBO.getActiveId());
        actSkuJudgeAtomReqBO.setTemplateId(activeTemplatePO.getTemplateId());
        SkuDetailBO skuDetailBO = new SkuDetailBO();
        skuDetailBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailBO.setSkuPrice(skuDetailReqAtomBO.getSkuPrice());
        actSkuJudgeAtomReqBO.setSkuDetailBO(skuDetailBO);
        return this.actSkuJudgeAtomService.judgeOrder(actSkuJudgeAtomReqBO);
    }

    private ActSkuDiscountRspBO calculationPreferential(ActivityChoiceBO activityChoiceBO, ActiveTemplatePO activeTemplatePO, SkuDetailReqAtomBO skuDetailReqAtomBO, BigDecimal disCountAmont, BigDecimal disPrice) {
        ActSkuDiscountReqBO actSkuDiscountReqBO = new ActSkuDiscountReqBO();
        actSkuDiscountReqBO.setActId(activityChoiceBO.getActiveId());
        actSkuDiscountReqBO.setTemplateId(activeTemplatePO.getTemplateId());
        actSkuDiscountReqBO.setDisCountAmont(disCountAmont);
        SkuDetailBO skuDetailBO = new SkuDetailBO();
        skuDetailBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailBO.setSkuPrice(disPrice);
        actSkuDiscountReqBO.setSkuDetailBO(skuDetailBO);
        return this.actSkuDiscountAtomService.skuDiscount(actSkuDiscountReqBO);
    }

    private ActGiftQueryAtomRspBO qryGifts(Long activeId) {
        ActGiftQueryAtomReqBO actGiftQueryAtomReqBO = new ActGiftQueryAtomReqBO();
        actGiftQueryAtomReqBO.setActiveId(activeId);
        return this.actGiftQueryAtomService.queryGift(actGiftQueryAtomReqBO);
    }
}

