/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActCountFullGiveAtomService;
import com.tydic.newretail.atom.ActCountFullReductionCountAtomService;
import com.tydic.newretail.atom.ActCountFullReductionDiscountRateAtomService;
import com.tydic.newretail.atom.ActLadderCountFullGiveAtomService;
import com.tydic.newretail.atom.ActLadderCountFullReductionAtomService;
import com.tydic.newretail.atom.ActLadderCountFullReductionDiscountRateAtomService;
import com.tydic.newretail.atom.ActLadderMoneyFullGiveAtomService;
import com.tydic.newretail.atom.ActLadderMoneyFullReductionAtomService;
import com.tydic.newretail.atom.ActLadderMoneyFullReductionDiscountRateAtomService;
import com.tydic.newretail.atom.ActMoneyFullGiveAtomService;
import com.tydic.newretail.atom.ActMoneyFullReductionDiscountRateAtomService;
import com.tydic.newretail.atom.ActMoneyFullReductionPriceAtomService;
import com.tydic.newretail.atom.ActQryActiveTemplateGroupAtomService;
import com.tydic.newretail.atom.ActQueryActiveDefListAtomService;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.newretail.atom.bo.ActQryActiveTemplateGroupAtomReqBO;
import com.tydic.newretail.atom.bo.ActQryActiveTemplateGroupAtomRspBO;
import com.tydic.newretail.atom.bo.ActQueryActiveDefListAtomReqBO;
import com.tydic.newretail.atom.bo.ActQueryActiveDefListAtomRspBO;
import com.tydic.newretail.busi.ActUniversalCalculationBusiService;
import com.tydic.newretail.busi.bo.ActUniversalCalculationBusiReqBO;
import com.tydic.newretail.busi.bo.ActUniversalCalculationBusiRspBO;
import com.tydic.newretail.common.bo.ActDiscountSkuListBO;
import com.tydic.newretail.common.bo.ActTemplateBO;
import com.tydic.newretail.common.bo.ActTemplateGroupBO;
import com.tydic.newretail.common.bo.ActivitiesBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actUniversalCalculationBusiService")
public class ActUniversalCalculationBusiServiceImpl
implements ActUniversalCalculationBusiService {
    @Autowired
    private ActQueryActiveDefListAtomService actQueryActiveDefListAtomService;
    @Autowired
    private ActQryActiveTemplateGroupAtomService actQryActiveTemplateGroupAtomService;
    @Autowired
    private ActCountFullReductionDiscountRateAtomService actCountFullReductionDiscountRateAtomService;
    @Autowired
    private ActMoneyFullGiveAtomService actMoneyFullGiveAtomService;
    @Autowired
    private ActCountFullGiveAtomService actCountFullGiveAtomService;
    @Autowired
    private ActLadderMoneyFullReductionAtomService actLadderMoneyFullReductionAtomService;
    @Autowired
    private ActLadderCountFullReductionAtomService actLadderCountFullReductionAtomService;
    @Autowired
    private ActLadderMoneyFullReductionDiscountRateAtomService actLadderMoneyFullReductionDiscountRateAtomService;
    @Autowired
    private ActLadderCountFullReductionDiscountRateAtomService actLadderCountFullReductionDiscountRateAtomService;
    @Autowired
    private ActLadderMoneyFullGiveAtomService actLadderMoneyFullGiveAtomService;
    @Autowired
    private ActLadderCountFullGiveAtomService actLadderCountFullGiveAtomService;
    @Autowired
    private ActMoneyFullReductionPriceAtomService actMoneyFullReductionPriceAtomService;
    @Autowired
    private ActCountFullReductionCountAtomService actCountFullReductionCountAtomService;
    @Autowired
    private ActMoneyFullReductionDiscountRateAtomService actMoneyFullReductionDiscountRateAtomService;
    @Autowired
    private SkuActiveMapper skuActiveMapper;

    public ActUniversalCalculationBusiRspBO calculatePrice(ActUniversalCalculationBusiReqBO busiReqBO) {
        ActUniversalCalculationBusiRspBO rsp = new ActUniversalCalculationBusiRspBO();
        BigDecimal totalDiscountPrice = new BigDecimal(0);
        ArrayList activeGiftList = new ArrayList();
        ArrayList activeGiftPkgList = new ArrayList();
        rsp.setTotalDiscountPrice(totalDiscountPrice);
        rsp.setActiveGiftList(activeGiftList);
        rsp.setActiveGiftPkgList(activeGiftPkgList);
        ActQueryActiveDefListAtomReqBO actQueryActiveDefListAtomReqBO = new ActQueryActiveDefListAtomReqBO();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        activityIds.add(busiReqBO.getActiveId());
        actQueryActiveDefListAtomReqBO.setActiveIds(activityIds);
        ActQueryActiveDefListAtomRspBO actQueryActiveDefListAtomRspBO = this.actQueryActiveDefListAtomService.queryActiveDefList(actQueryActiveDefListAtomReqBO);
        if (CollectionUtils.isEmpty((Collection)actQueryActiveDefListAtomRspBO.getRows())) {
            rsp.setRespCode("14013");
            rsp.setRespDesc("\u4e0d\u5b58\u5728\u8be5\u6d3b\u52a8\u5b9a\u4e49\uff01");
            return rsp;
        }
        ActQryActiveTemplateGroupAtomReqBO actQryActiveTemplateGroupAtomReqBO = new ActQryActiveTemplateGroupAtomReqBO();
        actQryActiveTemplateGroupAtomReqBO.setActiveId(busiReqBO.getActiveId());
        actQryActiveTemplateGroupAtomReqBO.setOperType("operTemplateGroup");
        ActQryActiveTemplateGroupAtomRspBO actQryActiveTemplateGroupAtomRspBO = this.actQryActiveTemplateGroupAtomService.qryActiveTemplateGroup(actQryActiveTemplateGroupAtomReqBO);
        if (CollectionUtils.isEmpty(actQryActiveTemplateGroupAtomRspBO.getActTemplateGroupBOS())) {
            rsp.setRespCode("14030");
            rsp.setRespDesc("\u8be5\u6d3b\u52a8\u672a\u914d\u7f6e\u6a21\u7248\u7ec4\uff01");
            return rsp;
        }
        this.gradientCalculatePrice(rsp, actQryActiveTemplateGroupAtomRspBO.getActTemplateGroupBOS(), ((ActivitiesBO)actQueryActiveDefListAtomRspBO.getRows().get(0)).getDiscountMode(), ((ActivitiesBO)actQueryActiveDefListAtomRspBO.getRows().get(0)).getActiveTarget(), busiReqBO.getSkuInfoList(), busiReqBO.getActiveId());
        rsp.setRows(busiReqBO.getSkuInfoList());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6d3b\u52a8\u4e2d\u5fc3\u901a\u7528\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private void gradientCalculatePrice(ActUniversalCalculationBusiRspBO rsp, List<ActTemplateGroupBO> actTemplateGroupBOS, Integer discountMode, Integer activeTarget, List<SkuCalculationActiveBO> skuInfoList, Long activeId) {
        switch (activeTarget) {
            case 10: {
                this.singleGood(rsp, actTemplateGroupBOS, skuInfoList, discountMode);
                break;
            }
            case 11: {
                this.singleGoodCombination(rsp, activeId, skuInfoList, discountMode);
                break;
            }
            case 13: {
                this.shopGoods(rsp, actTemplateGroupBOS, skuInfoList, discountMode);
                break;
            }
            case 99: {
                this.activeGoods(rsp, actTemplateGroupBOS, skuInfoList, discountMode);
                break;
            }
        }
    }

    private void singleGoodCombination(ActUniversalCalculationBusiRspBO rsp, Long activeId, List<SkuCalculationActiveBO> skuInfoList, Integer discountMode) {
        BigDecimal totalDiscountPrice = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : skuInfoList) {
            BigDecimal calculatePrice = null != bo.getDiscountPrice() ? bo.getTotalPrice().subtract(bo.getDiscountPrice()) : bo.getTotalPrice();
            SkuActivePO skuActivePO = new SkuActivePO();
            skuActivePO.setActiveId(activeId);
            skuActivePO.setSkuId(bo.getSkuId());
            SkuActivePO skuActive = this.skuActiveMapper.getModelBy(skuActivePO);
            if (null == skuActive) {
                throw new BusinessException("14014", "\u8be5\u5546\u54c1skuId" + bo.getSkuId() + "\u4e0d\u5728\u6d3b\u52a8activeId" + activeId + "\u8303\u56f4\u5185\uff01");
            }
            BigDecimal discountPrice = calculatePrice.subtract(calculatePrice.multiply(new BigDecimal(skuActive.getDiscountRate())));
            if (null != bo.getDiscountPrice()) {
                bo.setDiscountPrice(bo.getDiscountPrice().add(discountPrice));
            } else {
                bo.setDiscountPrice(discountPrice);
            }
            totalDiscountPrice = totalDiscountPrice.add(discountPrice);
        }
        rsp.setTotalDiscountPrice(rsp.getTotalDiscountPrice().add(totalDiscountPrice));
    }

    private void activeGoods(ActUniversalCalculationBusiRspBO rsp, List<ActTemplateGroupBO> actTemplateGroupBOS, List<SkuCalculationActiveBO> skuInfoList, Integer discountMode) {
        BigDecimal totalDiscountMoney = this.calculate(rsp, actTemplateGroupBOS, skuInfoList, discountMode);
        rsp.setTotalDiscountPrice(rsp.getTotalDiscountPrice().add(totalDiscountMoney));
    }

    private void shopGoods(ActUniversalCalculationBusiRspBO rsp, List<ActTemplateGroupBO> actTemplateGroupBOS, List<SkuCalculationActiveBO> skuInfoList, Integer discountMode) {
        HashMap<String, ArrayList<SkuCalculationActiveBO>> shopSkuInfoMap = new HashMap<String, ArrayList<SkuCalculationActiveBO>>();
        for (SkuCalculationActiveBO bo : skuInfoList) {
            ArrayList<SkuCalculationActiveBO> skuList = (ArrayList<SkuCalculationActiveBO>)shopSkuInfoMap.get(bo.getShopId());
            if (CollectionUtils.isEmpty((Collection)skuList)) {
                skuList = new ArrayList<SkuCalculationActiveBO>();
            }
            skuList.add(bo);
            shopSkuInfoMap.put(bo.getShopId(), skuList);
        }
        for (String shopId : shopSkuInfoMap.keySet()) {
            BigDecimal totalDiscountMoney = this.calculate(rsp, actTemplateGroupBOS, (List)shopSkuInfoMap.get(shopId), discountMode);
            rsp.setTotalDiscountPrice(rsp.getTotalDiscountPrice().add(totalDiscountMoney));
        }
    }

    private void singleGood(ActUniversalCalculationBusiRspBO rsp, List<ActTemplateGroupBO> actTemplateGroupBOS, List<SkuCalculationActiveBO> skuInfoList, Integer discountMode) {
        for (SkuCalculationActiveBO skuCalculationActiveBO : skuInfoList) {
            ArrayList<SkuCalculationActiveBO> skuList = new ArrayList<SkuCalculationActiveBO>();
            skuList.add(skuCalculationActiveBO);
            BigDecimal totalDiscountMoney = this.calculate(rsp, actTemplateGroupBOS, skuList, discountMode);
            if (null == totalDiscountMoney) continue;
            rsp.setTotalDiscountPrice(rsp.getTotalDiscountPrice().add(totalDiscountMoney));
        }
    }

    private BigDecimal calculate(ActUniversalCalculationBusiRspBO rsp, List<ActTemplateGroupBO> actTemplateGroupBOS, List<SkuCalculationActiveBO> skuInfoList, Integer discountMode) {
        BigDecimal totalDiscountMoney = new BigDecimal(0);
        List activeGiftList = rsp.getActiveGiftList();
        List activeGiftPkgList = rsp.getActiveGiftPkgList();
        ArrayList<ActDiscountSkuListBO> discountList = new ArrayList<ActDiscountSkuListBO>();
        for (ActTemplateGroupBO bo : actTemplateGroupBOS) {
            ActDiscountSkuListBO tempBO = null;
            for (ActTemplateBO bo1 : bo.getActTemplateBOS()) {
                ActDiscountSkuListBO calculateResult;
                if (ActCommConstant.ActivityTempIdDefine.MONEY_FULL_REDUCTION_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateMoneyFullReductionPrice(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateCountFullReductionCount(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.FEE_FULL_REDUCTION_DISCOUNT_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateMoneyFullReductionDiscountRate(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_DISCOUNT_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateCountFullReductionDiscountRate(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.FEE_FULL_GIVE_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateMoneyFullGive(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_GIVE_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateCountFullGive(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.LADDER_MONEY_FULL_REDUCTION_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateLadderMoneyFullReductionPrice(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.LADDER_COUNT_FULL_REDUCTION_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateLadderCountFullReductionCount(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.LADDER_FEE_FULL_REDUCTION_DISCOUNT_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateLadderMoneyFullReductionDiscountRate(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.LADDER_FULL_REDUCTION_DISCOUNT_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateLadderCountFullReductionDiscountRate(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (ActCommConstant.ActivityTempIdDefine.LADDER_FEE_FULL_GIVE_ID.equals(bo1.getTemplateId())) {
                    tempBO = calculateResult = this.calculateLadderMoneyFullGive(skuInfoList, bo1);
                    discountList.add(calculateResult);
                }
                if (!ActCommConstant.ActivityTempIdDefine.LADDER_COUNT_FULL_GIVE_ID.equals(bo1.getTemplateId())) continue;
                tempBO = calculateResult = this.calculateLadderCountFullGive(skuInfoList, bo1);
                discountList.add(calculateResult);
            }
            if (13 != discountMode) continue;
            Map skuDiscountMap = tempBO.getSkuDiscountMap();
            this.setParam(skuDiscountMap, skuInfoList);
            totalDiscountMoney = totalDiscountMoney.add(tempBO.getDiscountMoney());
        }
        if (10 == discountMode) {
            BigDecimal max = ((ActDiscountSkuListBO)discountList.get(0)).getDiscountMoney();
            int index = 0;
            for (int i = 1; i < discountList.size(); ++i) {
                if (((ActDiscountSkuListBO)discountList.get(i)).getDiscountMoney().compareTo(max) != 1) continue;
                max = ((ActDiscountSkuListBO)discountList.get(i)).getDiscountMoney();
                index = i;
            }
            this.setParam(((ActDiscountSkuListBO)discountList.get(index)).getSkuDiscountMap(), skuInfoList);
            totalDiscountMoney = ((ActDiscountSkuListBO)discountList.get(index)).getDiscountMoney();
        }
        if (11 == discountMode) {
            for (ActDiscountSkuListBO actDiscountSkuListBO : discountList) {
                this.setParam(actDiscountSkuListBO.getSkuDiscountMap(), skuInfoList);
                totalDiscountMoney = totalDiscountMoney.add(actDiscountSkuListBO.getDiscountMoney());
            }
        }
        for (ActDiscountSkuListBO bo : discountList) {
            if (null == bo.getActiveTemplateGroupId()) continue;
            for (ActTemplateGroupBO bo2 : actTemplateGroupBOS) {
                if (!bo2.getActiveTemplateGroupId().equals(bo.getActiveTemplateGroupId())) continue;
                activeGiftList.addAll(bo2.getActiveGiftList());
                activeGiftPkgList.addAll(bo2.getActiveGiftPkgList());
            }
        }
        return totalDiscountMoney;
    }

    private ActDiscountSkuListBO calculateLadderCountFullGive(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actLadderCountFullGiveAtomService.calculateLadderCountFullGive(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateLadderMoneyFullGive(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actLadderMoneyFullGiveAtomService.calculateLadderMoneyFullGive(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateLadderCountFullReductionDiscountRate(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actLadderCountFullReductionDiscountRateAtomService.calculateLadderCountFullReductionDiscountRate(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateLadderMoneyFullReductionDiscountRate(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actLadderMoneyFullReductionDiscountRateAtomService.calculateLadderMoneyFullReductionDiscountRate(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateLadderCountFullReductionCount(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actLadderCountFullReductionAtomService.calculateLadderCountFullReductionPrice(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateLadderMoneyFullReductionPrice(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actLadderMoneyFullReductionAtomService.calculateLadderMoneyFullReductionPrice(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateCountFullGive(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actCountFullGiveAtomService.calculateCountFullGive(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateMoneyFullGive(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actMoneyFullGiveAtomService.calculateMoneyFullGive(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateCountFullReductionDiscountRate(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actCountFullReductionDiscountRateAtomService.calculateCountFullReductionDiscountRate(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateMoneyFullReductionDiscountRate(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actMoneyFullReductionDiscountRateAtomService.calculateMoneyFullReductionDiscountRate(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateCountFullReductionCount(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actCountFullReductionCountAtomService.calculateCountFullReductionCount(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateMoneyFullReductionPrice(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actMoneyFullReductionPriceAtomService.calculateMoneyFullReductionPrice(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private void setParam(Map<String, BigDecimal> skuDiscountMap, List<SkuCalculationActiveBO> skuInfoList) {
        if (null != skuDiscountMap) {
            for (SkuCalculationActiveBO bo2 : skuInfoList) {
                if (null == skuDiscountMap.get(bo2.getSkuId())) continue;
                if (null != bo2.getDiscountPrice()) {
                    bo2.setDiscountPrice(bo2.getDiscountPrice().add(skuDiscountMap.get(bo2.getSkuId())));
                    continue;
                }
                bo2.setDiscountPrice(skuDiscountMap.get(bo2.getSkuId()));
            }
        }
    }
}

