/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.atom.ActOrderActivityCountAtomService;
import com.tydic.newretail.atom.ActSkuActivityCountAtomService;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountReqBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountRspBO;
import com.tydic.newretail.atom.bo.SkuDetailReqAtomBO;
import com.tydic.newretail.busi.ActActivityRecommendBusiService;
import com.tydic.newretail.busi.bo.ActActivityRecommendBusiReqBO;
import com.tydic.newretail.busi.bo.ActActivityRecommendBusiRspBO;
import com.tydic.newretail.common.bo.ActivityChoiceBO;
import com.tydic.newretail.common.bo.RecommendActivityBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ShopActivePO;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActivityRecommendBusiService")
public class ActActivityRecommendBusiServiceImpl
implements ActActivityRecommendBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActivityRecommendBusiServiceImpl.class);
    @Autowired
    private ShopActiveMapper shopActiveMapper;
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ActOrderActivityCountAtomService orderActivityCountAtomService;
    @Autowired
    private ActSkuActivityCountAtomService skuActivityCountAtomService;

    public ActActivityRecommendBusiRspBO recommendActivity(ActActivityRecommendBusiReqBO reqBO) {
        ActActivityRecommendBusiRspBO rspBO = new ActActivityRecommendBusiRspBO();
        ShopActivePO activePO = new ShopActivePO();
        activePO.setShopId(reqBO.getShopId());
        activePO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
        activePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        List<ShopActivePO> shopActivities = this.shopActiveMapper.getList(activePO);
        if (CollectionUtils.isEmpty(shopActivities)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5e97\u94fa\u6d3b\u52a8");
            return rspBO;
        }
        BigDecimal shopDiscount = this.getBestShopActivity(shopActivities, reqBO, rspBO);
        BigDecimal skuDiscount = BigDecimal.ZERO;
        ArrayList<RecommendActivityBO> recommendSkuList = new ArrayList<RecommendActivityBO>();
        for (SkuDetailBO skuDetailBO : reqBO.getSkuList()) {
            RecommendActivityBO recommendActivityBO = new RecommendActivityBO();
            SkuActivePO paramPO = new SkuActivePO();
            paramPO.setShopId(reqBO.getShopId());
            paramPO.setSkuId(skuDetailBO.getSkuId());
            paramPO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
            paramPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            List<SkuActivePO> skuActivities = this.skuActiveMapper.getList(paramPO);
            if (CollectionUtils.isEmpty(skuActivities)) {
                LOGGER.error("\u672a\u67e5\u8be2\u5230\u8be5\u95e8\u5e97\u5355\u54c1\u6d3b\u52a8[skuId=" + skuDetailBO.getSkuId() + "]");
                continue;
            }
            skuDiscount = skuDiscount.add(this.getBestSkuActivity(skuActivities, skuDetailBO, recommendActivityBO));
            recommendSkuList.add(recommendActivityBO);
        }
        if (shopDiscount.compareTo(BigDecimal.ZERO) == 0 && skuDiscount.compareTo(BigDecimal.ZERO) == 0) {
            rspBO.setShopActiveId(null);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u627e\u5230\u6700\u4f18\u5e97\u94fa\u6d3b\u52a8\u548c\u5355\u54c1\u6d3b\u52a8");
            return rspBO;
        }
        if (shopDiscount.compareTo(skuDiscount) < 0) {
            rspBO.setShopActiveId(null);
            rspBO.setRecommendSkuList(recommendSkuList);
            rspBO.setRespDesc("\u6d3b\u52a8\u63a8\u8350\u6210\u529f\uff1a\u5355\u54c1\u6d3b\u52a8\u6700\u4f18");
        } else {
            rspBO.setRespDesc("\u6d3b\u52a8\u63a8\u8350\u6210\u529f\uff1a\u5e97\u94fa\u6d3b\u52a8\u6700\u4f18");
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private BigDecimal getBestShopActivity(List<ShopActivePO> shopActivities, ActActivityRecommendBusiReqBO reqBO, ActActivityRecommendBusiRspBO rspBO) {
        BigDecimal totalDiscount = BigDecimal.ZERO;
        Long shopActiveId = null;
        ActOrderActivityCountAtomReqBO orderAtomReqBO = new ActOrderActivityCountAtomReqBO();
        orderAtomReqBO.setSkuDetailList(reqBO.getSkuList());
        orderAtomReqBO.setFreightAmount(reqBO.getFreightAmount());
        for (ShopActivePO shopActivity : shopActivities) {
            ArrayList<ActivityChoiceBO> activityChoiceList = new ArrayList<ActivityChoiceBO>();
            ActivityChoiceBO activityChoiceBO = new ActivityChoiceBO();
            activityChoiceBO.setActiveId(shopActivity.getActiveId());
            activityChoiceBO.setShopId(shopActivity.getShopId());
            activityChoiceList.add(activityChoiceBO);
            orderAtomReqBO.setActivityAtomList(activityChoiceList);
            ActOrderActivityCountAtomRspBO orderAtomRspBO = this.orderActivityCountAtomService.orderActivityCount(orderAtomReqBO);
            if ("0000".equals(orderAtomRspBO.getRespCode())) {
                if (totalDiscount.compareTo(BigDecimal.ZERO) == 0) {
                    shopActiveId = shopActivity.getActiveId();
                    totalDiscount = orderAtomRspBO.getDisTotalAmo().add(orderAtomRspBO.getDisFreightAmo());
                    continue;
                }
                int compare = totalDiscount.compareTo(orderAtomRspBO.getDisTotalAmo().add(orderAtomRspBO.getDisFreightAmo()));
                if (compare < 0) {
                    totalDiscount = orderAtomRspBO.getDisTotalAmo().add(orderAtomRspBO.getDisFreightAmo());
                    shopActiveId = shopActivity.getActiveId();
                    continue;
                }
                if (compare != 0) continue;
                shopActiveId = shopActivity.getActiveId();
                continue;
            }
            LOGGER.error(orderAtomRspBO.getRespDesc());
        }
        if (shopActiveId == null) {
            LOGGER.error("\u672a\u627e\u5230\u6700\u4f18\u5e97\u94fa\u6d3b\u52a8");
        } else {
            rspBO.setShopActiveId(shopActiveId);
        }
        return totalDiscount;
    }

    private BigDecimal getBestSkuActivity(List<SkuActivePO> skuActivities, SkuDetailBO skuDetailBO, RecommendActivityBO recommendActivityBO) {
        BigDecimal totalDiscount = BigDecimal.ZERO;
        Long skuActiveId = null;
        for (SkuActivePO skuActivity : skuActivities) {
            ActSkuActivityCountReqBO skuAtomReqBO = new ActSkuActivityCountReqBO();
            ArrayList<ActivityChoiceBO> activityChoiceList = new ArrayList<ActivityChoiceBO>();
            SkuDetailReqAtomBO skuDetailActivityReqBO = new SkuDetailReqAtomBO();
            skuDetailActivityReqBO.setShopId(skuActivity.getShopId());
            skuDetailActivityReqBO.setSkuId(skuDetailBO.getSkuId());
            skuDetailActivityReqBO.setSkuNum(skuDetailBO.getSkuNum());
            skuDetailActivityReqBO.setSkuPrice(skuDetailBO.getSkuPrice());
            ActivityChoiceBO activityChoiceBO = new ActivityChoiceBO();
            activityChoiceBO.setActiveId(skuActivity.getActiveId());
            activityChoiceBO.setShopId(skuActivity.getShopId());
            activityChoiceList.add(activityChoiceBO);
            skuDetailActivityReqBO.setActivityChoiceList(activityChoiceList);
            skuAtomReqBO.setActSkuActivityDetailReqBO(skuDetailActivityReqBO);
            ActSkuActivityCountRspBO skuAtomRspBO = this.skuActivityCountAtomService.skuActivityCount(skuAtomReqBO);
            if ("0000".equals(skuAtomRspBO.getRespCode())) {
                if (totalDiscount.compareTo(BigDecimal.ZERO) == 0) {
                    skuActiveId = skuActivity.getActiveId();
                    totalDiscount = skuAtomRspBO.getSkuDetailRspAtomBO().getSkuDisAmount();
                    continue;
                }
                int compare = totalDiscount.compareTo(skuAtomRspBO.getSkuDetailRspAtomBO().getSkuDisAmount());
                if (compare > 0) {
                    totalDiscount = skuAtomRspBO.getSkuDetailRspAtomBO().getSkuDisAmount();
                    skuActiveId = skuActivity.getActiveId();
                    continue;
                }
                if (compare != 0) continue;
                skuActiveId = skuActivity.getActiveId();
                continue;
            }
            LOGGER.error(skuAtomRspBO.getRespDesc());
        }
        if (skuActiveId == null) {
            LOGGER.error("\u672a\u627e\u5230\u6700\u4f18\u5355\u54c1\u6d3b\u52a8");
        } else {
            recommendActivityBO.setSkuActiveId(skuActiveId);
            recommendActivityBO.setSkuId(skuDetailBO.getSkuId());
        }
        return totalDiscount;
    }
}

