/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.ability.ActCreateCouponAppAbilityService;
import com.tydic.newretail.ability.bo.ActCreateCouponAppAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCreateCouponAppAbilityRspBO;
import com.tydic.newretail.busi.ActCreateCouponAppBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponAppBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponAppBusiRspBO;
import com.tydic.newretail.common.bo.CouponCreateAppBO;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponAppAbilityService")
public class ActCreateCouponAppAbilityServiceImpl
implements ActCreateCouponAppAbilityService {
    private ActCreateCouponAppBusiService actCreateCouponAppBusiService;

    @Autowired
    private ActCreateCouponAppAbilityServiceImpl(ActCreateCouponAppBusiService actCreateCouponAppBusiService) {
        this.actCreateCouponAppBusiService = actCreateCouponAppBusiService;
    }

    public ActCreateCouponAppAbilityRspBO createCouponApp(ActCreateCouponAppAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActCreateCouponAppAbilityRspBO rspBO = new ActCreateCouponAppAbilityRspBO();
        ActCreateCouponAppBusiReqBO busiReqBO = new ActCreateCouponAppBusiReqBO();
        busiReqBO.setCouponCreateAppList(reqBO.getCouponCreateAppList());
        ActCreateCouponAppBusiRspBO busiRspBO = this.actCreateCouponAppBusiService.createCouponApp(busiReqBO);
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private void validateArg(ActCreateCouponAppAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCouponCreateAppList())) {
            throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponCreateAppList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (CouponCreateAppBO couponCreateAppBO : reqBO.getCouponCreateAppList()) {
            if (null == couponCreateAppBO.getFmId()) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponCreateAppList]\u4e2d\u7684\u89c4\u683cID[fmId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponCreateAppBO.getRangeId()) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponCreateAppList]\u4e2d\u7684\u8303\u56f4ID[rangeId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponCreateAppBO.getCouponType()) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponCreateAppList]\u4e2d\u7684\u4f18\u60e0\u5238\u7c7b\u578b[couponType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponCreateAppBO.getPatchNum()) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponCreateAppList]\u4e2d\u7684\u521b\u5efa\u6570\u91cf[patchNum]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponCreateAppBO.getValidityLen()) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponCreateAppList]\u4e2d\u7684\u6709\u6548\u671f[validityLen]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)couponCreateAppBO.getEffTime())) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponCreateAppList]\u4e2d\u7684\u751f\u6548\u65f6\u95f4[effTime]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)couponCreateAppBO.getOperCode())) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponCreateAppList]\u4e2d\u7684\u4e1a\u52a1\u7f16\u7801[operCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.vaildateTime(reqBO);
        }
    }

    private Date getExpTime(Date eff, CouponCreateAppBO couponCreateAppBO) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(eff);
        calendar.add(6, couponCreateAppBO.getValidityLen());
        return calendar.getTime();
    }

    private void vaildateTime(ActCreateCouponAppAbilityReqBO reqBO) {
        Date currenTtime = new Date();
        for (CouponCreateAppBO couponCreateAppBO : reqBO.getCouponCreateAppList()) {
            couponCreateAppBO.setCreateTime(DateUtils.dateToStrLong((Date)currenTtime));
            if (StringUtils.isBlank((CharSequence)couponCreateAppBO.getEffTime())) {
                couponCreateAppBO.setEffTime(DateUtils.dateToStrLong((Date)currenTtime));
            }
            if (StringUtils.isBlank((CharSequence)couponCreateAppBO.getExpTime())) {
                Date expTime = this.getExpTime(DateUtils.strToDateLong((String)couponCreateAppBO.getEffTime()), couponCreateAppBO);
                couponCreateAppBO.setExpTime(DateUtils.dateToStrLong((Date)expTime));
            }
            if (DateUtils.IsCompareDate((String)couponCreateAppBO.getCreateTime(), (String)couponCreateAppBO.getEffTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                throw new BusinessException("8000", "\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u7533\u8bf7\u65f6\u95f4");
            }
            if (!DateUtils.IsCompareDate((String)couponCreateAppBO.getExpTime(), (String)couponCreateAppBO.getEffTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                throw new BusinessException("8000", "\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65f6\u95f4");
            }
            if (DateUtils.IsCompareDate((String)couponCreateAppBO.getCreateTime(), (String)couponCreateAppBO.getCycleBeginTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                throw new BusinessException("8000", "\u5468\u671f\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u7533\u8bf7\u65f6\u95f4");
            }
            if (!DateUtils.IsCompareDate((String)couponCreateAppBO.getCycleBeginTime(), (String)couponCreateAppBO.getRuleBeginTime(), (String)"yyyy-MM-dd HH:mm:ss")) continue;
            throw new BusinessException("8000", "\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u5468\u671f\u5f00\u59cb\u65f6\u95f4");
        }
    }
}

