/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActActNumUpdateBusiService;
import com.tydic.newretail.busi.bo.ActActNumUpdateBusiReqBO;
import com.tydic.newretail.busi.bo.ActActNumUpdateBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveStockMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActiveStockPO;
import com.tydic.newretail.dao.po.ShopActivePO;
import com.tydic.newretail.dao.po.SkuActivePO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActNumUpdateBusiService")
public class ActActNumUpdateBusiServiceImpl
implements ActActNumUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActNumUpdateBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ShopActiveMapper shopActiveMapper;
    @Autowired
    private ActiveStockMapper activeStockMapper;
    private static final Integer ADD = 0;
    private static final Integer SUB = 1;

    private ActActNumUpdateBusiRspBO updateActNum2(ActActNumUpdateBusiReqBO busiReqBO) {
        ActActNumUpdateBusiRspBO rsp = new ActActNumUpdateBusiRspBO();
        switch (busiReqBO.getOperType()) {
            case 0: {
                SkuActivePO skuActive;
                SkuActivePO skuActivePO = new SkuActivePO();
                BeanUtils.copyProperties((Object)busiReqBO, (Object)skuActivePO);
                skuActivePO.setStatus(1);
                skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                try {
                    skuActive = this.skuActiveMapper.getModelBy(skuActivePO);
                    if (null == skuActive) {
                        rsp.setRespCode("8888");
                        rsp.setRespDesc("\u67e5\u8be2\u5355\u54c1\u6d3b\u52a8\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
                        return rsp;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u67e5\u8be2\u5355\u54c1\u6d3b\u52a8\u8868\u5f02\u5e38\uff1a" + e);
                    throw new BusinessException("8888", "\u67e5\u8be2\u5355\u54c1\u6d3b\u52a8\u8868\u5f02\u5e38\uff01" + e);
                }
                if (ActCommConstant.ACT_COUNT_DEFAULT_VALUE.equals(skuActive.getActCount())) break;
                int totalCount = busiReqBO.getOperNum() + skuActive.getSaleCount();
                if (totalCount > skuActive.getActCount()) {
                    rsp.setRespCode("8888");
                    rsp.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u4e2dSALE_COUNT + operNum\u5927\u4e8eACT_COUNT\uff01");
                    return rsp;
                }
                skuActive.setSaleCount(totalCount);
                int isUpdate = this.skuActiveMapper.updateByCondition(skuActive);
                if (isUpdate >= 1) break;
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u66f4\u65b0\u5355\u54c1\u6d3b\u52a8\u6570\u91cf\u5931\u8d25\uff01");
                return rsp;
            }
            case 1: {
                SkuActivePO skuActive2;
                SkuActivePO skuActivePO2 = new SkuActivePO();
                BeanUtils.copyProperties((Object)busiReqBO, (Object)skuActivePO2);
                skuActivePO2.setStatus(1);
                skuActivePO2.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                try {
                    skuActive2 = this.skuActiveMapper.getModelBy(skuActivePO2);
                    if (null == skuActive2) {
                        rsp.setRespCode("8888");
                        rsp.setRespDesc("\u67e5\u8be2\u5355\u54c1\u6d3b\u52a8\u8868\u7ed3\u679c\u4e3a\u7a7a2\uff01");
                        return rsp;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u67e5\u8be2\u5355\u54c1\u6d3b\u52a8\u8868\u5f02\u5e38\uff1a" + e);
                    throw new BusinessException("8888", "\u67e5\u8be2\u5355\u54c1\u6d3b\u52a8\u8868\u5f02\u5e38\uff01" + e);
                }
                if (ActCommConstant.ACT_COUNT_DEFAULT_VALUE.equals(skuActive2.getActCount())) break;
                int lastCount = skuActive2.getSaleCount() - busiReqBO.getOperNum();
                if (lastCount < 0) {
                    rsp.setRespCode("8888");
                    rsp.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u4e2dSALE_COUNT - operNum\u5c0f\u4e8e0\uff01");
                    return rsp;
                }
                skuActive2.setSaleCount(lastCount);
                int isUpdate2 = this.skuActiveMapper.updateByCondition(skuActive2);
                if (isUpdate2 >= 1) break;
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u66f4\u65b0\u5355\u54c1\u6d3b\u52a8\u6570\u91cf\u5931\u8d252\uff01");
                return rsp;
            }
            case 2: {
                ShopActivePO shopActive;
                ShopActivePO shopActivePO = new ShopActivePO();
                BeanUtils.copyProperties((Object)busiReqBO, (Object)shopActivePO);
                shopActivePO.setStatus(1);
                shopActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                try {
                    shopActive = this.shopActiveMapper.getModelBy(shopActivePO);
                    if (null == shopActive) {
                        rsp.setRespCode("8888");
                        rsp.setRespDesc("\u67e5\u8be2\u5e97\u94fa\u6d3b\u52a8\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
                        return rsp;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u67e5\u8be2\u5e97\u94fa\u6d3b\u52a8\u8868\u5f02\u5e38\uff1a" + e);
                    throw new BusinessException("8888", "\u67e5\u8be2\u5e97\u94fa\u6d3b\u52a8\u8868\u5f02\u5e38\uff01" + e);
                }
                if (ActCommConstant.ACT_COUNT_DEFAULT_VALUE.equals(shopActive.getActCount())) break;
                int totalCount2 = busiReqBO.getOperNum() + shopActive.getSaleCount();
                if (totalCount2 > shopActive.getActCount()) {
                    rsp.setRespCode("8888");
                    rsp.setRespDesc("\u5e97\u94fa\u6d3b\u52a8\u4e2dSALE_COUNT + operNum\u5927\u4e8eACT_COUNT\uff01");
                    return rsp;
                }
                shopActive.setSaleCount(totalCount2);
                int isUpdate3 = this.shopActiveMapper.updateByCondition(shopActive);
                if (isUpdate3 >= 1) break;
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u66f4\u65b0\u5e97\u94fa\u6d3b\u52a8\u6570\u91cf\u5931\u8d25\uff01");
                return rsp;
            }
            case 3: {
                ShopActivePO shopActive2;
                ShopActivePO shopActivePO2 = new ShopActivePO();
                BeanUtils.copyProperties((Object)busiReqBO, (Object)shopActivePO2);
                shopActivePO2.setStatus(1);
                shopActivePO2.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                try {
                    shopActive2 = this.shopActiveMapper.getModelBy(shopActivePO2);
                    if (null == shopActive2) {
                        rsp.setRespCode("8888");
                        rsp.setRespDesc("\u67e5\u8be2\u5e97\u94fa\u6d3b\u52a8\u8868\u7ed3\u679c\u4e3a\u7a7a2\uff01");
                        return rsp;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u67e5\u8be2\u5e97\u94fa\u6d3b\u52a8\u8868\u5f02\u5e38\uff1a" + e);
                    throw new BusinessException("8888", "\u67e5\u8be2\u5e97\u94fa\u6d3b\u52a8\u8868\u5f02\u5e38\uff01" + e);
                }
                if (ActCommConstant.ACT_COUNT_DEFAULT_VALUE.equals(shopActive2.getActCount())) break;
                int lastCount2 = shopActive2.getSaleCount() - busiReqBO.getOperNum();
                if (lastCount2 < 0) {
                    rsp.setRespCode("8888");
                    rsp.setRespDesc("\u5e97\u94fa\u6d3b\u52a8\u4e2dSALE_COUNT - operNum\u5c0f\u4e8e0!");
                    return rsp;
                }
                shopActive2.setSaleCount(lastCount2);
                int isUpdate4 = this.shopActiveMapper.updateByCondition(shopActive2);
                if (isUpdate4 >= 1) break;
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u66f4\u65b0\u5e97\u94fa\u6d3b\u52a8\u6570\u91cf\u5931\u8d252\uff01");
                return rsp;
            }
            default: {
                throw new BusinessException("8888", "\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    public ActActNumUpdateBusiRspBO updateActNum(ActActNumUpdateBusiReqBO reqBO) {
        ActActNumUpdateBusiRspBO rspBO = new ActActNumUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u670d\u52a1\u6210\u529f\uff01");
        ActiveStockPO activeStockPO = new ActiveStockPO();
        activeStockPO.setActiveId(reqBO.getActiveId());
        ActiveStockPO stockPO = this.activeStockMapper.getModelBy(activeStockPO);
        if (null == stockPO) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6d3b\u52a8\u6570\u91cf\u65e0\u914d\u7f6e\uff0c\u65e0\u9700\u66f4\u65b0");
            return rspBO;
        }
        if (ADD.equals(reqBO.getOperType())) {
            int num = stockPO.getSaleCount() + reqBO.getOperNum();
            if (num > stockPO.getActCount()) {
                rspBO.setRespCode("2004");
                rspBO.setRespDesc("\u53ef\u64cd\u4f5c\u4f59\u91cf\u4e0d\u8db3");
                return rspBO;
            }
            stockPO.setSaleCount(num);
            stockPO.setActCount(null);
            int update = this.activeStockMapper.updateById(stockPO);
            if (update < 1) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\uff0c\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
                }
                throw new BusinessException("6081", "\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u670d\u52a1\u6267\u884c\u66f4\u65b0\u5931\u8d25");
            }
            return rspBO;
        }
        if (SUB.equals(reqBO.getOperType())) {
            int num = stockPO.getSaleCount() - reqBO.getOperNum();
            if (num < 0) {
                rspBO.setRespCode("2004");
                rspBO.setRespDesc("\u53ef\u64cd\u4f5c\u4f59\u91cf\u4e0d\u8db3");
                return rspBO;
            }
            stockPO.setSaleCount(num);
            stockPO.setActCount(null);
            int update = this.activeStockMapper.updateById(stockPO);
            if (update < 1) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\uff0c\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
                }
                throw new BusinessException("6081", "\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u670d\u52a1\u6267\u884c\u66f4\u65b0\u5931\u8d25");
            }
            return rspBO;
        }
        rspBO.setRespCode("2004");
        rspBO.setRespDesc("\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b");
        return rspBO;
    }
}

