/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.comb.impl;

import com.tydic.active.external.api.commodity.bo.ActGuideCatalogBO;
import com.tydic.active.external.api.common.bo.ActExternalCouponFormInfoBO;
import com.tydic.newretail.busi.ActQryActivityCategoryBusiService;
import com.tydic.newretail.busi.ActQrySkuCouponBusiService;
import com.tydic.newretail.busi.bo.ActQryActivityCategoryBusiReqBO;
import com.tydic.newretail.busi.bo.ActQryActivityCategoryBusiRspBO;
import com.tydic.newretail.busi.bo.ActQrySkuCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActQrySkuCouponBusiRspBO;
import com.tydic.newretail.comb.ActQryActivityCategoryCombService;
import com.tydic.newretail.comb.bo.ActQryActivityCategoryCombReqBO;
import com.tydic.newretail.comb.bo.ActQryActivityCategoryCombRspBO;
import com.tydic.newretail.common.bo.CouponFormInfoBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actQryActivityCategoryCombService")
public class ActQryActivityCategoryCombServiceImpl
implements ActQryActivityCategoryCombService {
    @Autowired
    private ActQryActivityCategoryBusiService actQryActivityCategoryBusiService;
    @Autowired
    private ActQrySkuCouponBusiService actQrySkuCouponBusiService;

    public ActQryActivityCategoryCombRspBO qryActivityCategory(ActQryActivityCategoryCombReqBO combReqBO) {
        ActQryActivityCategoryCombRspBO combRspBO = new ActQryActivityCategoryCombRspBO();
        ActQryActivityCategoryBusiReqBO busiReqBO = new ActQryActivityCategoryBusiReqBO();
        BeanUtils.copyProperties((Object)combReqBO, (Object)busiReqBO);
        ActQryActivityCategoryBusiRspBO busiRspBO = this.actQryActivityCategoryBusiService.qryActivityCategory(busiReqBO);
        if (!CollectionUtils.isEmpty((Collection)busiRspBO.getRows())) {
            HashMap<Integer, List<String>> catalogLevelMap = new HashMap<Integer, List<String>>();
            HashMap<Integer, List<ActGuideCatalogBO>> catalogLevelBOMap = new HashMap<Integer, List<ActGuideCatalogBO>>();
            for (Object actGuideCatalogBO : busiRspBO.getRows()) {
                this.getCatalogLevelMap((ActGuideCatalogBO)actGuideCatalogBO, catalogLevelMap, catalogLevelBOMap);
            }
            ActQrySkuCouponBusiReqBO actQrySkuCouponBusiReqBO = new ActQrySkuCouponBusiReqBO();
            for (Integer catalogLevel : catalogLevelMap.keySet()) {
                if (catalogLevel == 1) {
                    actQrySkuCouponBusiReqBO.setL1CategoryIdList((List)catalogLevelMap.get(catalogLevel));
                    continue;
                }
                if (catalogLevel == 2) {
                    actQrySkuCouponBusiReqBO.setL2CategoryIdList((List)catalogLevelMap.get(catalogLevel));
                    continue;
                }
                if (catalogLevel == 3) {
                    actQrySkuCouponBusiReqBO.setL3CategoryIdList((List)catalogLevelMap.get(catalogLevel));
                    continue;
                }
                if (catalogLevel != 4) continue;
                actQrySkuCouponBusiReqBO.setL4CategoryIdList((List)catalogLevelMap.get(catalogLevel));
            }
            ActQrySkuCouponBusiRspBO actQrySkuCouponBusiRspBO = this.actQrySkuCouponBusiService.qrySkuCoupon(actQrySkuCouponBusiReqBO);
            this.setCouponInfo(actQrySkuCouponBusiRspBO.getL1CategoryCouponFormInfoMap(), catalogLevelBOMap, 1);
            this.setCouponInfo(actQrySkuCouponBusiRspBO.getL2CategoryCouponFormInfoMap(), catalogLevelBOMap, 2);
            this.setCouponInfo(actQrySkuCouponBusiRspBO.getL3CategoryCouponFormInfoMap(), catalogLevelBOMap, 3);
            this.setCouponInfo(actQrySkuCouponBusiRspBO.getL4CategoryCouponFormInfoMap(), catalogLevelBOMap, 4);
        }
        BeanUtils.copyProperties((Object)busiRspBO, (Object)combRspBO);
        return combRspBO;
    }

    private void getCatalogLevelMap(ActGuideCatalogBO actGuideCatalogBO, Map<Integer, List<String>> catalogLevelMap, Map<Integer, List<ActGuideCatalogBO>> catalogLevelBOMap) {
        Stack<ActGuideCatalogBO> nodeStack = new Stack<ActGuideCatalogBO>();
        nodeStack.add(actGuideCatalogBO);
        while (!nodeStack.isEmpty()) {
            ActGuideCatalogBO node = (ActGuideCatalogBO)nodeStack.pop();
            node.setCouponNum(Integer.valueOf(0));
            node.setCouponFormList(new ArrayList());
            List<String> temp = catalogLevelMap.get(node.getCatalogLevel());
            List<ActGuideCatalogBO> tempBO = catalogLevelBOMap.get(node.getCatalogLevel());
            if (temp == null) {
                temp = new ArrayList<String>();
                tempBO = new ArrayList<ActGuideCatalogBO>();
            }
            tempBO.add(node);
            temp.add(node.getGuideCatalogId().toString());
            catalogLevelMap.put(node.getCatalogLevel(), temp);
            catalogLevelBOMap.put(node.getCatalogLevel(), tempBO);
            List children = node.getRows();
            if (children == null || children.isEmpty()) continue;
            for (ActGuideCatalogBO child : children) {
                nodeStack.push(child);
            }
        }
    }

    private void setCouponInfo(Map<String, List<CouponFormInfoBO>> catalogCouponMap, Map<Integer, List<ActGuideCatalogBO>> catalogLevelBOMap, Integer level) {
        List<ActGuideCatalogBO> list;
        if (!CollectionUtils.isEmpty(catalogCouponMap) && !CollectionUtils.isEmpty(list = catalogLevelBOMap.get(level))) {
            for (ActGuideCatalogBO actGuideCatalogBO : list) {
                List<CouponFormInfoBO> tempList = catalogCouponMap.get(actGuideCatalogBO.getGuideCatalogId().toString());
                if (tempList != null) {
                    ArrayList<ActExternalCouponFormInfoBO> actExternalCouponFormInfoBOs = new ArrayList<ActExternalCouponFormInfoBO>();
                    for (CouponFormInfoBO couponFormInfoBO : tempList) {
                        ActExternalCouponFormInfoBO bo = new ActExternalCouponFormInfoBO();
                        BeanUtils.copyProperties((Object)couponFormInfoBO, (Object)bo);
                        actExternalCouponFormInfoBOs.add(bo);
                    }
                    actGuideCatalogBO.setCouponFormList(actExternalCouponFormInfoBOs);
                    actGuideCatalogBO.setCouponNum(Integer.valueOf(tempList.size()));
                    continue;
                }
                actGuideCatalogBO.setCouponNum(Integer.valueOf(0));
                actGuideCatalogBO.setCouponFormList(new ArrayList());
            }
        }
    }
}

