/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActCountFullReductionMoneyAtomService;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.newretail.common.bo.ActDiscountSkuListBO;
import com.tydic.newretail.common.bo.ActTemplateAttrBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actCountFullReductionMoneyAtomService")
public class ActCountFullReductionMoneyAtomServiceImpl
implements ActCountFullReductionMoneyAtomService {
    @Override
    public ActCalculationUniversalAtomRspBO calculateCountFullReductionMoney(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        BigDecimal totalCount = new BigDecimal(0);
        BigDecimal totalSalePrice = new BigDecimal(0);
        BigDecimal oldDiscountMoney = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalCount = totalCount.add(bo.getActCount());
            totalSalePrice = totalSalePrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            oldDiscountMoney = oldDiscountMoney.add(bo.getDiscountPrice());
        }
        BigDecimal calculateMoney = totalSalePrice.subtract(oldDiscountMoney);
        BigDecimal discountMoney = new BigDecimal(0);
        if (calculateMoney.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal countReach = new BigDecimal(0);
        BigDecimal feeReachDiscount = new BigDecimal(0);
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("count_reach".equals(bo.getAttrCode())) {
                countReach = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"fee_reach_discount".equals(bo.getAttrCode())) continue;
            feeReachDiscount = new BigDecimal(bo.getParaValue());
        }
        if (totalCount.compareTo(countReach) >= 0) {
            discountMoney = feeReachDiscount;
        }
        actDiscountSkuListBO.setDiscountMoney(discountMoney);
        BigDecimal averageDiscountPrice = discountMoney.divide(new BigDecimal(atomReqBO.getSkuInfoList().size()), 2, RoundingMode.HALF_UP);
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        int fullFeeCount = 0;
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            if (bo.getTotalPrice().compareTo(averageDiscountPrice) > 0) {
                skuDiscountMap.put(bo.getSkuId(), averageDiscountPrice);
                continue;
            }
            skuDiscountMap.put(bo.getSkuId(), bo.getTotalPrice());
            averageDiscountPrice = discountMoney.subtract(bo.getTotalPrice()).divide(new BigDecimal(atomReqBO.getSkuInfoList().size() - ++fullFeeCount), 2, RoundingMode.HALF_UP);
        }
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

