/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActDeleteCouponFormBusiService;
import com.tydic.newretail.busi.bo.ActDeleteCouponFormBusiReqBO;
import com.tydic.newretail.busi.bo.ActDeleteCouponFormBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.po.CouponFormPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actDeleteCouponFormBusiService")
public class ActDeleteCouponFormBusiServiceImpl
implements ActDeleteCouponFormBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActDeleteCouponFormBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private CouponInstMapper couponInstMapper;
    private CouponFormMapper couponFormMapper;

    @Autowired
    private ActDeleteCouponFormBusiServiceImpl(CouponInstMapper couponInstMapper, CouponFormMapper couponFormMapper) {
        this.couponInstMapper = couponInstMapper;
        this.couponFormMapper = couponFormMapper;
    }

    public ActDeleteCouponFormBusiRspBO deleteCouponForm(ActDeleteCouponFormBusiReqBO reqBO) {
        ActDeleteCouponFormBusiRspBO rspBO = new ActDeleteCouponFormBusiRspBO();
        for (Long fmId : reqBO.getFmIdList()) {
            CouponFormPO po = this.couponFormMapper.selectByPrimaryKey(fmId);
            if (po == null) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u6821\u9a8c\uff1afmId:[" + fmId + "]\u8be5\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                throw new BusinessException("14003", "fmId:[" + fmId + "]\u8be5\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            int checkInst = this.couponInstMapper.getCheck4DeleteForm(fmId);
            if (checkInst > 0) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u6821\u9a8c\uff1afmId:[" + fmId + "],\u8be5\u89c4\u683c\u4fe1\u606f\u4e0b\u5b58\u5728\u53ef\u4f7f\u7528\u7684\u4f18\u60e0\u5238\u5b9e\u4f8b\uff0c\u6240\u4ee5\u4e0d\u5141\u8bb8\u5220\u9664");
                }
                throw new BusinessException("14055", "fmId:[" + fmId + "]\u8be5\u89c4\u683c\u4fe1\u606f\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            CouponFormPO couponFormPO = new CouponFormPO();
            couponFormPO.setFmId(fmId);
            couponFormPO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
            int deleteForm = this.couponFormMapper.deleteByPrimaryKey(couponFormPO);
            if (deleteForm >= 1) continue;
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u5220\u9664\u89c4\u683c\u8868\u5931\u8d25fmId=[" + fmId + "]\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("14011", "fmId:[" + fmId + "]\u5220\u9664\u89c4\u683c\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5220\u9664\u6210\u529f");
        return rspBO;
    }
}

