/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.atom.ActActivityCheckAtomService;
import com.tydic.newretail.atom.ActActivitySkuAddAtomService;
import com.tydic.newretail.atom.ActAddActivityTemplateAttrAtomService;
import com.tydic.newretail.atom.ActShopActiveValidCheckAtomService;
import com.tydic.newretail.atom.bo.ActActivitySkuAddAtomReqBO;
import com.tydic.newretail.atom.bo.ActActivitySkuAddAtomRspBO;
import com.tydic.newretail.atom.bo.ActAddActivityTemplateAttrAtomReqBO;
import com.tydic.newretail.atom.bo.ActAddActivityTemplateAttrAtomRspBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomRspBO;
import com.tydic.newretail.atom.bo.ActShopActiveValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActShopActiveValidCheckAtomRspBO;
import com.tydic.newretail.busi.ActCreateCouponBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiRspBO;
import com.tydic.newretail.common.bo.ActActiveShowPozitionBO;
import com.tydic.newretail.common.bo.ActDiscountBO;
import com.tydic.newretail.common.bo.ActMemRangeBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveMemRangeMapper;
import com.tydic.newretail.dao.ActiveShowPozitionMapper;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponNumMapper;
import com.tydic.newretail.dao.po.ActiveMemRangePO;
import com.tydic.newretail.dao.po.ActiveShowPozitionPO;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.CouponNumPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponBusiService")
public class ActCreateCouponBusiServiceImpl
implements ActCreateCouponBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateCouponBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Autowired
    private ActAddActivityTemplateAttrAtomService actAddActivityTemplateAttrAtomService;
    @Autowired
    private ActShopActiveValidCheckAtomService actShopActiveValidCheckAtomService;
    @Autowired
    private ActActivitySkuAddAtomService actActivitySkuAddAtomService;
    @Autowired
    private ActiveMemRangeMapper activeMemRangeMapper;
    @Autowired
    private ActiveShowPozitionMapper activeShowPozitionMapper;
    @Autowired
    private CouponNumMapper couponNumMapper;
    @Autowired
    private ActActivityCheckAtomService actActivityCheckAtomService;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${couponDetailUrl}")
    private String couponDetailUrl;

    public ActCreateCouponBusiRspBO createCoupon(ActCreateCouponBusiReqBO busiReqBO) {
        int isInsert4;
        ActCreateCouponBusiRspBO rsp = new ActCreateCouponBusiRspBO();
        ActCreateActivityCheckAtomReqBO checkAtomReqBO = new ActCreateActivityCheckAtomReqBO();
        checkAtomReqBO.setActTemplateBOS(busiReqBO.getActTemplateBOList());
        ActCreateActivityCheckAtomRspBO checkAtomRspBO = this.actActivityCheckAtomService.checkCreateActivityInfo(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            LOGGER.error("\u4f18\u60e0\u5238\u65b0\u589e\u6821\u9a8c\u5931\u8d25" + checkAtomRspBO.getRespDesc());
            BeanUtils.copyProperties((Object)((Object)checkAtomRspBO), (Object)rsp);
            return rsp;
        }
        Long fmId = Sequence.getInstance().nextId();
        CouponFormPO couponFormPO = this.buildCouponFormPO(busiReqBO, checkAtomRspBO);
        couponFormPO.setFmId(fmId);
        couponFormPO.setDetailUrl(this.couponDetailUrl + "fmId=" + fmId + "&admOrgId=" + couponFormPO.getAdmOrgId());
        int isInsert = this.couponFormMapper.insert(couponFormPO);
        if (isInsert < 1) {
            throw new BusinessException("0101", "\u4f18\u60e0\u5377\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        ActAddActivityTemplateAttrAtomReqBO actAddActivityTemplateAttrAtomReqBO = new ActAddActivityTemplateAttrAtomReqBO();
        actAddActivityTemplateAttrAtomReqBO.setActTemplateBOS(busiReqBO.getActTemplateBOList());
        actAddActivityTemplateAttrAtomReqBO.setMarketingType("11");
        actAddActivityTemplateAttrAtomReqBO.setActiveId(fmId);
        actAddActivityTemplateAttrAtomReqBO.setOperType("operTemplate");
        ActAddActivityTemplateAttrAtomRspBO actAddActivityTemplateAttrAtomRspBO = this.actAddActivityTemplateAttrAtomService.addActivityTemplateAttr(actAddActivityTemplateAttrAtomReqBO);
        if (!"0000".equals(actAddActivityTemplateAttrAtomRspBO.getRespCode())) {
            throw new BusinessException(actAddActivityTemplateAttrAtomRspBO.getRespCode(), actAddActivityTemplateAttrAtomRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getSkuInfoList())) {
            ActShopActiveValidCheckAtomReqBO actShopActiveValidCheckAtomReqBO = new ActShopActiveValidCheckAtomReqBO();
            actShopActiveValidCheckAtomReqBO.setActiveId(fmId);
            actShopActiveValidCheckAtomReqBO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
            actShopActiveValidCheckAtomReqBO.setMarketingType("11");
            actShopActiveValidCheckAtomReqBO.setSkuInfoList(busiReqBO.getSkuInfoList());
            ActShopActiveValidCheckAtomRspBO actShopActiveValidCheckAtomRspBO = this.actShopActiveValidCheckAtomService.checkShopActiveValid(actShopActiveValidCheckAtomReqBO);
            if (!"0000".equals(actShopActiveValidCheckAtomRspBO.getRespCode())) {
                throw new BusinessException(actShopActiveValidCheckAtomRspBO.getRespCode(), actShopActiveValidCheckAtomRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty(actShopActiveValidCheckAtomReqBO.getSkuInfoList())) {
                ActActivitySkuAddAtomReqBO actActivitySkuAddAtomReqBO = new ActActivitySkuAddAtomReqBO();
                actActivitySkuAddAtomReqBO.setActiveId(fmId);
                actActivitySkuAddAtomReqBO.setMarketingType("11");
                actActivitySkuAddAtomReqBO.setSkuInfoList(actShopActiveValidCheckAtomReqBO.getSkuInfoList());
                actActivitySkuAddAtomReqBO.setSkuActiveBO(actShopActiveValidCheckAtomRspBO.getSkuActiveBO());
                ActActivitySkuAddAtomRspBO actActivitySkuAddAtomRspBO = this.actActivitySkuAddAtomService.addActivitySku(actActivitySkuAddAtomReqBO);
                if (!"0000".equals(actActivitySkuAddAtomRspBO.getRespCode())) {
                    throw new BusinessException(actActivitySkuAddAtomRspBO.getRespCode(), actActivitySkuAddAtomRspBO.getRespDesc());
                }
            }
        }
        ArrayList<ActiveMemRangePO> activeMemRangePOList = new ArrayList<ActiveMemRangePO>();
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getMemRangeList())) {
            for (ActMemRangeBO bo : busiReqBO.getMemRangeList()) {
                ActiveMemRangePO activeMemRangePO = new ActiveMemRangePO();
                BeanUtils.copyProperties((Object)bo, (Object)activeMemRangePO);
                activeMemRangePO.setMemRangeId(Sequence.getInstance().nextId());
                activeMemRangePO.setActiveId(fmId);
                activeMemRangePO.setMarketingType("11");
                activeMemRangePOList.add(activeMemRangePO);
            }
        } else {
            ActiveMemRangePO activeMemRangePO1 = new ActiveMemRangePO();
            activeMemRangePO1.setMemRangeId(Sequence.getInstance().nextId());
            activeMemRangePO1.setActiveId(fmId);
            activeMemRangePO1.setMarketingType("11");
            activeMemRangePO1.setMemParamType("99");
            activeMemRangePO1.setParamInsCode("99");
            activeMemRangePOList.add(activeMemRangePO1);
        }
        int isInsert2 = this.activeMemRangeMapper.insertBatch(activeMemRangePOList);
        if (isInsert2 != activeMemRangePOList.size()) {
            throw new BusinessException("0101", "\u6d3b\u52a8\u4f1a\u5458\u8303\u56f4\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getShowPozitonList())) {
            ArrayList<ActiveShowPozitionPO> activeShowPozitionPOList = new ArrayList<ActiveShowPozitionPO>();
            for (ActActiveShowPozitionBO bo : busiReqBO.getShowPozitonList()) {
                ActiveShowPozitionPO activeShowPozitionPO = new ActiveShowPozitionPO();
                BeanUtils.copyProperties((Object)bo, (Object)activeShowPozitionPO);
                activeShowPozitionPO.setShowPozitionId(Sequence.getInstance().nextId());
                activeShowPozitionPO.setActiveId(fmId);
                activeShowPozitionPO.setMarketingType("11");
                activeShowPozitionPO.setState(ActCommConstant.CouponValidMark.VALID);
                activeShowPozitionPOList.add(activeShowPozitionPO);
            }
            int isInsert3 = this.activeShowPozitionMapper.insertBatch(activeShowPozitionPOList);
            if (isInsert3 != activeShowPozitionPOList.size()) {
                throw new BusinessException("0101", "\u6d3b\u52a8\u6295\u653e\u4f4d\u7f6e\u8868\u65b0\u589e\u5931\u8d25\uff01");
            }
        }
        CouponNumPO couponNumPO = new CouponNumPO();
        couponNumPO.setAmountTotalId(Sequence.getInstance().nextId());
        couponNumPO.setFmId(fmId);
        couponNumPO.setTotalNum(busiReqBO.getTotalAmount());
        if (null == couponNumPO.getTotalNum()) {
            couponNumPO.setTotalNum(0L);
        }
        couponNumPO.setMemLimitNum(busiReqBO.getMemLimitAmount());
        if (null == couponNumPO.getMemLimitNum()) {
            couponNumPO.setMemLimitNum(0);
        }
        couponNumPO.setSendNum(0L);
        couponNumPO.setUsedNum(0L);
        if (null == couponNumPO.getTotalNum()) {
            couponNumPO.setTotalNum(0L);
        }
        if ((isInsert4 = this.couponNumMapper.insert(couponNumPO)) < 1) {
            throw new BusinessException("0101", "\u4f18\u60e0\u5377\u6570\u91cf\u63a7\u5236\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        String redisKey = "COUPON_RECEIVE_NUM_PREX_" + couponNumPO.getFmId();
        this.cacheService.set(redisKey, (Object)0);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f18\u60e0\u5238\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
        return rsp;
    }

    private CouponFormPO buildCouponFormPO(ActCreateCouponBusiReqBO busiReqBO, ActCreateActivityCheckAtomRspBO checkAtomRspBO) {
        CouponFormPO couponFormPO = new CouponFormPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)couponFormPO);
        couponFormPO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
        couponFormPO.setState(ActCommConstant.CouponFormState.AUDIT_PASS);
        if (!CollectionUtils.isEmpty(checkAtomRspBO.getActDiscountBOs())) {
            String fmDesc = "\u6ee1";
            ActDiscountBO actDiscountBO = checkAtomRspBO.getActDiscountBOs().get(0);
            couponFormPO.setConditionType(actDiscountBO.getConditionType());
            if (StringUtils.isNotBlank((CharSequence)actDiscountBO.getConditionValue())) {
                couponFormPO.setConditionValue(actDiscountBO.getConditionValue());
                fmDesc = fmDesc + actDiscountBO.getConditionValue();
            }
            if (ActCommConstant.ActiveTemplateConditionType.MONEY.equals(actDiscountBO.getConditionType())) {
                fmDesc = fmDesc + "\u5143\u53ef\u7528";
            } else if (ActCommConstant.ActiveTemplateConditionType.ACOUNT.equals(actDiscountBO.getConditionType())) {
                fmDesc = fmDesc + "\u4ef6\u53ef\u7528";
            }
            couponFormPO.setDiscountType(actDiscountBO.getDiscountType());
            couponFormPO.setDiscountValue(actDiscountBO.getDiscountValue());
            couponFormPO.setFmDesc(fmDesc);
            couponFormPO.setCreateTime(new Date());
        }
        return couponFormPO;
    }
}

