/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActShopActiveValidCheckAtomService;
import com.tydic.newretail.atom.bo.ActShopActiveValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActShopActiveValidCheckAtomRspBO;
import com.tydic.newretail.common.bo.ActivitiesBO;
import com.tydic.newretail.common.bo.SkuActiveBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.CouponFormPO;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actShopActiveValidCheckAtomService")
public class ActShopActiveValidCheckAtomServiceImpl
implements ActShopActiveValidCheckAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActShopActiveValidCheckAtomServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private static final String PARAM_MSG = "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1";
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Value(value="${CATEGORY_LEVEL}")
    private Integer categoryLevel;

    @Override
    public ActShopActiveValidCheckAtomRspBO checkShopActiveValid(ActShopActiveValidCheckAtomReqBO atomReqBO) {
        ActShopActiveValidCheckAtomRspBO rsp = new ActShopActiveValidCheckAtomRspBO();
        SkuActiveBO skuActiveBO = new SkuActiveBO();
        if ("10".equals(atomReqBO.getMarketingType())) {
            ActivityPO activityPO = new ActivityPO();
            activityPO.setActiveId(atomReqBO.getActiveId());
            activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            activityPO.setAdmOrgId(atomReqBO.getOrgIdIn());
            ActivityPO activity = this.activityMapper.getModelBy(activityPO);
            if (null == activity) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
                }
                throw new BusinessException("14035", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
            }
            ActivitiesBO activityBo = new ActivitiesBO();
            BeanUtils.copyProperties((Object)activity, (Object)activityBo);
            skuActiveBO.setActivityBo(activityBo);
        } else {
            CouponFormPO reqPO = new CouponFormPO();
            reqPO.setFmId(atomReqBO.getActiveId());
            reqPO.setAdmOrgId(atomReqBO.getOrgIdIn());
            CouponFormPO couponFormPO = this.couponFormMapper.selectByPrimaryKey(reqPO);
            if (null == couponFormPO || ActCommConstant.IsDelete.DELETED.equals(couponFormPO.getIsDelete())) {
                throw new BusinessException("14035", "\u4f18\u60e0\u5377\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
            }
            if (couponFormPO.getCouponType().equals(ActCommConstant.CouponTypeCode.FULL_SUBTRACTION) || couponFormPO.getCouponType().equals(ActCommConstant.CouponTypeCode.FULL_DISCOUNT)) {
                ArrayList<SkuActiveBO> skuInfoListNew = new ArrayList<SkuActiveBO>();
                if (!couponFormPO.getCouponLevel().equals(ActCommConstant.CouponLevel.LEVEL_PLATFORM) && !CollectionUtils.isEmpty(atomReqBO.getSkuInfoList())) {
                    for (SkuActiveBO bo : atomReqBO.getSkuInfoList()) {
                        SkuActiveBO boNew = new SkuActiveBO();
                        if (couponFormPO.getCouponLevel().equals(ActCommConstant.CouponLevel.LEVEL_SKU)) {
                            if (StringUtils.isBlank((CharSequence)bo.getSkuId())) {
                                throw new BusinessException("14001", "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1[skuInfoList.skuId]\u4e0d\u80fd\u4e3a\u7a7a");
                            }
                            if (StringUtils.isBlank((CharSequence)bo.getCommodityId())) {
                                throw new BusinessException("14001", "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1[skuInfoList.commodityId]\u4e0d\u80fd\u4e3a\u7a7a");
                            }
                            boNew.setSkuId(bo.getSkuId());
                            boNew.setCommodityId(bo.getCommodityId());
                            skuInfoListNew.add(boNew);
                        }
                        if (couponFormPO.getCouponLevel().equals(ActCommConstant.CouponLevel.SKU_COMMODITY)) {
                            if (StringUtils.isBlank((CharSequence)bo.getCommodityId())) {
                                throw new BusinessException("14001", "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1[skuInfoList.commodityId]\u4e0d\u80fd\u4e3a\u7a7a");
                            }
                            boNew.setCommodityId(bo.getCommodityId());
                            skuInfoListNew.add(boNew);
                        }
                        if (couponFormPO.getCouponLevel().equals(ActCommConstant.CouponLevel.SKU_CATEGORY)) {
                            if (this.categoryLevel.equals(ActCommConstant.CategoryLevel.SKU_L1CATEGORY)) {
                                if (StringUtils.isBlank((CharSequence)bo.getCategory1Id())) {
                                    throw new BusinessException("14001", "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1[skuInfoList.Category1Id]\u4e0d\u80fd\u4e3a\u7a7a");
                                }
                                boNew.setCategory1Id(bo.getCategory1Id());
                                skuInfoListNew.add(boNew);
                            }
                            if (this.categoryLevel.equals(ActCommConstant.CategoryLevel.SKU_L2CATEGORY)) {
                                if (StringUtils.isBlank((CharSequence)bo.getCategory2Id())) {
                                    throw new BusinessException("14001", "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1[skuInfoList.Category2Id]\u4e0d\u80fd\u4e3a\u7a7a");
                                }
                                boNew.setCategory2Id(bo.getCategory2Id());
                                skuInfoListNew.add(boNew);
                            }
                            if (this.categoryLevel.equals(ActCommConstant.CategoryLevel.SKU_L3CATEGORY)) {
                                if (StringUtils.isBlank((CharSequence)bo.getCategory3Id())) {
                                    throw new BusinessException("14001", "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1[skuInfoList.Category3Id]\u4e0d\u80fd\u4e3a\u7a7a");
                                }
                                boNew.setCategory3Id(bo.getCategory3Id());
                                skuInfoListNew.add(boNew);
                            }
                            if (this.categoryLevel.equals(ActCommConstant.CategoryLevel.SKU_L4CATEGORY)) {
                                if (StringUtils.isBlank((CharSequence)bo.getCategory4Id())) {
                                    throw new BusinessException("14001", "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1[skuInfoList.Category4Id]\u4e0d\u80fd\u4e3a\u7a7a");
                                }
                                boNew.setCategory4Id(bo.getCategory4Id());
                                skuInfoListNew.add(boNew);
                            }
                        }
                        if (!couponFormPO.getCouponLevel().equals(ActCommConstant.CouponLevel.LEVEL_SHOP)) continue;
                        if (StringUtils.isBlank((CharSequence)bo.getShopId())) {
                            throw new BusinessException("14001", "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1[skuInfoList.ShopId]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        boNew.setShopId(bo.getShopId());
                        skuInfoListNew.add(boNew);
                    }
                }
                atomReqBO.setSkuInfoList(skuInfoListNew);
            }
        }
        rsp.setSkuActiveBO(skuActiveBO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5e97\u94fa\u6d3b\u52a8\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

