/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActActDeleteBusiService;
import com.tydic.newretail.busi.bo.ActActDeleteBusiReqBO;
import com.tydic.newretail.busi.bo.ActActDeleteBusiRspBO;
import com.tydic.newretail.common.bo.ChooseActivityBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActDeleteBusiService")
public class ActActDeleteBusiServiceImpl
implements ActActDeleteBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActDeleteBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private ActivityMapper activityMapper;
    private SkuActiveMapper skuActiveMapper;
    private ShopActiveMapper shopActiveMapper;

    @Autowired
    public ActActDeleteBusiServiceImpl(ActivityMapper activityMapper, SkuActiveMapper skuActiveMapper, ShopActiveMapper shopActiveMapper) {
        this.activityMapper = activityMapper;
        this.skuActiveMapper = skuActiveMapper;
        this.shopActiveMapper = shopActiveMapper;
    }

    public ActActDeleteBusiRspBO deleteActivity(ActActDeleteBusiReqBO reqBO) {
        ActActDeleteBusiRspBO rspBO = new ActActDeleteBusiRspBO();
        for (ChooseActivityBO chooseActivityBO : reqBO.getDeleteActivityInfoList()) {
            ActivityPO actPO = new ActivityPO();
            actPO.setActiveId(chooseActivityBO.getActiveId());
            actPO.setActiveCode(chooseActivityBO.getActiveCode());
            actPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            actPO.setAdmOrgId(reqBO.getOrgIdIn());
            ActivityPO activityPO = this.activityMapper.getModelBy(actPO);
            if (null == activityPO) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("Id[" + chooseActivityBO.getActiveId() + "],Code[" + chooseActivityBO.getActiveCode() + "]\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
                }
                throw new BusinessException("6021", "Id[" + chooseActivityBO.getActiveId() + "],Code[" + chooseActivityBO.getActiveCode() + "]\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            if (CollectionUtils.isEmpty((Collection)chooseActivityBO.getSkuActIds())) {
                this.updateActivity(activityPO.getActiveId(), reqBO.getOrgIdIn());
                continue;
            }
            SkuActivePO skuActivePO1 = new SkuActivePO();
            skuActivePO1.setActiveId(activityPO.getActiveId());
            skuActivePO1.setSkuActIds(chooseActivityBO.getSkuActIds());
            skuActivePO1.setAdmOrgId(reqBO.getOrgIdIn());
            this.skuActiveMapper.deleteBy(skuActivePO1);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u5220\u9664\u6210\u529f");
        return rspBO;
    }

    private void updateActivity(Long activeId, String orgIdIn) {
        ActivityPO activePO = new ActivityPO();
        activePO.setActiveId(activeId);
        activePO.setActiveStatus(ActCommConstant.ActivityState.DISABLED);
        activePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        activePO.setAdmOrgId(orgIdIn);
        int updateActResult = this.activityMapper.updateById(activePO);
        if (updateActResult < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(activeId);
        skuActivePO.setAdmOrgId(orgIdIn);
        this.skuActiveMapper.deleteBy(skuActivePO);
    }
}

