/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.atom.ActActivityCheckAtomService;
import com.tydic.newretail.atom.ActAddActiveCouponCommAtomService;
import com.tydic.newretail.atom.ActAddActivityGiftAtomService;
import com.tydic.newretail.atom.ActAddActivityGiftPkgAtomService;
import com.tydic.newretail.atom.bo.ActAddActiveCouponCommAtomReqBO;
import com.tydic.newretail.atom.bo.ActAddActiveCouponCommAtomRspBO;
import com.tydic.newretail.atom.bo.ActAddActivityGiftAtomReqBO;
import com.tydic.newretail.atom.bo.ActAddActivityGiftAtomRspBO;
import com.tydic.newretail.atom.bo.ActAddActivityGiftPkgAtomReqBO;
import com.tydic.newretail.atom.bo.ActAddActivityGiftPkgAtomRspBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomRspBO;
import com.tydic.newretail.busi.ActCreateActivityNewBusiService;
import com.tydic.newretail.busi.bo.ActCreateActivityNewBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateActivityNewBusiRspBO;
import com.tydic.newretail.common.bo.CreateActivityNewInfoBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveStockMapper;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.po.ActiveStockPO;
import com.tydic.newretail.dao.po.ActivityPO;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateActivityNewBusiService")
public class ActCreateActivityNewBusiServiceImpl
implements ActCreateActivityNewBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateActivityNewBusiServiceImpl.class);
    @Autowired
    private ActActivityCheckAtomService actActivityCheckAtomService;
    @Autowired
    private ActAddActivityGiftAtomService actAddActivityGiftAtomService;
    @Autowired
    private ActAddActivityGiftPkgAtomService actAddActivityGiftPkgAtomService;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActiveStockMapper activeStockMapper;
    @Autowired
    private ActAddActiveCouponCommAtomService actAddActiveCouponCommAtomService;

    public ActCreateActivityNewBusiRspBO createActivityNew(ActCreateActivityNewBusiReqBO actCreateActivityNewBusiReqBO) {
        CreateActivityNewInfoBO createActivityNewInfoBO = actCreateActivityNewBusiReqBO.getActivityInfoBO();
        if (null == createActivityNewInfoBO) {
            throw new BusinessException("14000", "\u5165\u53c2\u4e3a\u7a7a");
        }
        ActCreateActivityNewBusiRspBO busiRspBO = new ActCreateActivityNewBusiRspBO();
        ActCreateActivityCheckAtomReqBO checkAtomReqBO = new ActCreateActivityCheckAtomReqBO();
        checkAtomReqBO.setActTemplateGroupBOList(createActivityNewInfoBO.getActTemplateGroupBOList());
        checkAtomReqBO.setActiveGiftList(createActivityNewInfoBO.getActiveGiftList());
        checkAtomReqBO.setActiveGiftPkgList(createActivityNewInfoBO.getActiveGiftPkgList());
        checkAtomReqBO.setActiveType(actCreateActivityNewBusiReqBO.getActivityInfoBO().getActiveType());
        ActCreateActivityCheckAtomRspBO checkAtomRspBO = this.actActivityCheckAtomService.checkCreateActivityInfo(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            LOGGER.error("\u6d3b\u52a8\u65b0\u589e\u6821\u9a8c\u5931\u8d25" + checkAtomRspBO.getRespDesc());
            BeanUtils.copyProperties((Object)((Object)checkAtomRspBO), (Object)busiRspBO);
            return busiRspBO;
        }
        Long activeId = Sequence.getInstance().nextId();
        createActivityNewInfoBO.setActiveId(activeId);
        this.addActiveBaseInfo(createActivityNewInfoBO, actCreateActivityNewBusiReqBO.getOrgIdIn());
        this.addActiveStock(createActivityNewInfoBO, actCreateActivityNewBusiReqBO.getOrgIdIn());
        ActAddActiveCouponCommAtomReqBO actAddActiveCouponCommAtomReqBO = new ActAddActiveCouponCommAtomReqBO();
        actAddActiveCouponCommAtomReqBO.setActiveId(activeId);
        actAddActiveCouponCommAtomReqBO.setMarketingType("10");
        actAddActiveCouponCommAtomReqBO.setActTemplateGroupBOList(checkAtomRspBO.getActTemplateGroupBOList());
        actAddActiveCouponCommAtomReqBO.setMemRangeList(createActivityNewInfoBO.getMemRangeList());
        actAddActiveCouponCommAtomReqBO.setShowPozitonList(createActivityNewInfoBO.getShowPozitonList());
        actAddActiveCouponCommAtomReqBO.setSkuInfoList(createActivityNewInfoBO.getSkuInfoList());
        actAddActiveCouponCommAtomReqBO.setOperActiveTemplate("operTemplateGroup");
        actAddActiveCouponCommAtomReqBO.setOrgIdIn(actCreateActivityNewBusiReqBO.getOrgIdIn());
        actAddActiveCouponCommAtomReqBO.setMemIdIn(actCreateActivityNewBusiReqBO.getMemIdIn());
        actAddActiveCouponCommAtomReqBO.setOperType("add");
        ActAddActiveCouponCommAtomRspBO atomRspBO = this.actAddActiveCouponCommAtomService.addActiveOrCouponCommonInfo(actAddActiveCouponCommAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException("0101", "\u4f18\u60e0\u5377\u6d3b\u52a8\u516c\u5171\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
        }
        this.addActiveGift(createActivityNewInfoBO, actCreateActivityNewBusiReqBO.getOrgIdIn());
        this.addActiveGiftPkg(createActivityNewInfoBO, actCreateActivityNewBusiReqBO.getOrgIdIn());
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u65b0\u589e\u6210\u529f");
        return busiRspBO;
    }

    private void addActiveGiftPkg(CreateActivityNewInfoBO createActivityNewInfoBO, String orgIdIn) {
        if (!CollectionUtils.isEmpty((Collection)createActivityNewInfoBO.getActiveGiftPkgList())) {
            ActAddActivityGiftPkgAtomReqBO atomReqBO = new ActAddActivityGiftPkgAtomReqBO();
            atomReqBO.setActiveGiftPkgList(createActivityNewInfoBO.getActiveGiftPkgList());
            atomReqBO.setActiveId(createActivityNewInfoBO.getActiveId());
            atomReqBO.setOrgIdIn(orgIdIn);
            ActAddActivityGiftPkgAtomRspBO atomRspBO = this.actAddActivityGiftPkgAtomService.addActivityGiftPkg(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException("14044", "\u6d3b\u52a8\u521b\u5efa\u8bb0\u5f55\u6d3b\u52a8\u8d60\u54c1\u5305\u5931\u8d25\uff01");
            }
        }
    }

    private void addActiveGift(CreateActivityNewInfoBO createActivityNewInfoBO, String orgIdIn) {
        if (!CollectionUtils.isEmpty((Collection)createActivityNewInfoBO.getActiveGiftList())) {
            ActAddActivityGiftAtomReqBO atomReqBO = new ActAddActivityGiftAtomReqBO();
            atomReqBO.setActiveGiftList(createActivityNewInfoBO.getActiveGiftList());
            atomReqBO.setActiveId(createActivityNewInfoBO.getActiveId());
            atomReqBO.setOrgIdIn(orgIdIn);
            ActAddActivityGiftAtomRspBO atomRspBO = this.actAddActivityGiftAtomService.addActivityGift(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException("14043", "\u6d3b\u52a8\u521b\u5efa\u8bb0\u5f55\u6d3b\u52a8\u8d60\u54c1\u5931\u8d25\uff01");
            }
        }
    }

    private void addActiveBaseInfo(CreateActivityNewInfoBO createActivityNewInfoBO, String orgIdIn) {
        ActivityPO activityPO = new ActivityPO();
        BeanUtils.copyProperties((Object)createActivityNewInfoBO, (Object)activityPO);
        if (StringUtils.isBlank((CharSequence)createActivityNewInfoBO.getActiveCode())) {
            activityPO.setActiveCode("MSC_" + createActivityNewInfoBO.getActiveId());
        }
        Date now = new Date();
        activityPO.setCreateTime(now);
        activityPO.setUpdateTime(now);
        activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        activityPO.setAdmOrgId(orgIdIn);
        int activityInsertResult = this.activityMapper.insert(activityPO);
        if (activityInsertResult <= 0) {
            throw new BusinessException("14045", "\u6d3b\u52a8\u521b\u5efa\u8bb0\u5f55\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
        }
    }

    private void addActiveStock(CreateActivityNewInfoBO createActivityNewInfoBO, String orgIdIn) {
        if (null != createActivityNewInfoBO.getActCount()) {
            if (0 > createActivityNewInfoBO.getActCount()) {
                throw new BusinessException("2014", "\u6d3b\u52a8\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\uff01");
            }
            ActiveStockPO activeStockPO = new ActiveStockPO();
            activeStockPO.setActCount(createActivityNewInfoBO.getActCount());
            activeStockPO.setSaleCount(ActCommConstant.SALE_SEND_COUNT_DEFAULT_VALUE);
            activeStockPO.setActiveId(createActivityNewInfoBO.getActiveId());
            activeStockPO.setId(Sequence.getInstance().nextId());
            activeStockPO.setAdmOrgId(orgIdIn);
            int activityStockInsertResult = this.activeStockMapper.insert(activeStockPO);
            if (activityStockInsertResult <= 0) {
                throw new BusinessException("14046", "\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u6d3b\u52a8\u5e93\u5b58\u8868\u5931\u8d25\uff01");
            }
        }
    }
}

