/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActActivityRecommendAbilityService;
import com.tydic.newretail.ability.bo.ActActivityRecommendAbilityReqBO;
import com.tydic.newretail.ability.bo.ActActivityRecommendAbilityRspBO;
import com.tydic.newretail.busi.ActActivityRecommendBusiService;
import com.tydic.newretail.busi.bo.ActActivityRecommendBusiReqBO;
import com.tydic.newretail.busi.bo.ActActivityRecommendBusiRspBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActivityRecommendAbilityService")
public class ActActivityRecommendAbilityServiceImpl
implements ActActivityRecommendAbilityService {
    @Autowired
    private ActActivityRecommendBusiService actActivityRecommendBusiService;

    public ActActivityRecommendAbilityRspBO recommendActivity(ActActivityRecommendAbilityReqBO reqBO) {
        this.validParam(reqBO);
        ActActivityRecommendAbilityRspBO rspBO = new ActActivityRecommendAbilityRspBO();
        ActActivityRecommendBusiReqBO busiReqBO = new ActActivityRecommendBusiReqBO();
        busiReqBO.setShopId(reqBO.getShopId());
        busiReqBO.setFreightAmount(reqBO.getFreightAmount());
        busiReqBO.setSkuList(reqBO.getSkuList());
        ActActivityRecommendBusiRspBO busiRspBO = this.actActivityRecommendBusiService.recommendActivity(busiReqBO);
        rspBO.setShopActiveId(busiRspBO.getShopActiveId());
        rspBO.setRecommendSkuList(busiRspBO.getRecommendSkuList());
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private void validParam(ActActivityRecommendAbilityReqBO reqBO) {
        if (reqBO.getShopId() == null) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u63a8\u8350\u670d\u52a1\u95e8\u5e97ID[shopId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuList())) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u63a8\u8350\u670d\u52a1\u5546\u54c1\u660e\u7ec6[skuList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SkuDetailBO skuDetailBO : reqBO.getSkuList()) {
            if (StringUtils.isBlank((CharSequence)skuDetailBO.getSkuId())) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u63a8\u8350\u670d\u52a1\u5546\u54c1\u660e\u7ec6[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (skuDetailBO.getSkuPrice() == null) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u63a8\u8350\u670d\u52a1\u5546\u54c1\u660e\u7ec6[skuPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (skuDetailBO.getSkuNum() != null) continue;
            throw new BusinessException("8000", "\u6d3b\u52a8\u63a8\u8350\u670d\u52a1\u5546\u54c1\u660e\u7ec6[skuNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

