/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.ability.ActCreateCouponAbilityService;
import com.tydic.newretail.ability.bo.ActCreateCouponAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCreateCouponAbilityRspBO;
import com.tydic.newretail.busi.ActCreateCouponBusiService;
import com.tydic.newretail.busi.ActDictionaryBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiRspBO;
import com.tydic.newretail.common.bo.DicDictionaryBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.utils.ActDateUtils;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponAbillityService")
public class ActCreateCouponAbillityServiceImpl
implements ActCreateCouponAbilityService {
    private static final String PARAM_MSG = "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    @Autowired
    private ActCreateCouponBusiService actCreateCouponBusiService;
    @Autowired
    private ActDictionaryBusiService actDictionaryBusiService;

    public ActCreateCouponAbilityRspBO createCoupon(ActCreateCouponAbilityReqBO abilityReqBO) {
        this.validateArg(abilityReqBO);
        ActCreateCouponAbilityRspBO rsp = new ActCreateCouponAbilityRspBO();
        ActCreateCouponBusiReqBO busiReqBO = new ActCreateCouponBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)busiReqBO);
        ActCreateCouponBusiRspBO actCreateCouponBusiRspBO = this.actCreateCouponBusiService.createCoupon(busiReqBO);
        BeanUtils.copyProperties((Object)actCreateCouponBusiRspBO, (Object)rsp);
        return rsp;
    }

    private void validateArg(ActCreateCouponAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[abilityReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getOrgIdIn() == null) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[OrgIdIn]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getFmName())) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[fmName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getCouponMark())) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[couponMark]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getImageUrl())) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[imageUrl]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getCouponType()) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[couponType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((abilityReqBO.getCouponType().equals(ActCommConstant.CouponTypeCode.FULL_SUBTRACTION) || abilityReqBO.getCouponType().equals(ActCommConstant.CouponTypeCode.FULL_DISCOUNT)) && null == abilityReqBO.getCouponLevel()) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[couponLevel]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getEffTime()) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[effTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        abilityReqBO.setEffTime(DateUtils.strToDateLong((String)DateUtils.getCurrentMinDate((String)DateUtils.dateToStrLong((Date)abilityReqBO.getEffTime()))));
        if (null == abilityReqBO.getExpTime()) {
            DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
            dicDictionaryBO.setSysCode("MSC");
            dicDictionaryBO.setPCode("COUPON_DEFAULT_TIME");
            DicDictionaryBO dictionaryByBO = this.actDictionaryBusiService.getDictionaryByBO(dicDictionaryBO);
            abilityReqBO.setExpTime(ActDateUtils.dateAddDay(abilityReqBO.getEffTime(), dictionaryByBO == null || StringUtils.isBlank((CharSequence)dictionaryByBO.getCode()) ? 7 : Integer.parseInt(dictionaryByBO.getCode())));
        }
        abilityReqBO.setExpTime(DateUtils.strToDateLong((String)DateUtils.getCurrentMaxDate((String)DateUtils.dateToStrLong((Date)abilityReqBO.getExpTime()))));
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getActTemplateBOList())) {
            throw new BusinessException("14001", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2[actTemplateBOList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

