/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActActivityCheckAtomService;
import com.tydic.newretail.atom.ActQryTemplateAtomService;
import com.tydic.newretail.atom.ActQryTemplateGroupAtomService;
import com.tydic.newretail.atom.bo.ActActiveTemplateCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActActiveTemplateCheckAtomRspBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomRspBO;
import com.tydic.newretail.atom.bo.ActQryTemplateAtomReqBO;
import com.tydic.newretail.atom.bo.ActQryTemplateAtomRspBO;
import com.tydic.newretail.atom.bo.ActQryTemplateGroupAtomReqBO;
import com.tydic.newretail.atom.bo.ActQryTemplateGroupAtomRspBO;
import com.tydic.newretail.common.bo.ActDiscountBO;
import com.tydic.newretail.common.bo.ActTemplateAttrBO;
import com.tydic.newretail.common.bo.ActTemplateBO;
import com.tydic.newretail.common.bo.ActTemplateGroupBO;
import com.tydic.newretail.common.bo.ActiveGiftBO;
import com.tydic.newretail.common.bo.ActiveGiftPkgBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActivityCheckAtomService")
public class ActActivityCheckAtomServiceImpl
implements ActActivityCheckAtomService {
    @Autowired
    private ActQryTemplateGroupAtomService actQryTemplateGroupAtomService;
    @Autowired
    private ActQryTemplateAtomService actQryTemplateAtomService;

    @Override
    public ActCreateActivityCheckAtomRspBO checkCreateActivityInfo(ActCreateActivityCheckAtomReqBO atomReqBO) {
        if (null == atomReqBO) {
            throw new BusinessException("14000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ActCreateActivityCheckAtomRspBO atomRspBO = new ActCreateActivityCheckAtomRspBO();
        ArrayList<ActDiscountBO> actDiscountBOs = new ArrayList<ActDiscountBO>();
        atomRspBO.setActDiscountBOs(actDiscountBOs);
        this.checkActiveTemplateGroup(atomReqBO, actDiscountBOs);
        this.checkActiveTemplate(atomReqBO.getActTemplateBOS(), actDiscountBOs);
        this.checkActiveGift(atomReqBO.getActiveGiftList());
        this.checkActiveGiftPkg(atomReqBO.getActiveGiftPkgList());
        atomRspBO.setActTemplateGroupBOList(atomReqBO.getActTemplateGroupBOList());
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6821\u9a8c\u6210\u529f");
        return atomRspBO;
    }

    @Override
    public ActActiveTemplateCheckAtomRspBO checkTemplateInfoByType(ActActiveTemplateCheckAtomReqBO atomReqBO) {
        ArrayList<ActDiscountBO> actDiscountBOs = new ArrayList<ActDiscountBO>();
        ActActiveTemplateCheckAtomRspBO atomRspBO = new ActActiveTemplateCheckAtomRspBO();
        if ("operTemplate".equals(atomReqBO.getOperType()) && CollectionUtils.isNotEmpty(atomReqBO.getActTemplateBOS())) {
            HashSet<Long> set = new HashSet<Long>();
            for (ActTemplateBO actTemplateBO : atomReqBO.getActTemplateBOS()) {
                if (null == actTemplateBO.getTemplateId()) {
                    throw new BusinessException("14001", "\u5165\u53c2\u7684\u6a21\u677fID[templateId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (CollectionUtils.isEmpty((Collection)actTemplateBO.getActTemplateAttrBOS())) {
                    throw new BusinessException("14001", "\u5165\u53c2\u7684\u6d3b\u52a8\u6a21\u7248\u5c5e\u6027BO\u96c6\u5408[actTemplateAttrBOS]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                set.add(actTemplateBO.getTemplateId());
            }
            if (set.size() < atomReqBO.getActTemplateBOS().size()) {
                throw new BusinessException("14033", "\u6a21\u677f\u914d\u7f6e\u91cd\u590d");
            }
            ActQryTemplateAtomReqBO actQryTemplateAtomReqBO = new ActQryTemplateAtomReqBO();
            actQryTemplateAtomReqBO.setTemplateIds(set);
            ActQryTemplateAtomRspBO actQryTemplateAtomRspBO = this.actQryTemplateAtomService.qryTemplate(actQryTemplateAtomReqBO);
            if (CollectionUtils.isEmpty((Collection)actQryTemplateAtomRspBO.getRows())) {
                throw new BusinessException("14031", "\u6682\u4e0d\u652f\u6301\u6a21\u677f\u914d\u7f6e");
            }
            this.checkTemplate(actQryTemplateAtomRspBO.getRows(), atomReqBO.getActTemplateBOS(), actDiscountBOs);
        }
        if ("operTemplateGroup".equals(atomReqBO.getOperType()) && CollectionUtils.isNotEmpty(atomReqBO.getActTemplateGroupList())) {
            ActCreateActivityCheckAtomReqBO actCreateActivityCheckAtomReqBO = new ActCreateActivityCheckAtomReqBO();
            actCreateActivityCheckAtomReqBO.setActTemplateGroupBOList(atomReqBO.getActTemplateGroupList());
            this.checkActiveTemplateGroup(actCreateActivityCheckAtomReqBO, actDiscountBOs);
        }
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6a21\u677f\u6821\u9a8c\u6210\u529f");
        return atomRspBO;
    }

    private void checkActiveTemplate(List<ActTemplateBO> paramActTemplateBOS, List<ActDiscountBO> actDiscountBOs) {
        ActQryTemplateAtomReqBO actQryTemplateAtomReqBO = new ActQryTemplateAtomReqBO();
        ActQryTemplateAtomRspBO atomRspBO = this.actQryTemplateAtomService.qryTemplate(actQryTemplateAtomReqBO);
        if (CollectionUtils.isEmpty((Collection)atomRspBO.getRows())) {
            throw new BusinessException("14031", "\u6a21\u677f\u672a\u914d\u7f6e");
        }
        this.checkTemplate(atomRspBO.getRows(), paramActTemplateBOS, actDiscountBOs);
    }

    private void checkActiveTemplateGroup(ActCreateActivityCheckAtomReqBO atomReqBO, List<ActDiscountBO> actDiscountBOs) {
        List<ActTemplateGroupBO> actTemplateGroupBOList = atomReqBO.getActTemplateGroupBOList();
        if (!CollectionUtils.isEmpty(actTemplateGroupBOList)) {
            ActQryTemplateGroupAtomReqBO atomReqBO1 = new ActQryTemplateGroupAtomReqBO();
            BeanUtils.copyProperties((Object)atomReqBO, (Object)atomReqBO1);
            ActQryTemplateGroupAtomRspBO atomRspBO = this.actQryTemplateGroupAtomService.qryTemplateGroup(atomReqBO1);
            List confActTemplateGroupBOList = atomRspBO.getRows();
            HashMap<Long, ActTemplateGroupBO> confActTemplateGroupMap = new HashMap<Long, ActTemplateGroupBO>();
            if (!CollectionUtils.isEmpty((Collection)confActTemplateGroupBOList)) {
                for (ActTemplateGroupBO actTemplateGroupBO : confActTemplateGroupBOList) {
                    confActTemplateGroupMap.put(actTemplateGroupBO.getTemplateGroupId(), actTemplateGroupBO);
                }
            }
            for (ActTemplateGroupBO actTemplateGroupBO : actTemplateGroupBOList) {
                if (!CollectionUtils.isEmpty((Collection)actTemplateGroupBO.getActiveGiftList())) {
                    this.checkActiveGift(actTemplateGroupBO.getActiveGiftList());
                }
                if (!CollectionUtils.isEmpty((Collection)actTemplateGroupBO.getActiveGiftPkgList())) {
                    this.checkActiveGiftPkg(actTemplateGroupBO.getActiveGiftPkgList());
                }
                if (actTemplateGroupBO.getTemplateGroupId() == null) {
                    throw new BusinessException("14001", "\u6a21\u677f\u7ec4ID\u4e3a\u7a7a");
                }
                ActTemplateGroupBO confActTemplateGroupBO = (ActTemplateGroupBO)confActTemplateGroupMap.get(actTemplateGroupBO.getTemplateGroupId());
                if (confActTemplateGroupBO == null) {
                    throw new BusinessException("14030", "\u6a21\u677f\u7ec4\u3010" + actTemplateGroupBO.getTemplateGroupId() + "\u3011\u672a\u914d\u7f6e");
                }
                this.checkTemplate(confActTemplateGroupBO.getActTemplateBOS(), actTemplateGroupBO.getActTemplateBOS(), actDiscountBOs);
                actTemplateGroupBO.setTemplateGroupOrder(confActTemplateGroupBO.getTemplateGroupOrder());
                actTemplateGroupBO.setTemplateGroupType(confActTemplateGroupBO.getTemplateGroupType());
            }
        }
    }

    private void checkTemplate(List<ActTemplateBO> confActTemplateBOS, List<ActTemplateBO> paramActTemplateBOS, List<ActDiscountBO> actDiscountBOs) {
        HashMap<Long, ActTemplateBO> confTemplateMap = new HashMap<Long, ActTemplateBO>();
        if (!CollectionUtils.isEmpty(confActTemplateBOS)) {
            for (ActTemplateBO actTemplateBO : confActTemplateBOS) {
                confTemplateMap.put(actTemplateBO.getTemplateId(), actTemplateBO);
            }
        }
        if (!CollectionUtils.isEmpty(paramActTemplateBOS)) {
            for (ActTemplateBO paramActTemplateBO : paramActTemplateBOS) {
                if (paramActTemplateBO.getTemplateId() == null) {
                    throw new BusinessException("14001", "\u6a21\u677fID\u4e3a\u7a7a");
                }
                ActTemplateBO confActTemplateBO = (ActTemplateBO)confTemplateMap.get(paramActTemplateBO.getTemplateId());
                if (null == confActTemplateBO) {
                    throw new BusinessException("14031", "\u6a21\u677f\u3010" + paramActTemplateBO.getTemplateId() + "\u3011\u672a\u914d\u7f6e");
                }
                this.commonCheckTemplateAttr(confActTemplateBO, paramActTemplateBO);
                Integer validMod = confActTemplateBO.getValidMod();
                switch (validMod) {
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        break;
                    }
                    default: {
                        this.systemCheckActiveTemplateAttr(paramActTemplateBO, actDiscountBOs);
                    }
                }
                paramActTemplateBO.setTemplateType(confActTemplateBO.getTemplateType());
                paramActTemplateBO.setTemplateOrder(confActTemplateBO.getTemplateOrder());
            }
        }
    }

    private void commonCheckTemplateAttr(ActTemplateBO confActTemplateBO, ActTemplateBO paramActTemplateBO) {
        List confActTemplateAttrBOS = confActTemplateBO.getActTemplateAttrBOS();
        List paramActTemplateAttrBOS = paramActTemplateBO.getActTemplateAttrBOS();
        if (!CollectionUtils.isEmpty((Collection)confActTemplateAttrBOS) && CollectionUtils.isEmpty((Collection)paramActTemplateAttrBOS)) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)confActTemplateAttrBOS) && !CollectionUtils.isEmpty((Collection)paramActTemplateAttrBOS)) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u5fc5\u987b\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)confActTemplateAttrBOS) && !CollectionUtils.isEmpty((Collection)paramActTemplateAttrBOS)) {
            if (confActTemplateAttrBOS.size() != paramActTemplateAttrBOS.size()) {
                throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u6570\u91cf\u4e0d\u5339\u914d");
            }
            HashMap<String, ActTemplateAttrBO> confTemplateAttrMap = new HashMap<String, ActTemplateAttrBO>();
            for (ActTemplateAttrBO actTemplateAttrBO : confActTemplateAttrBOS) {
                confTemplateAttrMap.put(actTemplateAttrBO.getAttrCode(), actTemplateAttrBO);
            }
            for (ActTemplateAttrBO paramActTemplateAttrBO : paramActTemplateAttrBOS) {
                if (StringUtils.isBlank((CharSequence)paramActTemplateAttrBO.getAttrCode())) {
                    throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u7f16\u7801[attrCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ActTemplateAttrBO confActTemplateAttrBO = (ActTemplateAttrBO)confTemplateAttrMap.get(paramActTemplateAttrBO.getAttrCode());
                if (null == confActTemplateAttrBO) {
                    throw new BusinessException("14032", "\u6a21\u677f\u5c5e\u6027\u3010" + paramActTemplateAttrBO.getAttrCode() + "\u3011\u914d\u7f6e\u672a\u914d\u7f6e");
                }
                if (confActTemplateAttrBO.getAttrNotNull() != null && confActTemplateAttrBO.getAttrNotNull() == 1 && StringUtils.isBlank((CharSequence)paramActTemplateAttrBO.getParaValue())) {
                    throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u503c[paraValue]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isNotBlank((CharSequence)confActTemplateAttrBO.getAttrValidReg())) {
                    String content = paramActTemplateAttrBO.getParaValue();
                    String pattern = confActTemplateAttrBO.getAttrValidReg();
                    boolean isMatch = Pattern.matches(pattern, content);
                    if (!isMatch) {
                        throw new BusinessException("14001", paramActTemplateAttrBO.getAttrValidDesc());
                    }
                }
                paramActTemplateAttrBO.setAttrName(confActTemplateAttrBO.getAttrName());
            }
        }
    }

    private void systemCheckActiveTemplateAttr(ActTemplateBO paramActTemplateBO, List<ActDiscountBO> actDiscountBOs) {
        List actTemplateAttrBOS = paramActTemplateBO.getActTemplateAttrBOS();
        if (!CollectionUtils.isEmpty((Collection)actTemplateAttrBOS)) {
            HashMap<String, ActTemplateAttrBO> codeMap = new HashMap<String, ActTemplateAttrBO>();
            for (ActTemplateAttrBO actTemplateAttrBO : actTemplateAttrBOS) {
                codeMap.put(actTemplateAttrBO.getAttrCode(), actTemplateAttrBO);
            }
            Long templateId = paramActTemplateBO.getTemplateId();
            ActDiscountBO actDiscountBO = new ActDiscountBO();
            if (ActCommConstant.ActivityTempIdDefine.MONEY_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkMoneyFullReduction(codeMap, actDiscountBO);
                actDiscountBO.setConditionType(ActCommConstant.ActiveTemplateConditionType.MONEY);
                actDiscountBO.setDiscountType(ActCommConstant.ActiveTemplateDiscountType.MONEY);
                actDiscountBOs.add(actDiscountBO);
            }
            if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkCountFullReduction(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.FEE_FULL_REDUCTION_DISCOUNT_ID.equals(templateId)) {
                this.checkFeeFullReductionDiscount(codeMap, actDiscountBO);
                actDiscountBO.setConditionType(ActCommConstant.ActiveTemplateConditionType.MONEY);
                actDiscountBO.setDiscountType(ActCommConstant.ActiveTemplateDiscountType.DISCOUNT);
                actDiscountBOs.add(actDiscountBO);
            }
            if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_DISCOUNT_ID.equals(templateId)) {
                this.checkCountFullReductionDiscount(codeMap, actDiscountBO);
                actDiscountBO.setConditionType(ActCommConstant.ActiveTemplateConditionType.ACOUNT);
                actDiscountBO.setDiscountType(ActCommConstant.ActiveTemplateDiscountType.DISCOUNT);
                actDiscountBOs.add(actDiscountBO);
            }
            if (ActCommConstant.ActivityTempIdDefine.FEE_FULL_GIVE_ID.equals(templateId)) {
                this.checkFeeFullGive(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_GIVE_ID.equals(templateId)) {
                this.checkCountFullGive(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_MONEY_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkLadderMoneyFullReduction(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_COUNT_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkLadderCountFullReduction(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_MONEY_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkLadderFeeFullReductionDiscount(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_FULL_REDUCTION_DISCOUNT_ID.equals(templateId)) {
                this.checkLadderCountFullReductionDiscount(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_FEE_FULL_GIVE_ID.equals(templateId)) {
                this.checkLadderFeeFullGive(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_COUNT_FULL_GIVE_ID.equals(templateId)) {
                this.checkLadderCountFullGive(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_MONEY_ID.equals(templateId)) {
                this.checkCountFullReductionMoneyId(codeMap, actDiscountBO);
                actDiscountBO.setConditionType(ActCommConstant.ActiveTemplateConditionType.ACOUNT);
                actDiscountBO.setDiscountType(ActCommConstant.ActiveTemplateDiscountType.MONEY);
                actDiscountBOs.add(actDiscountBO);
            }
        }
    }

    private void checkLadderCountFullGive(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_end");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachEnd = new BigDecimal(bo1.getParaValue());
        if (countReachStar.compareTo(countReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u6570\u91cf");
        }
    }

    private void checkLadderFeeFullGive(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_end");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachEnd = new BigDecimal(bo1.getParaValue());
        if (feeReachStar.compareTo(feeReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u91d1\u989d");
        }
    }

    private void checkLadderCountFullReductionDiscount(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo2 = codeMap.get("count_reach_end");
        if (bo2 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo2.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachEnd = new BigDecimal(bo2.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_discountRate");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_discountRate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachDisRate = new BigDecimal(bo1.getParaValue());
        if (countReachDisRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (countReachDisRate.compareTo(BigDecimal.ONE) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (countReachStar.compareTo(countReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u6570\u91cf");
        }
    }

    private void checkLadderFeeFullReductionDiscount(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo2 = codeMap.get("fee_reach_end");
        if (bo2 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo2.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachEnd = new BigDecimal(bo2.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discountRate");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discountRate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachDisRate = new BigDecimal(bo1.getParaValue());
        if (feeReachDisRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (feeReachDisRate.compareTo(BigDecimal.ONE) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (feeReachStar.compareTo(feeReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u91d1\u989d");
        }
    }

    private void checkLadderCountFullReduction(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo2 = codeMap.get("count_reach_end");
        if (bo2 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo2.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachEnd = new BigDecimal(bo2.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachDis = new BigDecimal(bo1.getParaValue());
        if (countReachDis.compareTo(countReachStar) == 1) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u8d77\u59cb\u6761\u4ef6\u6570\u91cf");
        }
        if (countReachStar.compareTo(countReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u6570\u91cf");
        }
    }

    private void checkLadderMoneyFullReduction(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo2 = codeMap.get("fee_reach_end");
        if (bo2 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo2.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachEnd = new BigDecimal(bo2.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachDis = new BigDecimal(bo1.getParaValue());
        if (feeReachDis.compareTo(feeReachStar) == 1) {
            throw new BusinessException("14001", "\u4f18\u60e0\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8d77\u59cb\u6761\u4ef6\u91d1\u989d");
        }
        if (feeReachStar.compareTo(feeReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u91d1\u989d");
        }
    }

    private void checkCountFullGive(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkFeeFullGive(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkCountFullReductionDiscount(Map<String, ActTemplateAttrBO> codeMap, ActDiscountBO actDiscountBO) {
        ActTemplateAttrBO bo = codeMap.get("count_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setConditionValue(bo.getParaValue());
        BigDecimal countReach = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_discountRate");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_discountRate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setDiscountValue(bo1.getParaValue());
        BigDecimal countReachDisRate = new BigDecimal(bo1.getParaValue());
        if (countReachDisRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (countReachDisRate.compareTo(BigDecimal.ONE) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5927\u4e8e1");
        }
    }

    private void checkFeeFullReductionDiscount(Map<String, ActTemplateAttrBO> codeMap, ActDiscountBO actDiscountBO) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setConditionValue(bo.getParaValue());
        BigDecimal feeReach = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discountRate");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discountRate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setDiscountValue(bo1.getParaValue());
        BigDecimal feeReachDisRate = new BigDecimal(bo1.getParaValue());
        if (feeReachDisRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (feeReachDisRate.compareTo(BigDecimal.ONE) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5927\u4e8e1");
        }
    }

    private void checkCountFullReduction(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReach = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachDis = new BigDecimal(bo1.getParaValue());
        if (countReachDis.compareTo(countReach) == 1) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u6761\u4ef6\u6570\u91cf");
        }
    }

    private void checkMoneyFullReduction(Map<String, ActTemplateAttrBO> codeMap, ActDiscountBO actDiscountBO) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setConditionValue(bo.getParaValue());
        BigDecimal feeReach = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setDiscountValue(bo1.getParaValue());
        BigDecimal feeReachDis = new BigDecimal(bo1.getParaValue());
        if (feeReachDis.compareTo(feeReach) == 1) {
            throw new BusinessException("14001", "\u4f18\u60e0\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6761\u4ef6\u91d1\u989d");
        }
    }

    private void checkCountFullReductionMoneyId(Map<String, ActTemplateAttrBO> codeMap, ActDiscountBO actDiscountBO) {
        ActTemplateAttrBO bo = codeMap.get("count_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setConditionValue(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setDiscountValue(bo1.getParaValue());
    }

    private void checkActiveGift(List<ActiveGiftBO> activeGiftList) {
        if (!CollectionUtils.isEmpty(activeGiftList)) {
            HashSet<String> skuIds = new HashSet<String>();
            for (ActiveGiftBO activeGiftBO : activeGiftList) {
                if (StringUtils.isBlank((CharSequence)activeGiftBO.getSkuId())) {
                    throw new BusinessException("14001", "\u6d3b\u52a8\u8d60\u54c1\u96c6\u5408[activeGiftList]\u4e2d\u7684\u8d60\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                skuIds.add(activeGiftBO.getSkuId());
            }
            if (skuIds.size() != activeGiftList.size()) {
                throw new BusinessException("14002", "\u6d3b\u52a8\u8d60\u54c1\u96c6\u5408[activeGiftList]\u4e2d\u7684\u8d60\u54c1ID[skuId]\u91cd\u590d");
            }
        }
    }

    private void checkActiveGiftPkg(List<ActiveGiftPkgBO> activeGiftPkgBOS) {
        if (!CollectionUtils.isEmpty(activeGiftPkgBOS)) {
            for (ActiveGiftPkgBO activeGiftPkgBO : activeGiftPkgBOS) {
                if (null == activeGiftPkgBO.getOptionMark()) {
                    throw new BusinessException("14002", "\u6d3b\u52a8\u8d60\u54c1\u5305\u96c6\u5408[activeGiftPkgList]\u4e2d\u7684\u8d60\u54c1\u5305\u9009\u62e9\u6807\u5fd7[optionMark]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (CollectionUtils.isEmpty((Collection)activeGiftPkgBO.getGiftList())) {
                    throw new BusinessException("14002", "\u6d3b\u52a8\u8d60\u54c1\u5305\u96c6\u5408[activeGiftPkgList]\u4e2d\u7684\u8d60\u54c1\u5217\u8868[giftList]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                this.checkActiveGift(activeGiftPkgBO.getGiftList());
            }
        }
    }
}

