/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.atom.ActActivityCheckAtomService;
import com.tydic.newretail.atom.ActAddActiveCouponCommAtomService;
import com.tydic.newretail.atom.bo.ActAddActiveCouponCommAtomReqBO;
import com.tydic.newretail.atom.bo.ActAddActiveCouponCommAtomRspBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCreateActivityCheckAtomRspBO;
import com.tydic.newretail.busi.ActCreateCouponBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiRspBO;
import com.tydic.newretail.common.bo.ActDiscountBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponNumMapper;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.CouponNumPO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponBusiService")
public class ActCreateCouponBusiServiceImpl
implements ActCreateCouponBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateCouponBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Autowired
    private CouponNumMapper couponNumMapper;
    @Autowired
    private ActActivityCheckAtomService actActivityCheckAtomService;
    @Autowired
    private ActAddActiveCouponCommAtomService actAddActiveCouponCommAtomService;
    @Value(value="${couponDetailUrl}")
    private String couponDetailUrl;

    public ActCreateCouponBusiRspBO createCoupon(ActCreateCouponBusiReqBO busiReqBO) {
        ActCreateCouponBusiRspBO rsp = new ActCreateCouponBusiRspBO();
        ActCreateActivityCheckAtomReqBO checkAtomReqBO = new ActCreateActivityCheckAtomReqBO();
        checkAtomReqBO.setActTemplateBOS(busiReqBO.getActTemplateBOList());
        ActCreateActivityCheckAtomRspBO checkAtomRspBO = this.actActivityCheckAtomService.checkCreateActivityInfo(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            LOGGER.error("\u4f18\u60e0\u5238\u65b0\u589e\u6821\u9a8c\u5931\u8d25" + checkAtomRspBO.getRespDesc());
            BeanUtils.copyProperties((Object)((Object)checkAtomRspBO), (Object)rsp);
            return rsp;
        }
        Long fmId = Sequence.getInstance().nextId();
        CouponFormPO couponFormPO = this.buildCouponFormPO(busiReqBO, checkAtomRspBO);
        couponFormPO.setFmId(fmId);
        couponFormPO.setDetailUrl(this.couponDetailUrl + "fmId=" + fmId + "&orgIdIn=" + couponFormPO.getAdmOrgId());
        int isInsert = this.couponFormMapper.insert(couponFormPO);
        if (isInsert < 1) {
            throw new BusinessException("0101", "\u4f18\u60e0\u5377\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        ActAddActiveCouponCommAtomReqBO actAddActiveCouponCommAtomReqBO = new ActAddActiveCouponCommAtomReqBO();
        actAddActiveCouponCommAtomReqBO.setActiveId(fmId);
        actAddActiveCouponCommAtomReqBO.setMarketingType("11");
        actAddActiveCouponCommAtomReqBO.setActTemplateBOList(busiReqBO.getActTemplateBOList());
        actAddActiveCouponCommAtomReqBO.setMemRangeList(busiReqBO.getMemRangeList());
        actAddActiveCouponCommAtomReqBO.setShowPozitonList(busiReqBO.getShowPozitonList());
        actAddActiveCouponCommAtomReqBO.setSkuInfoList(busiReqBO.getSkuInfoList());
        actAddActiveCouponCommAtomReqBO.setOperActiveTemplate("operTemplate");
        actAddActiveCouponCommAtomReqBO.setOrgIdIn(busiReqBO.getOrgIdIn());
        actAddActiveCouponCommAtomReqBO.setMemIdIn(busiReqBO.getMemIdIn());
        actAddActiveCouponCommAtomReqBO.setOperType("add");
        ActAddActiveCouponCommAtomRspBO atomRspBO = this.actAddActiveCouponCommAtomService.addActiveOrCouponCommonInfo(actAddActiveCouponCommAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException("0101", "\u4f18\u60e0\u5377\u6d3b\u52a8\u516c\u5171\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
        }
        CouponNumPO couponNumPO = new CouponNumPO();
        couponNumPO.setAmountTotalId(Sequence.getInstance().nextId());
        couponNumPO.setFmId(fmId);
        couponNumPO.setTotalNum(busiReqBO.getTotalAmount());
        if (null == couponNumPO.getTotalNum()) {
            couponNumPO.setTotalNum(0L);
        }
        couponNumPO.setMemLimitNum(busiReqBO.getMemLimitAmount());
        if (null == couponNumPO.getMemLimitNum()) {
            couponNumPO.setMemLimitNum(0);
        }
        couponNumPO.setSendNum(0L);
        couponNumPO.setUsedNum(0L);
        if (null == couponNumPO.getTotalNum()) {
            couponNumPO.setTotalNum(0L);
        }
        couponNumPO.setAdmOrgId(busiReqBO.getOrgIdIn());
        int isInsert4 = this.couponNumMapper.insert(couponNumPO);
        if (isInsert4 < 1) {
            throw new BusinessException("0101", "\u4f18\u60e0\u5377\u6570\u91cf\u63a7\u5236\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f18\u60e0\u5238\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
        return rsp;
    }

    private CouponFormPO buildCouponFormPO(ActCreateCouponBusiReqBO busiReqBO, ActCreateActivityCheckAtomRspBO checkAtomRspBO) {
        CouponFormPO couponFormPO = new CouponFormPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)couponFormPO);
        couponFormPO.setAdmOrgId(busiReqBO.getOrgIdIn());
        couponFormPO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
        couponFormPO.setState(ActCommConstant.CouponFormState.AUDIT_PASS);
        if (!CollectionUtils.isEmpty(checkAtomRspBO.getActDiscountBOs())) {
            String fmDesc = "\u6ee1";
            ActDiscountBO actDiscountBO = checkAtomRspBO.getActDiscountBOs().get(0);
            couponFormPO.setConditionType(actDiscountBO.getConditionType());
            if (StringUtils.isNotBlank((CharSequence)actDiscountBO.getConditionValue())) {
                couponFormPO.setConditionValue(actDiscountBO.getConditionValue());
                fmDesc = fmDesc + actDiscountBO.getConditionValue();
            }
            if (ActCommConstant.ActiveTemplateConditionType.MONEY.equals(actDiscountBO.getConditionType())) {
                fmDesc = fmDesc + "\u5143\u53ef\u7528";
            } else if (ActCommConstant.ActiveTemplateConditionType.ACOUNT.equals(actDiscountBO.getConditionType())) {
                fmDesc = fmDesc + "\u4ef6\u53ef\u7528";
            }
            couponFormPO.setDiscountType(actDiscountBO.getDiscountType());
            couponFormPO.setDiscountValue(actDiscountBO.getDiscountValue());
            couponFormPO.setFmDesc(fmDesc);
            couponFormPO.setCreateTime(new Date());
        }
        return couponFormPO;
    }
}

